/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.opengl.Matrix;
import androidx.benchmark.BenchmarkState;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/ThrottleDetector;", "", "()V", "initNs", "", "computeThrottleBaseline", "", "copySomeData", "isDeviceThermalThrottled", "", "measureWorkNs", "benchmark-common_release"})
public final class ThrottleDetector {
    @NotNull
    public static final ThrottleDetector INSTANCE = new ThrottleDetector();
    private static long initNs;

    private ThrottleDetector() {
    }

    private final void copySomeData() {
        byte[] a = new byte[400000];
        byte[] b = new byte[400000];
        int n = 0;
        do {
            int i = n++;
            System.arraycopy(a, 0, b, 0, a.length);
        } while (n <= 9);
    }

    private final long measureWorkNs() {
        this.copySomeData();
        BenchmarkState state = new BenchmarkState();
        state.setSimplifiedTimingOnlyMode$benchmark_common_release(true);
        int n = 0;
        float[] fArray = new float[16];
        while (n < 16) {
            int n2 = n++;
            fArray[n2] = System.nanoTime();
        }
        float[] sourceMatrix = fArray;
        float[] resultMatrix = new float[16];
        while (true) {
            boolean bl;
            BenchmarkState this_$iv = state;
            boolean $i$f$keepRunningInline = false;
            if (this_$iv.iterationsRemaining > 1) {
                BenchmarkState benchmarkState = this_$iv;
                int n3 = benchmarkState.iterationsRemaining;
                benchmarkState.iterationsRemaining = n3 + -1;
                bl = true;
            } else {
                bl = this_$iv.keepRunningInternal();
            }
            if (!bl) break;
            Matrix.translateM((float[])resultMatrix, (int)0, (float[])sourceMatrix, (int)0, (float)1.0f, (float)2.0f, (float)3.0f);
        }
        return state.getMinTimeNanos();
    }

    public final void computeThrottleBaseline() {
        if (initNs == 0L) {
            initNs = this.measureWorkNs();
        }
    }

    public final boolean isDeviceThermalThrottled() {
        if (initNs == 0L) {
            return false;
        }
        long workNs = this.measureWorkNs();
        return (double)workNs > (double)initNs * 1.1;
    }
}

