/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.Activity;
import android.app.Application;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;
import androidx.annotation.AnyThread;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.benchmark.Api24Kt;
import androidx.benchmark.Api27Kt;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.R;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010\u000b\u001a\u00020\u0006H\u0014J\b\u0010\f\u001a\u00020\u0006H\u0014J\b\u0010\r\u001a\u00020\u0006H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/IsolationActivity;", "Landroid/app/Activity;", "()V", "destroyed", "", "actuallyFinish", "", "finish", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPause", "onResume", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class IsolationActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean destroyed;
    @NotNull
    private static final String TAG = "Benchmark";
    @NotNull
    private static final AtomicReference<IsolationActivity> singleton = new AtomicReference();
    private static boolean firstInit = true;
    private static boolean sustainedPerformanceModeInUse;
    private static boolean resumed;
    @NotNull
    private static final Companion.activityLifecycleCallbacks.1 activityLifecycleCallbacks;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        IsolationActivity old;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.isolation_activity);
        this.overridePendingTransition(0, 0);
        if (firstInit) {
            if (!CpuInfo.INSTANCE.getLocked() && Companion.isSustainedPerformanceModeSupported$benchmark_common_release()) {
                sustainedPerformanceModeInUse = true;
            }
            this.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityLifecycleCallbacks);
            activityLifecycleCallbacks.onActivityCreated(this, savedInstanceState);
            if (sustainedPerformanceModeInUse) {
                ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"BenchSpinThread", (int)0, (Function0)onCreate.1.INSTANCE, (int)23, null);
            }
            firstInit = false;
        }
        if ((old = singleton.getAndSet(this)) != null && !old.destroyed && !old.isFinishing()) {
            throw new IllegalStateException("Only one IsolationActivity should exist");
        }
        ((TextView)this.findViewById(R.id.clock_state)).setText(CpuInfo.INSTANCE.getLocked() ? (CharSequence)"Locked Clocks" : (sustainedPerformanceModeInUse ? (CharSequence)"Sustained Performance Mode" : (CharSequence)""));
    }

    protected void onResume() {
        super.onResume();
        resumed = true;
    }

    protected void onPause() {
        super.onPause();
        resumed = false;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.destroyed = true;
    }

    public void finish() {
    }

    public final void actuallyFinish() {
        this.overridePendingTransition(0, 0);
        super.finish();
    }

    static {
        activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                if (IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release() && Build.VERSION.SDK_INT >= 24) {
                    Api24Kt.setSustainedPerformanceMode(activity, true);
                }
                if (Build.VERSION.SDK_INT >= 27) {
                    Api27Kt.requestDismissKeyguard(activity);
                    Api27Kt.setShowWhenLocked(activity);
                    Api27Kt.setTurnScreenOn(activity);
                    activity.getWindow().addFlags(128);
                } else {
                    activity.getWindow().addFlags(0x680080);
                }
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle bundle) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\r\u0010\u0017\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/IsolationActivity$Companion;", "", "()V", "TAG", "", "activityLifecycleCallbacks", "androidx/benchmark/IsolationActivity$Companion$activityLifecycleCallbacks$1", "Landroidx/benchmark/IsolationActivity$Companion$activityLifecycleCallbacks$1;", "firstInit", "", "<set-?>", "resumed", "getResumed", "()Z", "singleton", "Ljava/util/concurrent/atomic/AtomicReference;", "Landroidx/benchmark/IsolationActivity;", "getSingleton$benchmark_common_release", "()Ljava/util/concurrent/atomic/AtomicReference;", "sustainedPerformanceModeInUse", "getSustainedPerformanceModeInUse$benchmark_common_release", "finishSingleton", "", "isSustainedPerformanceModeSupported", "isSustainedPerformanceModeSupported$benchmark_common_release", "launchSingleton", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicReference<IsolationActivity> getSingleton$benchmark_common_release() {
            return singleton;
        }

        public final boolean getSustainedPerformanceModeInUse$benchmark_common_release() {
            return sustainedPerformanceModeInUse;
        }

        public final boolean getResumed() {
            return resumed;
        }

        @WorkerThread
        public final void launchSingleton() {
            Intent intent = new Intent("android.intent.action.MAIN");
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$launchSingleton_u24lambda_u2d0 = intent;
            boolean bl3 = false;
            Log.d((String)IsolationActivity.TAG, (String)"launching Benchmark IsolationActivity");
            $this$launchSingleton_u24lambda_u2d0.setClassName(InstrumentationRegistry.getInstrumentation().getTargetContext().getPackageName(), IsolationActivity.class.getName());
            $this$launchSingleton_u24lambda_u2d0.addFlags(0x10000000);
            $this$launchSingleton_u24lambda_u2d0.addFlags(0x20000000);
            Intent intent2 = intent;
            InstrumentationRegistry.getInstrumentation().startActivitySync(intent2);
        }

        @AnyThread
        public final void finishSingleton() {
            Log.d((String)IsolationActivity.TAG, (String)"Benchmark runner being destroyed, tearing down activities");
            IsolationActivity isolationActivity = this.getSingleton$benchmark_common_release().getAndSet(null);
            if (isolationActivity != null) {
                IsolationActivity isolationActivity2 = isolationActivity;
                boolean bl = false;
                boolean bl2 = false;
                IsolationActivity $this$finishSingleton_u24lambda_u2d1 = isolationActivity2;
                boolean bl3 = false;
                $this$finishSingleton_u24lambda_u2d1.runOnUiThread(new Runnable($this$finishSingleton_u24lambda_u2d1){
                    final /* synthetic */ IsolationActivity $this_apply;
                    {
                        this.$this_apply = $receiver;
                    }

                    public final void run() {
                        this.$this_apply.actuallyFinish();
                    }
                });
            }
        }

        public final boolean isSustainedPerformanceModeSupported$benchmark_common_release() {
            boolean bl;
            if (Build.VERSION.SDK_INT >= 24) {
                Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
                Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"getInstrumentation()");
                bl = Api24Kt.isSustainedPerformanceModeSupported(instrumentation);
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

