/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Api21Kt;
import androidx.benchmark.Arguments;
import androidx.benchmark.InstrumentationResults;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\fJC\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00182!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/Outputs;", "", "()V", "dirUsableByAppAndShell", "Ljava/io/File;", "getDirUsableByAppAndShell", "()Ljava/io/File;", "formatter", "Ljava/text/SimpleDateFormat;", "outputDirectory", "getOutputDirectory", "dateToFileName", "", "date", "Ljava/util/Date;", "relativePathFor", "path", "sanitizeFilename", "filename", "testOutputFile", "writeFile", "fileName", "reportKey", "reportOnRunEndOnly", "", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Outputs {
    @NotNull
    public static final Outputs INSTANCE;
    @NotNull
    private static final SimpleDateFormat formatter;
    @NotNull
    private static final File outputDirectory;
    @NotNull
    private static final File dirUsableByAppAndShell;

    private Outputs() {
    }

    @NotNull
    public final File getOutputDirectory() {
        return outputDirectory;
    }

    @NotNull
    public final File getDirUsableByAppAndShell() {
        return dirUsableByAppAndShell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String writeFile(@NotNull String fileName, @NotNull String reportKey, boolean reportOnRunEndOnly, @NotNull Function1<? super File, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)reportKey, (String)"reportKey");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String sanitizedName = this.sanitizeFilename(fileName);
        boolean override = !Intrinsics.areEqual((Object)dirUsableByAppAndShell, (Object)outputDirectory);
        File file = new File(dirUsableByAppAndShell, sanitizedName);
        try {
            block.invoke((Object)file);
        }
        finally {
            Object actualOutputDirectory;
            File destination = file;
            if (override) {
                actualOutputDirectory = outputDirectory;
                destination = new File((File)actualOutputDirectory, sanitizedName);
                Log.d((String)"Benchmark", (String)("Copying " + file + " to " + destination));
                try {
                    destination.mkdirs();
                    FilesKt.copyTo$default((File)file, (File)destination, (boolean)true, (int)0, (int)4, null);
                }
                catch (Throwable exception) {
                    String message = StringsKt.trimIndent((String)("\n                        Unable to copy files to " + destination.getAbsolutePath() + ".\n                        Please pull the Macrobenchmark results manually by using:\n                        adb pull " + file.getAbsolutePath() + "\n                    "));
                    Log.e((String)"Benchmark", (String)message, (Throwable)exception);
                    destination = file;
                }
            }
            actualOutputDirectory = destination.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)actualOutputDirectory, (String)"destination.absolutePath");
            InstrumentationResults.INSTANCE.reportAdditionalFileToCopy(reportKey, (String)actualOutputDirectory, reportOnRunEndOnly);
            actualOutputDirectory = destination.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)actualOutputDirectory, (String)"destination.absolutePath");
            return actualOutputDirectory;
        }
    }

    public static /* synthetic */ String writeFile$default(Outputs outputs, String string, String string2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return outputs.writeFile(string, string2, bl, (Function1<? super File, Unit>)function1);
    }

    @NotNull
    public final String sanitizeFilename(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)filename, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"(", (String)"[", (boolean)false, (int)4, null), (String)")", (String)"]", (boolean)false, (int)4, null);
    }

    @NotNull
    public final File testOutputFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new File(outputDirectory, filename);
    }

    @NotNull
    public final String dateToFileName(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = formatter.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(date)");
        return string;
    }

    public static /* synthetic */ String dateToFileName$default(Outputs outputs, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date();
        }
        return outputs.dateToFileName(date);
    }

    @NotNull
    public final String relativePathFor(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = outputDirectory.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputDirectory.absolutePath");
        boolean hasOutputDirectoryPrefix = StringsKt.startsWith$default((String)path, (String)string, (boolean)false, (int)2, null);
        String relativePath = hasOutputDirectoryPrefix ? StringsKt.removePrefix((String)path, (CharSequence)Intrinsics.stringPlus((String)outputDirectory.getAbsolutePath(), (Object)"/")) : StringsKt.removePrefix((String)path, (CharSequence)Intrinsics.stringPlus((String)dirUsableByAppAndShell.getAbsolutePath(), (Object)"/"));
        boolean bl = !Intrinsics.areEqual((Object)relativePath, (Object)path);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = relativePath + " == " + path;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return relativePath;
    }

    static {
        File file;
        File file2;
        File file3;
        Object object;
        INSTANCE = new Outputs();
        formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (Build.VERSION.SDK_INT == 30) {
            object = InstrumentationRegistry.getInstrumentation().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstrumentation().context");
            file3 = Api21Kt.getFirstMountedMediaDir(object);
        } else {
            file3 = file2 = Build.VERSION.SDK_INT <= 22 ? InstrumentationRegistry.getInstrumentation().getContext().getCacheDir() : InstrumentationRegistry.getInstrumentation().getContext().getExternalCacheDir();
        }
        if (file2 == null) {
            throw new IllegalStateException("Unable to select a directory for writing files, additionalTestOutputDir argument required to declare output dir.");
        }
        dirUsableByAppAndShell = file2;
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Usable output directory: ", (Object)dirUsableByAppAndShell));
        object = Arguments.INSTANCE.getAdditionalTestOutputDir$benchmark_common_release();
        if (object == null) {
            file = null;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            file = new File((String)it);
        }
        file2 = file;
        outputDirectory = file2 == null ? dirUsableByAppAndShell : file2;
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Output Directory: ", (Object)outputDirectory));
    }
}

