/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.UiAutomation;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/benchmark/ShellImpl;", "", "()V", "uiAutomation", "Landroid/app/UiAutomation;", "kotlin.jvm.PlatformType", "executeShellCommand", "", "cmd", "benchmark-common_release"})
@RequiresApi(value=21)
final class ShellImpl {
    @NotNull
    public static final ShellImpl INSTANCE = new ShellImpl();
    private static final UiAutomation uiAutomation;

    private ShellImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String executeShellCommand(@NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        ParcelFileDescriptor parcelFileDescriptor = uiAutomation.executeShellCommand(cmd);
        Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ParcelFileDescriptor.AutoCloseInputStream inputStream = (ParcelFileDescriptor.AutoCloseInputStream)closeable;
            boolean bl3 = false;
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)((InputStream)inputStream));
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
            boolean bl4 = false;
            boolean bl5 = false;
            String string = new String(byArray, charset);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        boolean bl = !Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "ShellImpl must not be initialized on the UI thread - UiAutomation must not be connected on the main thread!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
    }
}

