/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.AllocationCountCapture;
import androidx.benchmark.Arguments;
import androidx.benchmark.BenchmarkResult;
import androidx.benchmark.BenchmarkResultKt;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.Errors;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.MetricCapture;
import androidx.benchmark.MetricsContainer;
import androidx.benchmark.Profiler;
import androidx.benchmark.ResultWriter;
import androidx.benchmark.Stats;
import androidx.benchmark.ThreadPriority;
import androidx.benchmark.ThrottleDetector;
import androidx.benchmark.TimeCapture;
import androidx.benchmark.WarmupManager;
import androidx.tracing.Trace;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Experimental;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 J2\u00020\u0001:\u0001JB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\u001f\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\r2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.H\u0082\bJ\b\u0010/\u001a\u00020(H\u0002J\b\u00100\u001a\u00020\u0007H\u0002J\b\u00101\u001a\u00020\rH\u0002J\u001d\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b6J\b\u00107\u001a\u00020\u001aH\u0007J\r\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\u0018\u00108\u001a\u0002092\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001fH\u0002J\u0006\u0010=\u001a\u00020\rJ\t\u0010>\u001a\u00020\rH\u0087\bJ\b\u0010?\u001a\u00020\rH\u0001J\u0006\u0010@\u001a\u00020(J \u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020\u001fH\u0007J\u0006\u0010E\u001a\u00020(J\u0010\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\u001aH\u0002J\b\u0010H\u001a\u00020\rH\u0002J\b\u0010I\u001a\u00020(H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\u00078\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Landroidx/benchmark/BenchmarkState;", "", "()V", "allData", "", "", "iterationsPerRepeat", "", "iterationsRemaining", "getIterationsRemaining$annotations", "metrics", "Landroidx/benchmark/MetricsContainer;", "paused", "", "repeatCount", "simplifiedTimingOnlyMode", "getSimplifiedTimingOnlyMode$benchmark_common_release", "()Z", "setSimplifiedTimingOnlyMode$benchmark_common_release", "(Z)V", "stages", "", "state", "stats", "Landroidx/benchmark/Stats;", "thermalThrottleSleepSeconds", "", "throttleRemainingRetries", "totalRunTimeNs", "totalRunTimeStartNs", "traceUniqueName", "", "getTraceUniqueName", "()Ljava/lang/String;", "setTraceUniqueName", "(Ljava/lang/String;)V", "warmupManager", "Landroidx/benchmark/WarmupManager;", "warmupRepeats", "afterBenchmark", "", "beforeBenchmark", "beginRunningStage", "check", "value", "lazyMessage", "Lkotlin/Function0;", "checkState", "computeMaxIterations", "endRunningStage", "getFullStatusReport", "Landroid/os/Bundle;", "key", "includeStats", "getFullStatusReport$benchmark_common_release", "getMinTimeNanos", "getReport", "Landroidx/benchmark/BenchmarkResult;", "getReport$benchmark_common_release", "testName", "className", "keepRunning", "keepRunningInline", "keepRunningInternal", "pauseTiming", "report", "fullClassName", "simpleClassName", "methodName", "resumeTiming", "sleepIfThermalThrottled", "sleepSeconds", "startNextRepeat", "throwIfPaused", "Companion", "benchmark-common_release"})
public final class BenchmarkState {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private List<MetricsContainer> stages;
    @NotNull
    private MetricsContainer metrics;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private String traceUniqueName;
    private int warmupRepeats;
    @JvmField
    public int iterationsRemaining;
    private int iterationsPerRepeat;
    private int state;
    @NotNull
    private final WarmupManager warmupManager;
    private boolean paused;
    private long thermalThrottleSleepSeconds;
    private long totalRunTimeStartNs;
    private long totalRunTimeNs;
    private int repeatCount;
    private boolean simplifiedTimingOnlyMode;
    private int throttleRemainingRetries;
    @NotNull
    private List<Stats> stats;
    @NotNull
    private List<long[]> allData;
    @NotNull
    public static final String TAG = "Benchmark";
    private static final int NOT_STARTED = -1;
    private static final int RUNNING_WARMUP_STAGE = 0;
    private static final int RUNNING_TIME_STAGE = 1;
    private static final int RUNNING_ALLOCATION_STAGE = 2;
    private static final int FINISHED = 3;
    private static final int REPEAT_COUNT_TIME;
    public static final int REPEAT_COUNT_ALLOCATION = 5;
    @Nullable
    private static final Integer OVERRIDE_ITERATIONS;
    private static final long REPEAT_DURATION_TARGET_NS;
    public static final int MAX_TEST_ITERATIONS = 1000000;
    public static final int MIN_TEST_ITERATIONS = 1;
    private static final int THROTTLE_MAX_RETRIES = 2;
    private static final long THROTTLE_BACKOFF_S = 90L;
    private static boolean firstBenchmark;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BenchmarkState() {
        Object[] objectArray = new MetricsContainer[3];
        MetricCapture[] metricCaptureArray = new MetricCapture[]{new TimeCapture()};
        objectArray[0] = new MetricsContainer(metricCaptureArray, 1);
        metricCaptureArray = new MetricCapture[]{new TimeCapture()};
        objectArray[1] = new MetricsContainer(metricCaptureArray, REPEAT_COUNT_TIME);
        metricCaptureArray = new MetricCapture[]{new AllocationCountCapture()};
        objectArray[2] = new MetricsContainer(metricCaptureArray, 5);
        this.stages = CollectionsKt.listOf((Object[])objectArray);
        this.metrics = this.stages.get(0);
        this.traceUniqueName = "benchmark";
        this.iterationsRemaining = -1;
        this.iterationsPerRepeat = 1;
        this.state = -1;
        this.warmupManager = new WarmupManager();
        this.throttleRemainingRetries = 2;
        boolean bl = false;
        this.stats = new ArrayList();
        bl = false;
        this.allData = new ArrayList();
    }

    @NotNull
    public final String getTraceUniqueName() {
        return this.traceUniqueName;
    }

    public final void setTraceUniqueName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.traceUniqueName = string;
    }

    @PublishedApi
    public static /* synthetic */ void getIterationsRemaining$annotations() {
    }

    public final boolean getSimplifiedTimingOnlyMode$benchmark_common_release() {
        return this.simplifiedTimingOnlyMode;
    }

    public final void setSimplifiedTimingOnlyMode$benchmark_common_release(boolean bl) {
        this.simplifiedTimingOnlyMode = bl;
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final long getMinTimeNanos() {
        Object element$iv2;
        block1: {
            this.checkState();
            Iterable $this$first$iv = this.stats;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Stats it = (Stats)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((Stats)element$iv2).getMin();
    }

    private final void checkState() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.state != -1;
        boolean $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string2 = string = "Attempting to interact with a benchmark that wasn't started!";
            throw new IllegalStateException(string2);
        }
        BenchmarkState this_$iv = this;
        value$iv = this.state == 3;
        $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string3 = string = "The benchmark hasn't finished! In Java, use while(BenchmarkState.keepRunning()) to ensure keepRunning() returns false before ending your test. In Kotlin, just use benchmarkRule.measureRepeated {} to avoid the problem.";
            throw new IllegalStateException(string3);
        }
    }

    public final void pauseTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string2 = string = "Unable to pause the benchmark. The benchmark has already paused.";
            throw new IllegalStateException(string2);
        }
        if (this.state != 0) {
            this.metrics.capturePaused();
        }
        this.paused = true;
    }

    public final void resumeTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string2 = string = "Unable to resume the benchmark. The benchmark is already running.";
            throw new IllegalStateException(string2);
        }
        if (this.state != 0) {
            this.metrics.captureResumed();
        }
        this.paused = false;
    }

    private final void beginRunningStage() {
        this.metrics = this.stages.get(this.state);
        this.repeatCount = 0;
        this.metrics.captureInit();
        int n = this.state;
        switch (n) {
            case 0: {
                Runtime.getRuntime().gc();
                this.iterationsPerRepeat = 1;
                Trace.beginSection((String)"Warmup");
                break;
            }
            case 1: {
                Profiler profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release();
                if (profiler != null) {
                    profiler.start(this.traceUniqueName);
                }
                Trace.beginSection((String)"Benchmark Time");
                break;
            }
            case 2: {
                Trace.beginSection((String)"Benchmark Allocations");
            }
        }
        this.iterationsRemaining = this.iterationsPerRepeat;
        this.metrics.captureStart();
    }

    private final boolean endRunningStage() {
        if (this.state != 0 && !this.simplifiedTimingOnlyMode && this.throttleRemainingRetries > 0 && this.sleepIfThermalThrottled(90L)) {
            BenchmarkState benchmarkState = this;
            --benchmarkState.throttleRemainingRetries;
            this.metrics.captureInit();
            this.repeatCount = 0;
            return false;
        }
        Trace.endSection();
        int n = this.state;
        switch (n) {
            case 0: {
                this.warmupRepeats = this.repeatCount;
                this.iterationsPerRepeat = this.computeMaxIterations();
                break;
            }
            case 1: 
            case 2: {
                Profiler profiler;
                if (this.state == 1 && (profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release()) != null) {
                    profiler.stop();
                }
                this.stats.addAll((Collection<Stats>)this.metrics.captureFinished(this.iterationsPerRepeat));
                CollectionsKt.addAll((Collection)this.allData, (Object[])((Object[])this.metrics.getData$benchmark_common_release()));
            }
        }
        BenchmarkState benchmarkState = this;
        int n2 = benchmarkState.state;
        benchmarkState.state = n2 + 1;
        if (this.state == 2 && (this.simplifiedTimingOnlyMode || Arguments.INSTANCE.getStartupMode$benchmark_common_release() || Arguments.INSTANCE.getDryRunMode$benchmark_common_release() || Arguments.INSTANCE.getProfiler$benchmark_common_release() != null)) {
            benchmarkState = this;
            n2 = benchmarkState.state;
            benchmarkState.state = n2 + 1;
        }
        return true;
    }

    private final boolean startNextRepeat() {
        this.metrics.captureStop();
        BenchmarkState benchmarkState = this;
        int n = benchmarkState.repeatCount;
        benchmarkState.repeatCount = n + 1;
        if (this.state == 0) {
            this.metrics.captureInit();
            if (this.warmupManager.onNextIteration(((long[])ArraysKt.last((Object[])((Object[])this.metrics.getData$benchmark_common_release())))[0])) {
                this.endRunningStage();
                this.beginRunningStage();
            }
        } else if ((this.state == 1 && this.repeatCount >= REPEAT_COUNT_TIME || this.state == 2 && this.repeatCount >= 5) && this.endRunningStage()) {
            if (this.state == 3) {
                this.afterBenchmark();
                return false;
            }
            this.beginRunningStage();
        }
        this.iterationsRemaining = this.iterationsPerRepeat;
        this.metrics.captureStart();
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean keepRunningInline() {
        boolean $i$f$keepRunningInline = false;
        if (this.iterationsRemaining > 1) {
            BenchmarkState benchmarkState = this;
            int n = benchmarkState.iterationsRemaining;
            benchmarkState.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    public final boolean keepRunning() {
        if (this.iterationsRemaining > 1) {
            BenchmarkState benchmarkState = this;
            int n = benchmarkState.iterationsRemaining;
            benchmarkState.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    private final void check(boolean value, Function0<String> lazyMessage) {
        boolean $i$f$check = false;
        if (!value) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            throw new IllegalStateException((String)lazyMessage.invoke());
        }
    }

    @PublishedApi
    public final boolean keepRunningInternal() {
        int n = this.state;
        switch (n) {
            case -1: {
                this.beforeBenchmark();
                this.beginRunningStage();
                return true;
            }
            case 0: 
            case 1: 
            case 2: {
                BenchmarkState benchmarkState = this;
                int n2 = benchmarkState.iterationsRemaining;
                benchmarkState.iterationsRemaining = n2 + -1;
                if (this.iterationsRemaining <= 0) {
                    this.throwIfPaused();
                    return this.startNextRepeat();
                }
                return true;
            }
        }
        throw new IllegalStateException("The benchmark is in an invalid state.");
    }

    private final void beforeBenchmark() {
        Errors.INSTANCE.throwIfError();
        if (!firstBenchmark && Arguments.INSTANCE.getStartupMode$benchmark_common_release()) {
            throw new AssertionError((Object)"Error - multiple benchmarks in startup mode. Only one benchmark may be run per 'am instrument' call, to ensure result isolation.");
        }
        firstBenchmark = false;
        this.thermalThrottleSleepSeconds = 0L;
        if (!this.simplifiedTimingOnlyMode) {
            if (!(CpuInfo.INSTANCE.getLocked() || IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release() || Errors.INSTANCE.isEmulator())) {
                ThrottleDetector.INSTANCE.computeThrottleBaseline();
            }
            ThreadPriority.INSTANCE.bumpCurrentThreadPriority();
        }
        this.totalRunTimeStartNs = System.nanoTime();
        this.state = 0;
        if (Arguments.INSTANCE.getDryRunMode$benchmark_common_release() || Arguments.INSTANCE.getStartupMode$benchmark_common_release()) {
            this.state = 1;
        }
    }

    private final void afterBenchmark() {
        this.totalRunTimeNs = System.nanoTime() - this.totalRunTimeStartNs;
        if (!this.simplifiedTimingOnlyMode) {
            ThreadPriority.INSTANCE.resetBumpedThread();
        }
        this.warmupManager.logInfo();
        if (this.throttleRemainingRetries == 0) {
            ThrottleDetector.INSTANCE.resetThrottleBaseline();
        }
    }

    private final int computeMaxIterations() {
        Integer n = OVERRIDE_ITERATIONS;
        return n == null ? RangesKt.coerceIn((int)((int)((float)REPEAT_DURATION_TARGET_NS / this.warmupManager.getEstimatedIterationTimeNs())), (int)1, (int)1000000) : n;
    }

    private final void throwIfPaused() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string2 = string = "Benchmark loop finished in paused state. Call BenchmarkState.resumeTiming() before BenchmarkState.keepRunning().";
            throw new IllegalStateException(string2);
        }
    }

    private final BenchmarkResult getReport(String testName, String className) {
        return new BenchmarkResult(className, testName, this.totalRunTimeNs, BenchmarkResultKt.metricResultList(this.stats, this.allData), this.iterationsPerRepeat, this.thermalThrottleSleepSeconds, this.warmupRepeats);
    }

    @NotNull
    public final BenchmarkResult getReport$benchmark_common_release() {
        this.checkState();
        Unit unit = Unit.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        Unit $this$getReport_u24lambda_u2d6 = unit;
        boolean bl3 = false;
        return this.getReport("", "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bundle getFullStatusReport$benchmark_common_release(@NotNull String key, boolean includeStats) {
        Object v0;
        long l;
        Bundle status;
        Object object;
        Object object2;
        Object object3;
        block4: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable iterable = this.stats;
            object3 = new StringBuilder().append(key);
            object2 = TAG;
            boolean $i$f$map = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stats stats = (Stats)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string = it.getSummary$benchmark_common_release();
                object.add(string);
            }
            object = (List)destination$iv$iv;
            Log.i((String)object2, (String)((StringBuilder)object3).append(object).append("count=").append(this.iterationsPerRepeat).toString());
            status = new Bundle();
            if (includeStats) {
                Iterable $this$forEach$iv = this.stats;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Stats it = (Stats)element$iv;
                    boolean bl = false;
                    it.putInBundle(status, Errors.INSTANCE.getPREFIX());
                }
            }
            Iterable $i$f$forEach = this.stats;
            l = this.getMinTimeNanos();
            object = key;
            object3 = InstrumentationResults.INSTANCE;
            object2 = new InstrumentationResultScope(status);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Stats it = (Stats)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"allocationCount")) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Object var17_26 = v0;
        Stats stats = var17_26;
        InstrumentationResultScope.ideSummaryRecord$default((InstrumentationResultScope)object2, ((InstrumentationResults)object3).ideSummaryLineWrapped$benchmark_common_release((String)object, l, stats == null ? null : Long.valueOf(stats.getMedian())), null, 2, null);
        return status;
    }

    private final boolean sleepIfThermalThrottled(long sleepSeconds) {
        boolean bl;
        if (ThrottleDetector.INSTANCE.isDeviceThermalThrottled()) {
            Log.d((String)TAG, (String)("THERMAL THROTTLE DETECTED, SLEEPING FOR " + sleepSeconds + " SECONDS"));
            long startTimeNs = System.nanoTime();
            Thread.sleep(TimeUnit.SECONDS.toMillis(sleepSeconds));
            long sleepTimeNs = System.nanoTime() - startTimeNs;
            BenchmarkState benchmarkState = this;
            benchmarkState.thermalThrottleSleepSeconds += TimeUnit.NANOSECONDS.toSeconds(sleepTimeNs);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void report(@NotNull String fullClassName, @NotNull String simpleClassName, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)fullClassName, (String)"fullClassName");
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        if (this.state == -1) {
            return;
        }
        this.checkState();
        String fullTestName = Errors.INSTANCE.getPREFIX() + simpleClassName + '.' + methodName;
        Bundle bundle = this.getFullStatusReport$benchmark_common_release(fullTestName, !Arguments.INSTANCE.getDryRunMode$benchmark_common_release());
        InstrumentationResults.INSTANCE.reportBundle$benchmark_common_release(bundle);
        ResultWriter.INSTANCE.appendReport(this.getReport(Intrinsics.stringPlus((String)Errors.INSTANCE.getPREFIX(), (Object)methodName), fullClassName));
    }

    @JvmStatic
    @Companion.ExperimentalExternalReport
    public static final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
        Companion.reportData(className, testName, totalRunTimeNs, dataNs, warmupIterations, thermalThrottleSleepSeconds, repeatIterations);
    }

    static {
        Profiler profiler;
        Companion = new Companion(null);
        REPEAT_COUNT_TIME = Arguments.INSTANCE.getDryRunMode$benchmark_common_release() ? 1 : (((profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release()) == null ? false : profiler.getRequiresSingleMeasurementIteration()) ? 1 : (Arguments.INSTANCE.getStartupMode$benchmark_common_release() ? 10 : 50));
        OVERRIDE_ITERATIONS = Arguments.INSTANCE.getDryRunMode$benchmark_common_release() || Arguments.INSTANCE.getStartupMode$benchmark_common_release() || ((profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release()) == null ? false : profiler.getRequiresSingleMeasurementIteration()) ? Integer.valueOf(1) : (Arguments.INSTANCE.getIterations$benchmark_common_release() != null ? Arguments.INSTANCE.getIterations$benchmark_common_release() : null);
        Profiler profiler2 = Arguments.INSTANCE.getProfiler$benchmark_common_release();
        profiler = profiler2 == null ? null : Boolean.valueOf(profiler2.getRequiresExtraRuntime());
        REPEAT_DURATION_TARGET_NS = Intrinsics.areEqual((Object)profiler, (Object)true) ? TimeUnit.MILLISECONDS.toNanos(50L) : TimeUnit.SECONDS.toNanos(Arguments.INSTANCE.getProfilerSampleDurationSeconds$benchmark_common_release()) / (long)REPEAT_COUNT_TIME;
        firstBenchmark = true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\b\b\u0001\u0010 \u001a\u00020\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\b\b\u0001\u0010#\u001a\u00020\u00042\b\b\u0001\u0010$\u001a\u00020\u00102\b\b\u0001\u0010%\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/benchmark/BenchmarkState$Companion;", "", "()V", "FINISHED", "", "MAX_TEST_ITERATIONS", "MIN_TEST_ITERATIONS", "NOT_STARTED", "OVERRIDE_ITERATIONS", "Ljava/lang/Integer;", "REPEAT_COUNT_ALLOCATION", "REPEAT_COUNT_TIME", "getREPEAT_COUNT_TIME$benchmark_common_release$annotations", "getREPEAT_COUNT_TIME$benchmark_common_release", "()I", "REPEAT_DURATION_TARGET_NS", "", "getREPEAT_DURATION_TARGET_NS$benchmark_common_release", "()J", "RUNNING_ALLOCATION_STAGE", "RUNNING_TIME_STAGE", "RUNNING_WARMUP_STAGE", "TAG", "", "THROTTLE_BACKOFF_S", "THROTTLE_MAX_RETRIES", "firstBenchmark", "", "reportData", "", "className", "testName", "totalRunTimeNs", "dataNs", "", "warmupIterations", "thermalThrottleSleepSeconds", "repeatIterations", "ExperimentalExternalReport", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getREPEAT_COUNT_TIME$benchmark_common_release() {
            return REPEAT_COUNT_TIME;
        }

        @VisibleForTesting
        public static /* synthetic */ void getREPEAT_COUNT_TIME$benchmark_common_release$annotations() {
        }

        public final long getREPEAT_DURATION_TARGET_NS$benchmark_common_release() {
            return REPEAT_DURATION_TARGET_NS;
        }

        @JvmStatic
        @ExperimentalExternalReport
        public final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter(dataNs, (String)"dataNs");
            MetricsContainer metricsContainer = new MetricsContainer(null, dataNs.size(), 1, null);
            metricsContainer.getData$benchmark_common_release()[ArraysKt.getLastIndex((Object[])((Object[])metricsContainer.getData$benchmark_common_release()))] = CollectionsKt.toLongArray((Collection)dataNs);
            BenchmarkResult report = new BenchmarkResult(className, testName, totalRunTimeNs, BenchmarkResultKt.metricResultList(metricsContainer.captureFinished(1), ArraysKt.toList((Object[])((Object[])metricsContainer.getData$benchmark_common_release()))), repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
            CharSequence charSequence = className;
            boolean bl = false;
            String fullTestName = Intrinsics.stringPlus((String)Errors.INSTANCE.getPREFIX(), (Object)(charSequence.length() > 0 ? className + '.' + testName : testName));
            InstrumentationResults.INSTANCE.instrumentationReport((Function1<? super InstrumentationResultScope, Unit>)((Function1)new Function1<InstrumentationResultScope, Unit>(fullTestName, report){
                final /* synthetic */ String $fullTestName;
                final /* synthetic */ BenchmarkResult $report;
                {
                    this.$fullTestName = $fullTestName;
                    this.$report = $report;
                    super(1);
                }

                public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    InstrumentationResultScope.ideSummaryRecord$default($this$instrumentationReport, InstrumentationResults.INSTANCE.ideSummaryLineWrapped$benchmark_common_release(this.$fullTestName, this.$report.getStats("timeNs").getMin(), null), null, 2, null);
                }
            }));
            ResultWriter.INSTANCE.appendReport(report);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.BINARY)
        @kotlin.annotation.Target(allowedTargets={AnnotationTarget.FUNCTION})
        @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
        @Target(value={ElementType.METHOD})
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/benchmark/BenchmarkState$Companion$ExperimentalExternalReport;", "", "benchmark-common_release"})
        @Experimental
        public static @interface ExperimentalExternalReport {
        }
    }
}

