/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.annotation.RestrictTo;
import androidx.benchmark.Stats;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\nH\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Landroidx/benchmark/MetricResult;", "", "name", "", "data", "", "(Ljava/lang/String;[J)V", "", "", "stats", "Landroidx/benchmark/Stats;", "(Ljava/util/List;Landroidx/benchmark/Stats;)V", "getData", "()Ljava/util/List;", "getStats", "()Landroidx/benchmark/Stats;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MetricResult {
    @NotNull
    private final List<Long> data;
    @NotNull
    private final Stats stats;

    public MetricResult(@NotNull List<Long> data, @NotNull Stats stats) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this.data = data;
        this.stats = stats;
    }

    @NotNull
    public final List<Long> getData() {
        return this.data;
    }

    @NotNull
    public final Stats getStats() {
        return this.stats;
    }

    public MetricResult(@NotNull String name, @NotNull long[] data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(ArraysKt.toList((long[])data), new Stats(data, name));
    }

    @NotNull
    public final List<Long> component1() {
        return this.data;
    }

    @NotNull
    public final Stats component2() {
        return this.stats;
    }

    @NotNull
    public final MetricResult copy(@NotNull List<Long> data, @NotNull Stats stats) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        return new MetricResult(data, stats);
    }

    public static /* synthetic */ MetricResult copy$default(MetricResult metricResult, List list, Stats stats, int n, Object object) {
        if ((n & 1) != 0) {
            list = metricResult.data;
        }
        if ((n & 2) != 0) {
            stats = metricResult.stats;
        }
        return metricResult.copy(list, stats);
    }

    @NotNull
    public String toString() {
        return "MetricResult(data=" + this.data + ", stats=" + this.stats + ')';
    }

    public int hashCode() {
        int result = ((Object)this.data).hashCode();
        result = result * 31 + this.stats.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetricResult)) {
            return false;
        }
        MetricResult metricResult = (MetricResult)other;
        if (!Intrinsics.areEqual(this.data, metricResult.data)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stats, (Object)metricResult.stats);
    }
}

