/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import androidx.benchmark.MetricCapture;
import androidx.benchmark.Stats;
import androidx.benchmark.TimeCapture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/MetricsContainer;", "", "metrics", "", "Landroidx/benchmark/MetricCapture;", "REPEAT_COUNT", "", "([Landroidx/benchmark/MetricCapture;I)V", "data", "", "getData$benchmark_common_release", "()[[J", "[[J", "[Landroidx/benchmark/MetricCapture;", "runNum", "captureFinished", "", "Landroidx/benchmark/Stats;", "maxIterations", "captureInit", "", "capturePaused", "captureResumed", "captureStart", "captureStop", "doLog", "benchmark-common_release"})
public final class MetricsContainer {
    @NotNull
    private final MetricCapture[] metrics;
    private final int REPEAT_COUNT;
    @NotNull
    private final long[][] data;
    private int runNum;

    public MetricsContainer(@NotNull MetricCapture[] metrics, int REPEAT_COUNT) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.metrics = metrics;
        this.REPEAT_COUNT = REPEAT_COUNT;
        int n = 0;
        int n2 = this.metrics.length;
        long[][] lArrayArray = new long[n2][];
        MetricsContainer metricsContainer = this;
        while (n < n2) {
            int n3 = n++;
            lArrayArray[n3] = new long[this.REPEAT_COUNT];
        }
        metricsContainer.data = lArrayArray;
    }

    public /* synthetic */ MetricsContainer(MetricCapture[] metricCaptureArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            MetricCapture[] metricCaptureArray2 = new MetricCapture[]{new TimeCapture()};
            metricCaptureArray = metricCaptureArray2;
        }
        this(metricCaptureArray, n);
    }

    @NotNull
    public final long[][] getData$benchmark_common_release() {
        return this.data;
    }

    public final void captureInit() {
        this.runNum = 0;
    }

    public final void captureStart() {
        int n = 0;
        int n2 = ArraysKt.getLastIndex((Object[])this.metrics);
        if (n <= n2) {
            int i;
            do {
                i = n++;
                this.metrics[i].captureStart();
            } while (i != n2);
        }
    }

    public final void captureStop() {
        int n = ArraysKt.getLastIndex((Object[])this.metrics);
        if (0 <= n) {
            do {
                int i = n--;
                this.data[i][this.runNum] = this.metrics[i].captureStop();
            } while (0 <= n);
        }
        MetricsContainer metricsContainer = this;
        ++metricsContainer.runNum;
    }

    public final void capturePaused() {
        int n = ArraysKt.getLastIndex((Object[])this.metrics);
        if (0 <= n) {
            do {
                int i = n--;
                this.metrics[ArraysKt.getLastIndex((Object[])this.metrics) - i].capturePaused();
            } while (0 <= n);
        }
    }

    public final void captureResumed() {
        int n = 0;
        int n2 = ArraysKt.getLastIndex((Object[])this.metrics);
        if (n <= n2) {
            int i;
            do {
                i = n++;
                this.metrics[i].captureResumed();
            } while (i != n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Stats> captureFinished(int maxIterations) {
        void $this$mapIndexedTo$iv$iv;
        long[][] lArray = this.data;
        int n = 0;
        int n2 = ((Object[])lArray).length;
        while (n < n2) {
            int i;
            long[] eachArray = lArray[n];
            ++n;
            int n3 = 0;
            int n4 = ArraysKt.getLastIndex((long[])eachArray);
            if (n3 > n4) continue;
            do {
                i = n3++;
                eachArray[i] = eachArray[i] / (long)maxIterations;
            } while (i != n4);
        }
        this.doLog();
        MetricCapture[] $this$mapIndexed$iv = this.metrics;
        boolean $i$f$mapIndexed = false;
        MetricCapture[] metricCaptureArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void it;
            void i;
            int n5 = index$iv$iv++;
            void var12_14 = item$iv$iv;
            int n6 = n5;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Stats stats = new Stats(this.getData$benchmark_common_release()[i], it.getName());
            collection.add(stats);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void doLog() {
        MetricCapture[] $this$forEachIndexed$iv = this.metrics;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (MetricCapture item$iv : $this$forEachIndexed$iv) {
            void $this$forEachIndexed$iv2;
            int n = index$iv++;
            MetricCapture metricCapture = item$iv;
            int i = n;
            boolean bl = false;
            Iterable iterable = CollectionsKt.chunked((Iterable)ArraysKt.toList((long[])this.getData$benchmark_common_release()[i]), (int)10);
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void chunk;
                void metric;
                int n2 = index$iv2++;
                boolean bl2 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv2;
                int chunkNum = n2;
                boolean bl3 = false;
                String string = metric.getName();
                String string2 = "[%2d:%2d]: %s";
                Object[] objectArray = new Object[]{chunkNum * 10, (chunkNum + 1) * 10, CollectionsKt.joinToString$default((Iterable)((Iterable)chunk), null, null, null, (int)0, null, null, (int)63, null)};
                boolean bl4 = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
                Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)string, (Object)string3));
            }
        }
    }
}

