/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.ShellImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0006\u0010\u000b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u001c\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00062\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0007J\b\u0010\u001a\u001a\u00020\u0018H\u0007J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006 "}, d2={"Landroidx/benchmark/Shell;", "", "()V", "catProcFileLong", "", "path", "", "(Ljava/lang/String;)Ljava/lang/Long;", "chmodExecutable", "", "absoluteFilePath", "connectUiAutomation", "createRunnableExecutable", "name", "inputStream", "Ljava/io/InputStream;", "executeCommand", "command", "executeScript", "script", "stdin", "executeScriptWithStderr", "Landroidx/benchmark/Shell$Output;", "isPackageAlive", "", "packageName", "isSessionRooted", "moveToTmpAndMakeExecutable", "src", "dst", "optionalCommand", "Output", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Shell {
    @NotNull
    public static final Shell INSTANCE = new Shell();

    private Shell() {
    }

    public final void connectUiAutomation() {
        if (Build.VERSION.SDK_INT >= 21) {
        }
    }

    @Nullable
    public final String optionalCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return Build.VERSION.SDK_INT >= 21 ? this.executeCommand(command) : (String)null;
    }

    @RequiresApi(value=21)
    @NotNull
    public final String executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return ShellImpl.INSTANCE.executeCommand(command);
    }

    @Nullable
    public final Long catProcFileLong(@NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = this.optionalCommand(Intrinsics.stringPlus((String)"cat ", (Object)path));
        if (string == null) {
            object = null;
        } else {
            String string2 = string;
            boolean bl = false;
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (string3 == null) {
                object = null;
            } else {
                Object object2;
                string2 = string3;
                bl = false;
                boolean bl2 = false;
                String $this$catProcFileLong_u24lambda_u2d0 = string2;
                boolean bl3 = false;
                try {
                    object2 = $this$catProcFileLong_u24lambda_u2d0;
                    boolean bl4 = false;
                    object2 = Long.parseLong((String)object2);
                }
                catch (NumberFormatException exception) {
                    object2 = null;
                }
                object = object2;
            }
        }
        return object;
    }

    @RequiresApi(value=21)
    public final void chmodExecutable(@NotNull String absoluteFilePath) {
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        if (Build.VERSION.SDK_INT >= 23) {
            ShellImpl.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"chmod +x ", (Object)absoluteFilePath));
        } else {
            ShellImpl.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"chmod 777 ", (Object)absoluteFilePath));
        }
    }

    @RequiresApi(value=21)
    public final void moveToTmpAndMakeExecutable(@NotNull String src, @NotNull String dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ShellImpl.INSTANCE.executeCommand("cp " + src + ' ' + dst);
        this.chmodExecutable(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=21)
    @NotNull
    public final String createRunnableExecutable(@NotNull String name, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        File externalDir = Outputs.INSTANCE.getDirUsableByAppAndShell();
        File writableExecutableFile = File.createTempFile(Intrinsics.stringPlus((String)"temporary_", (Object)name), null, externalDir);
        String runnableExecutablePath = Intrinsics.stringPlus((String)"/data/local/tmp/", (Object)name);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)writableExecutableFile, (String)"writableExecutableFile");
            Object object = writableExecutableFile;
            boolean bl = false;
            object = new FileOutputStream((File)object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl3 = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = writableExecutableFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"writableExecutableFile.absolutePath");
            this.moveToTmpAndMakeExecutable((String)object, runnableExecutablePath);
        }
        finally {
            writableExecutableFile.delete();
        }
        return runnableExecutablePath;
    }

    @RequiresApi(value=21)
    public final boolean isSessionRooted() {
        String string = ShellImpl.INSTANCE.executeCommand("getprop service.adb.root");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)"1");
    }

    @RequiresApi(value=21)
    @NotNull
    public final String executeScript(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return (String)ShellImpl.INSTANCE.executeScript(script, stdin, false).getFirst();
    }

    public static /* synthetic */ String executeScript$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScript(string, string2);
    }

    @RequiresApi(value=21)
    @NotNull
    public final Output executeScriptWithStderr(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Pair<String, String> pair = ShellImpl.INSTANCE.executeScript(script, stdin, true);
        boolean bl = false;
        boolean bl2 = false;
        Pair<String, String> $this$executeScriptWithStderr_u24lambda_u2d2 = pair;
        boolean bl3 = false;
        String string = (String)$this$executeScriptWithStderr_u24lambda_u2d2.getFirst();
        Object object = $this$executeScriptWithStderr_u24lambda_u2d2.getSecond();
        Intrinsics.checkNotNull((Object)object);
        return new Output(string, (String)object);
    }

    public static /* synthetic */ Output executeScriptWithStderr$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScriptWithStderr(string, string2);
    }

    @RequiresApi(value=21)
    public final boolean isPackageAlive(@NotNull String packageName) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            if (Build.VERSION.SDK_INT >= 24) {
                CharSequence charSequence = this.executeCommand(Intrinsics.stringPlus((String)"pidof ", (Object)packageName));
                boolean bl2 = false;
                return !StringsKt.isBlank((CharSequence)charSequence);
            }
            String[] stringArray = new String[]{"\r?\n"};
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)Shell.executeScript$default(this, Intrinsics.stringPlus((String)"ps | grep ", (Object)packageName), null, 2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    String string = it;
                    boolean bl4 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (!StringsKt.endsWith$default((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (String)Intrinsics.stringPlus((String)" ", (Object)packageName), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/Shell$Output;", "", "stdout", "", "stderr", "(Ljava/lang/String;Ljava/lang/String;)V", "getStderr", "()Ljava/lang/String;", "getStdout", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "benchmark-common_release"})
    public static final class Output {
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        public Output(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        @NotNull
        public final String component1() {
            return this.stdout;
        }

        @NotNull
        public final String component2() {
            return this.stderr;
        }

        @NotNull
        public final Output copy(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            return new Output(stdout, stderr);
        }

        public static /* synthetic */ Output copy$default(Output output, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = output.stdout;
            }
            if ((n & 2) != 0) {
                string2 = output.stderr;
            }
            return output.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Output(stdout=" + this.stdout + ", stderr=" + this.stderr + ')';
        }

        public int hashCode() {
            int result = this.stdout.hashCode();
            result = result * 31 + this.stderr.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.stdout, (Object)output.stdout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stderr, (Object)output.stderr);
        }
    }
}

