/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.benchmark.MetricNameUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\r\u0010 \u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\fH\u0016J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Landroidx/benchmark/Stats;", "", "data", "", "name", "", "([JLjava/lang/String;)V", "max", "", "getMax", "()J", "maxIndex", "", "getMaxIndex", "()I", "median", "getMedian", "medianIndex", "getMedianIndex", "min", "getMin", "minIndex", "getMinIndex", "getName", "()Ljava/lang/String;", "standardDeviation", "", "getStandardDeviation", "()D", "equals", "", "other", "getSummary", "getSummary$benchmark_common_release", "hashCode", "putInBundle", "", "status", "Landroid/os/Bundle;", "prefix", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Stats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final long median;
    private final int medianIndex;
    private final long min;
    private final int minIndex;
    private final long max;
    private final int maxIndex;
    private final double standardDeviation;

    /*
     * WARNING - void declaration
     */
    public Stats(@NotNull long[] data, @NotNull String name) {
        double d;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        List values = ArraysKt.sorted((long[])data);
        int size = values.size();
        boolean bl = size >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "At least one result is necessary.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double mean = ArraysKt.average((long[])data);
        this.min = ((Number)CollectionsKt.first((List)values)).longValue();
        this.max = ((Number)CollectionsKt.last((List)values)).longValue();
        this.median = Companion.getPercentile$benchmark_common_release(values, 50);
        this.minIndex = ArraysKt.indexOf((long[])data, (long)this.min);
        this.maxIndex = ArraysKt.indexOf((long[])data, (long)this.max);
        this.medianIndex = data.length / 2;
        Stats stats = this;
        if (data.length == 1) {
            d = 0.0;
        } else {
            Collection<Double> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = values;
            Stats stats2 = stats;
            boolean $i$f$map = false;
            void var11_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                collection = destination$iv$iv;
                boolean bl5 = false;
                double d2 = (double)it - mean;
                int n = 2;
                boolean bl6 = false;
                Double d3 = Math.pow(d2, n);
                collection.add(d3);
            }
            collection = (List)destination$iv$iv;
            stats = stats2;
            double sum = CollectionsKt.sumOfDouble((Iterable)collection);
            double d4 = sum / (double)(size - 1);
            boolean bl7 = false;
            d = Math.sqrt(d4);
        }
        stats.standardDeviation = d;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getMedian() {
        return this.median;
    }

    public final int getMedianIndex() {
        return this.medianIndex;
    }

    public final long getMin() {
        return this.min;
    }

    public final int getMinIndex() {
        return this.minIndex;
    }

    public final long getMax() {
        return this.max;
    }

    public final int getMaxIndex() {
        return this.maxIndex;
    }

    public final double getStandardDeviation() {
        return this.standardDeviation;
    }

    @NotNull
    public final String getSummary$benchmark_common_release() {
        return "Stats for " + this.name + ": median " + this.median + ", min " + this.min + ", max " + this.max + ", standardDeviation: " + this.standardDeviation;
    }

    public final void putInBundle(@NotNull Bundle status, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (Intrinsics.areEqual((Object)this.name, (Object)"timeNs")) {
            status.putLong(Intrinsics.stringPlus((String)prefix, (Object)"min"), this.min);
            status.putLong(Intrinsics.stringPlus((String)prefix, (Object)"median"), this.median);
            status.putLong(Intrinsics.stringPlus((String)prefix, (Object)"standardDeviation"), (long)this.standardDeviation);
        }
        String bundleName = MetricNameUtilsKt.toOutputMetricName(this.name);
        status.putLong(prefix + bundleName + "_min", this.min);
        status.putLong(prefix + bundleName + "_median", this.median);
        status.putLong(prefix + bundleName + "_stddev", (long)this.standardDeviation);
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.benchmark.Stats");
        }
        Stats cfr_ignored_0 = (Stats)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Stats)other).name)) {
            return false;
        }
        if (this.median != ((Stats)other).median) {
            return false;
        }
        if (this.medianIndex != ((Stats)other).medianIndex) {
            return false;
        }
        if (this.min != ((Stats)other).min) {
            return false;
        }
        if (this.minIndex != ((Stats)other).minIndex) {
            return false;
        }
        if (this.max != ((Stats)other).max) {
            return false;
        }
        if (this.maxIndex != ((Stats)other).maxIndex) {
            return false;
        }
        return this.standardDeviation == ((Stats)other).standardDeviation;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Long.hashCode(this.median);
        result = 31 * result + this.medianIndex;
        result = 31 * result + Long.hashCode(this.min);
        result = 31 * result + this.minIndex;
        result = 31 * result + Long.hashCode(this.max);
        result = 31 * result + this.maxIndex;
        result = 31 * result + Double.hashCode(this.standardDeviation);
        return result;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ%\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/Stats$Companion;", "", "()V", "getPercentile", "", "data", "", "percentile", "", "getPercentile$benchmark_common_release", "lerp", "a", "b", "ratio", "", "lerp$benchmark_common_release", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long lerp$benchmark_common_release(long a, long b, double ratio) {
            return MathKt.roundToLong((double)((double)a * (1.0 - ratio) + (double)b * ratio));
        }

        public final long getPercentile$benchmark_common_release(@NotNull List<Long> data, int percentile) {
            Long l;
            Intrinsics.checkNotNullParameter(data, (String)"data");
            double idealIndex = (double)RangesKt.coerceIn((int)percentile, (int)0, (int)100) / 100.0 * (double)(data.size() - 1);
            int firstIndex = (int)idealIndex;
            int secondIndex = firstIndex + 1;
            long firstValue = ((Number)data.get(firstIndex)).longValue();
            List<Long> list = data;
            boolean bl = false;
            if (secondIndex >= 0 && secondIndex <= CollectionsKt.getLastIndex(list)) {
                l = list.get(secondIndex);
            } else {
                int it = secondIndex;
                boolean bl2 = false;
                l = firstValue;
            }
            long secondValue = ((Number)l).longValue();
            return this.lerp$benchmark_common_release(firstValue, secondValue, idealIndex - (double)firstIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

