/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.simpleperf;

import android.annotation.SuppressLint;
import android.os.Build;
import android.system.OsConstants;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.simpleperf.RecordOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RequiresApi(value=28)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SuppressLint(value={"BanSynchronizedMethods"})
public class ProfileSession {
    private static final String SIMPLEPERF_PATH_IN_IMAGE = "/system/bin/simpleperf";
    private State mState = State.NOT_YET_STARTED;
    private final String mAppDataDir;
    private String mSimpleperfPath;
    private final String mSimpleperfDataDir;
    private Process mSimpleperfProcess;
    private boolean mTraceOffCpu = false;

    public ProfileSession(@NonNull String appDataDir) {
        this.mAppDataDir = appDataDir;
        this.mSimpleperfDataDir = appDataDir + "/simpleperf_data";
    }

    public ProfileSession() {
        String packageName;
        try {
            String s = this.readInputStream(new FileInputStream("/proc/self/cmdline"));
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != '\u0000') continue;
                s = s.substring(0, i);
                break;
            }
            packageName = s;
        }
        catch (IOException e) {
            throw new Error("failed to find packageName: " + e.getMessage());
        }
        if (packageName.isEmpty()) {
            throw new Error("failed to find packageName");
        }
        this.mAppDataDir = "/data/data/" + packageName;
        this.mSimpleperfDataDir = this.mAppDataDir + "/simpleperf_data";
    }

    public void startRecording(@NonNull RecordOptions options) {
        this.startRecording(options.toRecordArgs());
    }

    public synchronized void startRecording(@NonNull List<String> args) {
        if (this.mState != State.NOT_YET_STARTED) {
            throw new AssertionError((Object)("startRecording: session in wrong state " + (Object)((Object)this.mState)));
        }
        this.mTraceOffCpu = args.contains("--trace-offcpu");
        this.mSimpleperfPath = this.findSimpleperf();
        this.checkIfPerfEnabled();
        this.createSimpleperfDataDir();
        this.startSimpleperfRecording(args);
        this.mState = State.STARTED;
    }

    public synchronized void pauseRecording() {
        if (this.mState != State.STARTED) {
            throw new AssertionError((Object)("pauseRecording: session in wrong state " + (Object)((Object)this.mState)));
        }
        if (this.mTraceOffCpu) {
            throw new AssertionError((Object)"--trace-offcpu option doesn't work well with pause/resume recording");
        }
        this.sendCmd("pause");
        this.mState = State.PAUSED;
    }

    public synchronized void resumeRecording() {
        if (this.mState != State.PAUSED) {
            throw new AssertionError((Object)("resumeRecording: session in wrong state " + (Object)((Object)this.mState)));
        }
        this.sendCmd("resume");
        this.mState = State.STARTED;
    }

    public synchronized void stopRecording() {
        if (this.mState != State.STARTED && this.mState != State.PAUSED) {
            throw new AssertionError((Object)("stopRecording: session in wrong state " + (Object)((Object)this.mState)));
        }
        if (Build.VERSION.SDK_INT == 29 && this.mSimpleperfPath.equals(SIMPLEPERF_PATH_IN_IMAGE)) {
            this.destroySimpleperfProcessWithoutClosingStdin();
        } else {
            this.mSimpleperfProcess.destroy();
        }
        this.waitForSimpleperfProcess();
        this.mState = State.STOPPED;
    }

    private void destroySimpleperfProcessWithoutClosingStdin() {
        String s = this.mSimpleperfProcess.toString();
        String prefix = "Process[pid=";
        if (s.startsWith("Process[pid=")) {
            int startIndex = "Process[pid=".length();
            int endIndex = s.indexOf(44);
            if (endIndex > startIndex) {
                int pid = Integer.parseInt(s.substring(startIndex, endIndex).trim());
                android.os.Process.sendSignal((int)pid, (int)OsConstants.SIGTERM);
                return;
            }
        }
        this.mSimpleperfProcess.destroy();
    }

    private String readInputStream(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String result = reader.lines().collect(Collectors.joining("\n"));
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @NonNull
    public String findSimpleperf() {
        String simpleperfPath = this.findSimpleperfInTempDir();
        if (simpleperfPath != null) {
            return simpleperfPath;
        }
        simpleperfPath = SIMPLEPERF_PATH_IN_IMAGE;
        if (this.isExecutableFile(simpleperfPath)) {
            return simpleperfPath;
        }
        throw new Error("can't find simpleperf on device. Please run api_profiler.py.");
    }

    private boolean isExecutableFile(@NonNull String path) {
        File file = new File(path);
        return file.canExecute();
    }

    @Nullable
    private String findSimpleperfInTempDir() {
        Process process;
        String path = "/data/local/tmp/simpleperf";
        File file = new File(path);
        if (!file.isFile()) {
            return null;
        }
        String toPath = this.mAppDataDir + "/simpleperf";
        try {
            process = new ProcessBuilder(new String[0]).command("cp", path, toPath).start();
            process.waitFor();
        }
        catch (Exception e) {
            return null;
        }
        if (!this.isExecutableFile(toPath)) {
            return null;
        }
        try {
            process = new ProcessBuilder(new String[0]).command(toPath, "list", "sw").start();
            process.waitFor();
            String data = this.readInputStream(process.getInputStream());
            if (!data.contains("cpu-clock")) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return toPath;
    }

    private void checkIfPerfEnabled() {
        Process process;
        try {
            process = new ProcessBuilder(new String[0]).command("/system/bin/getprop", "security.perf_harden").start();
        }
        catch (IOException e) {
            return;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String value = this.readInputStream(process.getInputStream());
        if (value.startsWith("1")) {
            throw new Error("linux perf events aren't enabled on the device. Please run api_profiler.py.");
        }
    }

    private void createSimpleperfDataDir() {
        File file = new File(this.mSimpleperfDataDir);
        if (!file.isDirectory()) {
            file.mkdir();
        }
    }

    private void createSimpleperfProcess(List<String> args) {
        ProcessBuilder pb = new ProcessBuilder(args).directory(new File(this.mSimpleperfDataDir));
        try {
            this.mSimpleperfProcess = pb.start();
        }
        catch (IOException e) {
            throw new Error("failed to create simpleperf process: " + e.getMessage());
        }
    }

    private void waitForSimpleperfProcess() {
        try {
            int exitCode = this.mSimpleperfProcess.waitFor();
            if (exitCode != 0) {
                throw new AssertionError((Object)("simpleperf exited with error: " + exitCode));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mSimpleperfProcess = null;
    }

    public void convertSimpleperfOutputToProto(@NonNull String inputPath, @NonNull String outputPath) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.mSimpleperfPath);
        args.add("report-sample");
        args.add("--protobuf");
        args.add("--show-callchain");
        args.add("-i");
        args.add(inputPath);
        args.add("-o");
        args.add(outputPath);
        this.createSimpleperfProcess(args);
        this.waitForSimpleperfProcess();
    }

    private void startSimpleperfRecording(List<String> recordArgs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.mSimpleperfPath);
        args.add("record");
        args.add("--log-to-android-buffer");
        args.add("--log");
        args.add("debug");
        args.add("--stdio-controls-profiling");
        args.add("--in-app");
        args.add("--tracepoint-events");
        args.add("/data/local/tmp/tracepoint_events");
        args.addAll(recordArgs);
        this.createSimpleperfProcess(args);
        String startFlag = this.readReply();
        if (!startFlag.equals("started")) {
            throw new Error("failed to receive simpleperf start flag");
        }
    }

    private void sendCmd(@NonNull String cmd) {
        cmd = cmd + "\n";
        try {
            this.mSimpleperfProcess.getOutputStream().write(cmd.getBytes());
            this.mSimpleperfProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new Error("failed to send cmd to simpleperf: " + e.getMessage());
        }
        if (!this.readReply().equals("ok")) {
            throw new Error("failed to run cmd in simpleperf: " + cmd);
        }
    }

    @NonNull
    private String readReply() {
        String s = "";
        while (true) {
            int c = -1;
            try {
                c = this.mSimpleperfProcess.getInputStream().read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (c == -1 || c == 10) break;
            s = s + (char)c;
        }
        return s;
    }

    static enum State {
        NOT_YET_STARTED,
        STARTED,
        PAUSED,
        STOPPED;

    }
}

