/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.annotation.RestrictTo;
import androidx.benchmark.MetricResult;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0087\b\u0018\u00002\u00020\u0001:\u0001+BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u000f\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000fH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00c6\u0003JO\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0003J\t\u0010)\u001a\u00020\u000bH\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006,"}, d2={"Landroidx/benchmark/BenchmarkResult;", "", "className", "", "testName", "totalRunTimeNs", "", "metrics", "", "Landroidx/benchmark/MetricResult;", "repeatIterations", "", "thermalThrottleSleepSeconds", "warmupIterations", "(Ljava/lang/String;Ljava/lang/String;JLjava/util/List;IJI)V", "Landroidx/benchmark/BenchmarkResult$Measurements;", "(Ljava/lang/String;Ljava/lang/String;JLandroidx/benchmark/BenchmarkResult$Measurements;IJI)V", "getClassName", "()Ljava/lang/String;", "getMetrics", "()Landroidx/benchmark/BenchmarkResult$Measurements;", "getRepeatIterations", "()I", "getTestName", "getThermalThrottleSleepSeconds", "()J", "getTotalRunTimeNs", "getWarmupIterations", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getMetricResult", "which", "hashCode", "toString", "Measurements", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BenchmarkResult {
    @NotNull
    private final String className;
    @NotNull
    private final String testName;
    private final long totalRunTimeNs;
    @NotNull
    private final Measurements metrics;
    private final int repeatIterations;
    private final long thermalThrottleSleepSeconds;
    private final int warmupIterations;

    public BenchmarkResult(@NotNull String className, @NotNull String testName, long totalRunTimeNs, @NotNull Measurements metrics, int repeatIterations, long thermalThrottleSleepSeconds, int warmupIterations) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.className = className;
        this.testName = testName;
        this.totalRunTimeNs = totalRunTimeNs;
        this.metrics = metrics;
        this.repeatIterations = repeatIterations;
        this.thermalThrottleSleepSeconds = thermalThrottleSleepSeconds;
        this.warmupIterations = warmupIterations;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getTestName() {
        return this.testName;
    }

    public final long getTotalRunTimeNs() {
        return this.totalRunTimeNs;
    }

    @NotNull
    public final Measurements getMetrics() {
        return this.metrics;
    }

    public final int getRepeatIterations() {
        return this.repeatIterations;
    }

    public final long getThermalThrottleSleepSeconds() {
        return this.thermalThrottleSleepSeconds;
    }

    public final int getWarmupIterations() {
        return this.warmupIterations;
    }

    public BenchmarkResult(@NotNull String className, @NotNull String testName, long totalRunTimeNs, @NotNull List<MetricResult> metrics, int repeatIterations, long thermalThrottleSleepSeconds, int warmupIterations) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this(className, testName, totalRunTimeNs, new Measurements(metrics, CollectionsKt.emptyList()), repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
    }

    @NotNull
    public final MetricResult getMetricResult(@NotNull String which) {
        Object element$iv2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)which, (String)"which");
            Iterable $this$first$iv = this.metrics.getSingleMetrics();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)which)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (MetricResult)element$iv2;
    }

    @NotNull
    public final String component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.testName;
    }

    public final long component3() {
        return this.totalRunTimeNs;
    }

    @NotNull
    public final Measurements component4() {
        return this.metrics;
    }

    public final int component5() {
        return this.repeatIterations;
    }

    public final long component6() {
        return this.thermalThrottleSleepSeconds;
    }

    public final int component7() {
        return this.warmupIterations;
    }

    @NotNull
    public final BenchmarkResult copy(@NotNull String className, @NotNull String testName, long totalRunTimeNs, @NotNull Measurements metrics, int repeatIterations, long thermalThrottleSleepSeconds, int warmupIterations) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        return new BenchmarkResult(className, testName, totalRunTimeNs, metrics, repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
    }

    public static /* synthetic */ BenchmarkResult copy$default(BenchmarkResult benchmarkResult, String string, String string2, long l, Measurements measurements, int n, long l2, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = benchmarkResult.className;
        }
        if ((n3 & 2) != 0) {
            string2 = benchmarkResult.testName;
        }
        if ((n3 & 4) != 0) {
            l = benchmarkResult.totalRunTimeNs;
        }
        if ((n3 & 8) != 0) {
            measurements = benchmarkResult.metrics;
        }
        if ((n3 & 0x10) != 0) {
            n = benchmarkResult.repeatIterations;
        }
        if ((n3 & 0x20) != 0) {
            l2 = benchmarkResult.thermalThrottleSleepSeconds;
        }
        if ((n3 & 0x40) != 0) {
            n2 = benchmarkResult.warmupIterations;
        }
        return benchmarkResult.copy(string, string2, l, measurements, n, l2, n2);
    }

    @NotNull
    public String toString() {
        return "BenchmarkResult(className=" + this.className + ", testName=" + this.testName + ", totalRunTimeNs=" + this.totalRunTimeNs + ", metrics=" + this.metrics + ", repeatIterations=" + this.repeatIterations + ", thermalThrottleSleepSeconds=" + this.thermalThrottleSleepSeconds + ", warmupIterations=" + this.warmupIterations + ')';
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = result * 31 + this.testName.hashCode();
        result = result * 31 + Long.hashCode(this.totalRunTimeNs);
        result = result * 31 + this.metrics.hashCode();
        result = result * 31 + Integer.hashCode(this.repeatIterations);
        result = result * 31 + Long.hashCode(this.thermalThrottleSleepSeconds);
        result = result * 31 + Integer.hashCode(this.warmupIterations);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BenchmarkResult)) {
            return false;
        }
        BenchmarkResult benchmarkResult = (BenchmarkResult)other;
        if (!Intrinsics.areEqual((Object)this.className, (Object)benchmarkResult.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.testName, (Object)benchmarkResult.testName)) {
            return false;
        }
        if (this.totalRunTimeNs != benchmarkResult.totalRunTimeNs) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metrics, (Object)benchmarkResult.metrics)) {
            return false;
        }
        if (this.repeatIterations != benchmarkResult.repeatIterations) {
            return false;
        }
        if (this.thermalThrottleSleepSeconds != benchmarkResult.thermalThrottleSleepSeconds) {
            return false;
        }
        return this.warmupIterations == benchmarkResult.warmupIterations;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u000eJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Landroidx/benchmark/BenchmarkResult$Measurements;", "", "singleMetrics", "", "Landroidx/benchmark/MetricResult;", "sampledMetrics", "(Ljava/util/List;Ljava/util/List;)V", "getSampledMetrics", "()Ljava/util/List;", "getSingleMetrics", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isNotEmpty", "toString", "", "benchmark-common_release"})
    public static final class Measurements {
        @NotNull
        private final List<MetricResult> singleMetrics;
        @NotNull
        private final List<MetricResult> sampledMetrics;

        public Measurements(@NotNull List<MetricResult> singleMetrics, @NotNull List<MetricResult> sampledMetrics) {
            Intrinsics.checkNotNullParameter(singleMetrics, (String)"singleMetrics");
            Intrinsics.checkNotNullParameter(sampledMetrics, (String)"sampledMetrics");
            this.singleMetrics = singleMetrics;
            this.sampledMetrics = sampledMetrics;
        }

        @NotNull
        public final List<MetricResult> getSingleMetrics() {
            return this.singleMetrics;
        }

        @NotNull
        public final List<MetricResult> getSampledMetrics() {
            return this.sampledMetrics;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isNotEmpty() {
            Collection collection = this.singleMetrics;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            collection = this.sampledMetrics;
            bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        @NotNull
        public final List<MetricResult> component1() {
            return this.singleMetrics;
        }

        @NotNull
        public final List<MetricResult> component2() {
            return this.sampledMetrics;
        }

        @NotNull
        public final Measurements copy(@NotNull List<MetricResult> singleMetrics, @NotNull List<MetricResult> sampledMetrics) {
            Intrinsics.checkNotNullParameter(singleMetrics, (String)"singleMetrics");
            Intrinsics.checkNotNullParameter(sampledMetrics, (String)"sampledMetrics");
            return new Measurements(singleMetrics, sampledMetrics);
        }

        public static /* synthetic */ Measurements copy$default(Measurements measurements, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = measurements.singleMetrics;
            }
            if ((n & 2) != 0) {
                list2 = measurements.sampledMetrics;
            }
            return measurements.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "Measurements(singleMetrics=" + this.singleMetrics + ", sampledMetrics=" + this.sampledMetrics + ')';
        }

        public int hashCode() {
            int result = ((Object)this.singleMetrics).hashCode();
            result = result * 31 + ((Object)this.sampledMetrics).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Measurements)) {
                return false;
            }
            Measurements measurements = (Measurements)other;
            if (!Intrinsics.areEqual(this.singleMetrics, measurements.singleMetrics)) {
                return false;
            }
            return Intrinsics.areEqual(this.sampledMetrics, measurements.sampledMetrics);
        }
    }
}

