/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.annotation.SuppressLint;
import android.util.Log;
import androidx.benchmark.Shell;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/CpuInfo;", "", "()V", "TAG", "", "coreDirs", "", "Landroidx/benchmark/CpuInfo$CoreDir;", "getCoreDirs", "()Ljava/util/List;", "locked", "", "getLocked", "()Z", "maxFreqHz", "", "getMaxFreqHz", "()J", "isCpuLocked", "readFileTextOrNull", "path", "CoreDir", "benchmark-common_release"})
@SuppressLint(value={"ClassVerificationFailure"})
public final class CpuInfo {
    @NotNull
    public static final CpuInfo INSTANCE;
    @NotNull
    private static final String TAG = "Benchmark";
    @NotNull
    private static final List<CoreDir> coreDirs;
    private static final boolean locked;
    private static final long maxFreqHz;

    private CpuInfo() {
    }

    @NotNull
    public final List<CoreDir> getCoreDirs() {
        return coreDirs;
    }

    public final boolean getLocked() {
        return locked;
    }

    public final long getMaxFreqHz() {
        return maxFreqHz;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCpuLocked(@NotNull List<CoreDir> coreDirs) {
        boolean bl;
        block13: {
            void $this$groupByTo$iv$iv;
            CoreDir it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(coreDirs, (String)"coreDirs");
            Iterable $this$filter$iv = coreDirs;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CoreDir)element$iv$iv;
                boolean bl2 = false;
                if (!it.getOnline()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List onlineCores = (List)destination$iv$iv;
            Iterable $this$groupBy$iv = onlineCores;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo22 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (CoreDir)element$iv$iv;
                boolean bl3 = false;
                List<Long> key$iv$iv = it.getAvailableFreqs();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv;
            boolean destination$iv$iv2 = false;
            Iterator $i$f$groupByTo22 = iterator.entrySet().iterator();
            while ($i$f$groupByTo22.hasNext()) {
                boolean bl5;
                block12: {
                    Map.Entry element$iv;
                    Map.Entry $dstr$_u24__u24$similarCores = element$iv = $i$f$groupByTo22.next();
                    boolean bl6 = false;
                    Map.Entry bl3 = $dstr$_u24__u24$similarCores;
                    boolean key$iv$iv = false;
                    List similarCores = (List)bl3.getValue();
                    Iterable $this$any$iv = similarCores;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            CoreDir it2 = (CoreDir)element$iv2;
                            boolean bl7 = false;
                            if (!(it2.getSetSpeedKhz() != ((CoreDir)CollectionsKt.first((List)similarCores)).getSetSpeedKhz())) continue;
                            bl5 = true;
                            break block12;
                        }
                        bl5 = false;
                    }
                }
                if (!bl5) continue;
                Log.d((String)TAG, (String)"Clocks not locked: cores with same available frequencies running with different current min freq");
                return false;
            }
            Iterable $this$any$iv = onlineCores;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CoreDir it3 = (CoreDir)element$iv;
                    boolean bl8 = false;
                    Long l = (Long)CollectionsKt.minOrNull((Iterable)it3.getAvailableFreqs());
                    long l2 = it3.getSetSpeedKhz();
                    if (!(l != null && l == l2)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            Log.d((String)TAG, (String)"Clocks not locked: online cores with min freq == min avail freq");
            return false;
        }
        return true;
    }

    private final String readFileTextOrNull(String path) {
        try {
            String string;
            File file = new File(path);
            boolean bl = false;
            boolean bl2 = false;
            File $this$readFileTextOrNull_u24lambda_u2d11 = file;
            boolean bl3 = false;
            if ($this$readFileTextOrNull_u24lambda_u2d11.exists()) {
                String string2 = FilesKt.readText$default((File)$this$readFileTextOrNull_u24lambda_u2d11, null, (int)1, null);
                boolean bl4 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            } else {
                string = null;
            }
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        long l;
        Object v8;
        void $this$filterTo$iv$iv;
        List list;
        INSTANCE = new CpuInfo();
        File cpuDir = new File("/sys/devices/system/cpu");
        String[] stringArray = cpuDir.list(1.INSTANCE);
        if (stringArray == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = stringArray;
            boolean $i$f$map = false;
            String[] stringArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var10_20 = $this$mapTo$iv$iv;
            int n = ((void)var10_20).length;
            for (int i = 0; i < n; ++i) {
                long l2;
                long l3;
                Object object;
                Object object2;
                List list2;
                void coreDir;
                String path;
                void item$iv$iv;
                void var15_26 = item$iv$iv = var10_20[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = path = cpuDir.getAbsolutePath() + '/' + coreDir;
                boolean bl2 = !Intrinsics.areEqual((Object)INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/online")), (Object)"0");
                String string2 = INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/cpufreq/scaling_available_frequencies"));
                if (string2 == null) {
                    list2 = null;
                } else {
                    object2 = string2;
                    Object object3 = new Regex("\\s+");
                    int n2 = 0;
                    boolean bl3 = false;
                    object = object3.split((CharSequence)object2, n2);
                    if (object == null) {
                        list2 = null;
                    } else {
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        void $this$filterTo$iv$iv2;
                        void $this$filter$iv;
                        object3 = (Iterable)object;
                        boolean bl4 = bl2;
                        String string3 = string;
                        boolean $i$f$filter22 = false;
                        void var23_38 = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            String it = (String)element$iv$iv;
                            boolean bl5 = false;
                            CharSequence charSequence = it;
                            boolean bl6 = false;
                            boolean bl7 = !StringsKt.isBlank((CharSequence)charSequence);
                            if (!bl7) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        Collection<Long> collection2 = (List)destination$iv$iv2;
                        object2 = collection2;
                        Iterable $i$f$filter22 = (Iterable)object2;
                        boolean $i$f$map2 = false;
                        destination$iv$iv2 = $this$map$iv2;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                            void it;
                            String bl5 = (String)item$iv$iv2;
                            collection2 = destination$iv$iv3;
                            boolean bl8 = false;
                            void var35_55 = it;
                            boolean bl9 = false;
                            Long l4 = Long.parseLong((String)var35_55);
                            collection2.add(l4);
                        }
                        collection2 = (List)destination$iv$iv3;
                        string = string3;
                        bl2 = bl4;
                        object3 = collection2;
                        list2 = CollectionsKt.sorted((Iterable)((Iterable)object3));
                    }
                }
                Object object4 = list2;
                Object object5 = object4 == null ? CollectionsKt.listOf((Object)-1L) : object4;
                object4 = Shell.INSTANCE.catProcFileLong(Intrinsics.stringPlus((String)path, (Object)"/cpufreq/scaling_setspeed"));
                if (object4 == null) {
                    string2 = INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/cpufreq/scaling_min_freq"));
                    if (string2 == null) {
                        l3 = -1L;
                    } else {
                        long l5;
                        object2 = string2;
                        boolean bl10 = false;
                        l3 = l5 = Long.parseLong((String)object2);
                    }
                } else {
                    l3 = (Long)object4;
                }
                object4 = INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/cpufreq/cpuinfo_max_freq"));
                if (object4 == null) {
                    l2 = -1L;
                } else {
                    long l6;
                    object = object4;
                    boolean bl11 = false;
                    l2 = l6 = Long.parseLong((String)object);
                }
                long l7 = l2;
                long l8 = l3;
                List list3 = object5;
                boolean bl12 = bl2;
                String string4 = string;
                CoreDir coreDir2 = new CoreDir(string4, bl12, list3, l8, l7);
                collection.add(coreDir2);
            }
            list = (List)destination$iv$iv;
        }
        Object object = list;
        coreDirs = object == null ? CollectionsKt.emptyList() : object;
        Iterable $this$filter$iv = coreDirs;
        boolean $i$f$filter = false;
        Iterable $i$f$map = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CoreDir it = (CoreDir)element$iv$iv;
            boolean bl = false;
            if (!(it.getMaxFreqKhz() != -1L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv2 = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            v8 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v8 = maxElem$iv;
            } else {
                CoreDir it = (CoreDir)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getMaxFreqKhz();
                do {
                    Object e$iv = iterator$iv.next();
                    CoreDir it2 = (CoreDir)e$iv;
                    $i$a$-maxByOrNull-CpuInfo$4 = false;
                    long v$iv = it2.getMaxFreqKhz();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v8 = maxElem$iv;
            }
        }
        object = v8;
        if (object == null) {
            l = -1L;
        } else {
            long l9;
            long $this$maxByOrNull$iv2 = ((CoreDir)object).getMaxFreqKhz();
            l = l9 = $this$maxByOrNull$iv2 * (long)1000;
        }
        maxFreqHz = l;
        locked = INSTANCE.isCpuLocked(coreDirs);
        Iterable $this$forEachIndexed$iv = coreDirs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void coreDir;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CoreDir v$iv = (CoreDir)item$iv;
            int index = n;
            boolean bl13 = false;
            Log.d((String)TAG, (String)("cpu" + index + ' ' + coreDir));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003JA\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006 "}, d2={"Landroidx/benchmark/CpuInfo$CoreDir;", "", "path", "", "online", "", "availableFreqs", "", "", "setSpeedKhz", "maxFreqKhz", "(Ljava/lang/String;ZLjava/util/List;JJ)V", "getAvailableFreqs", "()Ljava/util/List;", "getMaxFreqKhz", "()J", "getOnline", "()Z", "getPath", "()Ljava/lang/String;", "getSetSpeedKhz", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "benchmark-common_release"})
    public static final class CoreDir {
        @NotNull
        private final String path;
        private final boolean online;
        @NotNull
        private final List<Long> availableFreqs;
        private final long setSpeedKhz;
        private final long maxFreqKhz;

        public CoreDir(@NotNull String path, boolean online, @NotNull List<Long> availableFreqs, long setSpeedKhz, long maxFreqKhz) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(availableFreqs, (String)"availableFreqs");
            this.path = path;
            this.online = online;
            this.availableFreqs = availableFreqs;
            this.setSpeedKhz = setSpeedKhz;
            this.maxFreqKhz = maxFreqKhz;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final boolean getOnline() {
            return this.online;
        }

        @NotNull
        public final List<Long> getAvailableFreqs() {
            return this.availableFreqs;
        }

        public final long getSetSpeedKhz() {
            return this.setSpeedKhz;
        }

        public final long getMaxFreqKhz() {
            return this.maxFreqKhz;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.online;
        }

        @NotNull
        public final List<Long> component3() {
            return this.availableFreqs;
        }

        public final long component4() {
            return this.setSpeedKhz;
        }

        public final long component5() {
            return this.maxFreqKhz;
        }

        @NotNull
        public final CoreDir copy(@NotNull String path, boolean online, @NotNull List<Long> availableFreqs, long setSpeedKhz, long maxFreqKhz) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(availableFreqs, (String)"availableFreqs");
            return new CoreDir(path, online, availableFreqs, setSpeedKhz, maxFreqKhz);
        }

        public static /* synthetic */ CoreDir copy$default(CoreDir coreDir, String string, boolean bl, List list, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = coreDir.path;
            }
            if ((n & 2) != 0) {
                bl = coreDir.online;
            }
            if ((n & 4) != 0) {
                list = coreDir.availableFreqs;
            }
            if ((n & 8) != 0) {
                l = coreDir.setSpeedKhz;
            }
            if ((n & 0x10) != 0) {
                l2 = coreDir.maxFreqKhz;
            }
            return coreDir.copy(string, bl, list, l, l2);
        }

        @NotNull
        public String toString() {
            return "CoreDir(path=" + this.path + ", online=" + this.online + ", availableFreqs=" + this.availableFreqs + ", setSpeedKhz=" + this.setSpeedKhz + ", maxFreqKhz=" + this.maxFreqKhz + ')';
        }

        public int hashCode() {
            int result = this.path.hashCode();
            int n = this.online ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + ((Object)this.availableFreqs).hashCode();
            result = result * 31 + Long.hashCode(this.setSpeedKhz);
            result = result * 31 + Long.hashCode(this.maxFreqKhz);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoreDir)) {
                return false;
            }
            CoreDir coreDir = (CoreDir)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)coreDir.path)) {
                return false;
            }
            if (this.online != coreDir.online) {
                return false;
            }
            if (!Intrinsics.areEqual(this.availableFreqs, coreDir.availableFreqs)) {
                return false;
            }
            if (this.setSpeedKhz != coreDir.setSpeedKhz) {
                return false;
            }
            return this.maxFreqKhz == coreDir.maxFreqKhz;
        }
    }
}

