/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.content.Context;
import android.os.Build;
import android.util.JsonWriter;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.BenchmarkResult;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.MemInfo;
import androidx.benchmark.MetricResult;
import androidx.benchmark.Outputs;
import androidx.benchmark.ResultWriter;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J#\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0001\u00a2\u0006\u0002\b\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u0018*\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015H\u0002J\u0014\u0010\u001e\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0014\u0010\u001f\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0014\u0010 \u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010!\u001a\u00020\u0018*\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015H\u0002R,\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Landroidx/benchmark/ResultWriter;", "", "()V", "reports", "Ljava/util/ArrayList;", "Landroidx/benchmark/BenchmarkResult;", "Lkotlin/collections/ArrayList;", "getReports$benchmark_common_release$annotations", "getReports$benchmark_common_release", "()Ljava/util/ArrayList;", "appendReport", "", "benchmarkResult", "getParams", "", "", "testName", "writeReport", "file", "Ljava/io/File;", "benchmarkResults", "", "writeReport$benchmark_common_release", "buildInfoObject", "Landroid/util/JsonWriter;", "metricResultObject", "metricResult", "Landroidx/benchmark/MetricResult;", "metricsContainerObject", "metricResults", "paramsObject", "reportObject", "sampledMetricResultObject", "sampledMetricsContainerObject", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ResultWriter {
    @NotNull
    public static final ResultWriter INSTANCE = new ResultWriter();
    @NotNull
    private static final ArrayList<BenchmarkResult> reports = new ArrayList();

    private ResultWriter() {
    }

    @NotNull
    public final ArrayList<BenchmarkResult> getReports$benchmark_common_release() {
        return reports;
    }

    @VisibleForTesting
    public static /* synthetic */ void getReports$benchmark_common_release$annotations() {
    }

    public final void appendReport(@NotNull BenchmarkResult benchmarkResult) {
        Intrinsics.checkNotNullParameter((Object)benchmarkResult, (String)"benchmarkResult");
        reports.add(benchmarkResult);
        if (Arguments.INSTANCE.getOutputEnable$benchmark_common_release()) {
            Context context = InstrumentationRegistry.getInstrumentation().getTargetContext();
            Intrinsics.checkNotNull((Object)context);
            String packageName = context.getPackageName();
            Outputs.INSTANCE.writeFile(Intrinsics.stringPlus((String)packageName, (Object)"-benchmarkData.json"), "results_json", true, (Function1<? super File, Unit>)((Function1)appendReport.1.INSTANCE));
        } else {
            Log.d((String)"Benchmark", (String)"androidx.benchmark.output.enable not set, not writing results json");
        }
    }

    @VisibleForTesting
    public final void writeReport$benchmark_common_release(@NotNull File file, @NotNull List<BenchmarkResult> benchmarkResults) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(benchmarkResults, (String)"benchmarkResults");
        File file2 = file;
        boolean bl = false;
        boolean bl2 = false;
        File $this$writeReport_u24lambda_u2d1 = file2;
        boolean bl3 = false;
        if (!$this$writeReport_u24lambda_u2d1.exists()) {
            File file3 = $this$writeReport_u24lambda_u2d1.getParentFile();
            if (file3 != null) {
                file3.mkdirs();
            }
            try {
                $this$writeReport_u24lambda_u2d1.createNewFile();
            }
            catch (IOException exception) {
                throw new IOException(StringsKt.trimIndent((String)("\n                            Failed to create file for benchmark report in:\n                            " + $this$writeReport_u24lambda_u2d1.getParent() + "\n                            Make sure the instrumentation argument additionalTestOutputDir is set\n                            to a writable directory on device. If using a version of Android Gradle\n                            Plugin that doesn't support additionalTestOutputDir, ensure your app's\n                            manifest file enables legacy storage behavior by adding the\n                            application attribute: android:requestLegacyExternalStorage=\"true\"\n                        ")), exception);
            }
        }
        File file4 = $this$writeReport_u24lambda_u2d1;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl4 = false;
        Object object = file4;
        boolean bl5 = false;
        Object object2 = object;
        boolean bl6 = false;
        object2 = new FileOutputStream((File)object2);
        bl6 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        bl5 = false;
        JsonWriter writer = new JsonWriter((Writer)(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n)));
        writer.setIndent("    ");
        writer.beginObject();
        file4 = writer.name("context").beginObject().name("build");
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"writer.name(\"context\").b\u2026           .name(\"build\")");
        INSTANCE.buildInfoObject((JsonWriter)file4).name("cpuCoreCount").value((Number)CpuInfo.INSTANCE.getCoreDirs().size()).name("cpuLocked").value(CpuInfo.INSTANCE.getLocked()).name("cpuMaxFreqHz").value(CpuInfo.INSTANCE.getMaxFreqHz()).name("memTotalBytes").value(MemInfo.INSTANCE.getMemTotalBytes()).name("sustainedPerformanceModeEnabled").value(IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release());
        writer.endObject();
        writer.name("benchmarks").beginArray();
        Iterable $this$forEach$iv = benchmarkResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BenchmarkResult it = (BenchmarkResult)element$iv;
            boolean bl7 = false;
            INSTANCE.reportObject(writer, it);
        }
        writer.endArray();
        writer.endObject();
        writer.flush();
        writer.close();
    }

    private final JsonWriter buildInfoObject(JsonWriter $this$buildInfoObject) {
        $this$buildInfoObject.beginObject().name("brand").value(Build.BRAND).name("device").value(Build.DEVICE).name("fingerprint").value(Build.FINGERPRINT).name("model").value(Build.MODEL).name("version").beginObject().name("sdk").value((Number)Build.VERSION.SDK_INT).endObject();
        JsonWriter jsonWriter = $this$buildInfoObject.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter, (String)"endObject()");
        return jsonWriter;
    }

    private final JsonWriter reportObject(JsonWriter $this$reportObject, BenchmarkResult benchmarkResult) {
        JsonWriter jsonWriter = $this$reportObject.beginObject().name("name").value(benchmarkResult.getTestName()).name("params");
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter, (String)"beginObject()\n          \u2026          .name(\"params\")");
        JsonWriter jsonWriter2 = this.paramsObject(jsonWriter, benchmarkResult).name("className").value(benchmarkResult.getClassName()).name("totalRunTimeNs").value(benchmarkResult.getTotalRunTimeNs()).name("metrics");
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter2, (String)"beginObject()\n          \u2026         .name(\"metrics\")");
        JsonWriter jsonWriter3 = this.metricsContainerObject(jsonWriter2, benchmarkResult.getMetrics().getSingleMetrics()).name("sampledMetrics");
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter3, (String)"beginObject()\n          \u2026  .name(\"sampledMetrics\")");
        this.sampledMetricsContainerObject(jsonWriter3, benchmarkResult.getMetrics().getSampledMetrics()).name("warmupIterations").value((Number)benchmarkResult.getWarmupIterations()).name("repeatIterations").value((Number)benchmarkResult.getRepeatIterations()).name("thermalThrottleSleepSeconds").value(benchmarkResult.getThermalThrottleSleepSeconds());
        jsonWriter3 = $this$reportObject.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter3, (String)"endObject()");
        return jsonWriter3;
    }

    private final JsonWriter metricResultObject(JsonWriter $this$metricResultObject, MetricResult metricResult) {
        $this$metricResultObject.name("minimum").value(metricResult.getMin());
        $this$metricResultObject.name("maximum").value(metricResult.getMax());
        $this$metricResultObject.name("median").value(metricResult.getMedian());
        return $this$metricResultObject;
    }

    private final JsonWriter metricsContainerObject(JsonWriter $this$metricsContainerObject, List<MetricResult> metricResults) {
        $this$metricsContainerObject.beginObject();
        Iterable $this$forEach$iv = metricResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetricResult metricResult = (MetricResult)element$iv;
            boolean bl = false;
            $this$metricsContainerObject.name(metricResult.getName()).beginObject();
            INSTANCE.metricResultObject($this$metricsContainerObject, metricResult);
            $this$metricsContainerObject.name("runs").beginArray();
            Iterable $this$forEach$iv2 = metricResult.getData();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                double it = ((Number)element$iv2).doubleValue();
                boolean bl2 = false;
                $this$metricsContainerObject.value(it);
            }
            $this$metricsContainerObject.endArray();
            $this$metricsContainerObject.endObject();
        }
        JsonWriter jsonWriter = $this$metricsContainerObject.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter, (String)"endObject()");
        return jsonWriter;
    }

    private final JsonWriter sampledMetricResultObject(JsonWriter $this$sampledMetricResultObject, MetricResult metricResult) {
        $this$sampledMetricResultObject.name("P50").value(metricResult.getP50());
        $this$sampledMetricResultObject.name("P90").value(metricResult.getP90());
        $this$sampledMetricResultObject.name("P95").value(metricResult.getP95());
        $this$sampledMetricResultObject.name("P99").value(metricResult.getP99());
        return $this$sampledMetricResultObject;
    }

    private final JsonWriter sampledMetricsContainerObject(JsonWriter $this$sampledMetricsContainerObject, List<MetricResult> metricResults) {
        $this$sampledMetricsContainerObject.beginObject();
        Iterable $this$forEach$iv = metricResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetricResult metricResult = (MetricResult)element$iv;
            boolean bl = false;
            $this$sampledMetricsContainerObject.name(metricResult.getName()).beginObject();
            INSTANCE.sampledMetricResultObject($this$sampledMetricsContainerObject, metricResult);
            $this$sampledMetricsContainerObject.name("runs").beginArray();
            List<List<Double>> list = metricResult.getIterationData();
            Intrinsics.checkNotNull(list);
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List iterationValues = (List)element$iv2;
                boolean bl2 = false;
                $this$sampledMetricsContainerObject.beginArray();
                Iterable $this$forEach$iv3 = iterationValues;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    double it = ((Number)element$iv3).doubleValue();
                    boolean bl3 = false;
                    $this$sampledMetricsContainerObject.value(it);
                }
                $this$sampledMetricsContainerObject.endArray();
            }
            $this$sampledMetricsContainerObject.endArray();
            $this$sampledMetricsContainerObject.endObject();
        }
        JsonWriter jsonWriter = $this$sampledMetricsContainerObject.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter, (String)"endObject()");
        return jsonWriter;
    }

    private final JsonWriter paramsObject(JsonWriter $this$paramsObject, BenchmarkResult benchmarkResult) {
        $this$paramsObject.beginObject();
        Map<String, String> $this$forEach$iv = this.getParams(benchmarkResult.getTestName());
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$paramsObject.name(it.getKey()).value(it.getValue());
        }
        JsonWriter jsonWriter = $this$paramsObject.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter, (String)"endObject()");
        return jsonWriter;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getParams(String testName) {
        int parameterStrStart = StringsKt.indexOf$default((CharSequence)((CharSequence)testName), (char)'[', (int)0, (boolean)false, (int)6, null);
        int parameterStrEnd = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)testName), (char)']', (int)0, (boolean)false, (int)6, null);
        HashMap params = new HashMap();
        if (parameterStrStart >= 0 && parameterStrEnd >= 0) {
            String[] stringArray = testName;
            int n = parameterStrStart + 1;
            boolean bl = false;
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = stringArray.substring(n, parameterStrEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String paramListString = string;
            stringArray = new String[]{","};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)paramListString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String value;
                String key;
                int separatorIndex;
                int n2;
                int n3;
                String paramString;
                block7: {
                    int n4;
                    paramString = (String)element$iv;
                    boolean bl2 = false;
                    CharSequence $this$indexOfFirst$iv = paramString;
                    boolean $i$f$indexOfFirst = false;
                    n3 = 0;
                    n2 = $this$indexOfFirst$iv.length();
                    while (n3 < n2) {
                        void index$iv;
                        char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                        boolean bl3 = false;
                        if (it == ':' || it == '=') {
                            n4 = index$iv;
                            break block7;
                        }
                        ++index$iv;
                    }
                    n4 = separatorIndex = -1;
                }
                boolean bl4 = 1 <= separatorIndex ? separatorIndex < paramString.length() - 1 : false;
                if (!bl4) continue;
                String $i$f$indexOfFirst = paramString;
                n3 = 0;
                n2 = 0;
                String string2 = $i$f$indexOfFirst;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n3, separatorIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Object object = paramString;
                n2 = separatorIndex + 1;
                boolean bl5 = false;
                String string3 = object;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                object = params;
                n2 = 0;
                object.put(key, value);
            }
        }
        return params;
    }
}

