/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.ShellImpl;
import androidx.benchmark.UserspaceTracing;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002./B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0006\u0010\u000b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u001c\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00062\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0006H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0007J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0007J\b\u0010 \u001a\u00020\u001cH\u0007J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0007J\u0010\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J1\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00192\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+\"\u00020,H\u0007\u00a2\u0006\u0002\u0010-J \u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0007\u00a8\u00060"}, d2={"Landroidx/benchmark/Shell;", "", "()V", "catProcFileLong", "", "path", "", "(Ljava/lang/String;)Ljava/lang/Long;", "chmodExecutable", "", "absoluteFilePath", "connectUiAutomation", "createRunnableExecutable", "name", "inputStream", "Ljava/io/InputStream;", "executeCommand", "command", "executeScript", "script", "stdin", "executeScriptWithStderr", "Landroidx/benchmark/Shell$Output;", "getPidsForProcess", "", "", "processName", "isPackageAlive", "", "packageName", "isProcessAlive", "pid", "isSessionRooted", "moveToTmpAndMakeExecutable", "src", "dst", "optionalCommand", "psLineContainsProcess", "psOutputLine", "terminateProcessesAndWait", "waitPollPeriodMs", "waitPollMaxCount", "processes", "", "Landroidx/benchmark/Shell$ProcessPid;", "(JI[Landroidx/benchmark/Shell$ProcessPid;)V", "Output", "ProcessPid", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Shell {
    @NotNull
    public static final Shell INSTANCE = new Shell();

    private Shell() {
    }

    private final boolean psLineContainsProcess(String psOutputLine, String processName) {
        return StringsKt.endsWith$default((String)psOutputLine, (String)Intrinsics.stringPlus((String)" ", (Object)processName), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)psOutputLine, (String)Intrinsics.stringPlus((String)"/", (Object)processName), (boolean)false, (int)2, null);
    }

    public final void connectUiAutomation() {
        if (Build.VERSION.SDK_INT >= 21) {
        }
    }

    @Nullable
    public final String optionalCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return Build.VERSION.SDK_INT >= 21 ? this.executeCommand(command) : (String)null;
    }

    @RequiresApi(value=21)
    @NotNull
    public final String executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return ShellImpl.INSTANCE.executeCommand(command);
    }

    @Nullable
    public final Long catProcFileLong(@NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = this.optionalCommand(Intrinsics.stringPlus((String)"cat ", (Object)path));
        if (string == null) {
            object = null;
        } else {
            String string2 = string;
            boolean bl = false;
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (string3 == null) {
                object = null;
            } else {
                Object object2;
                string2 = string3;
                bl = false;
                boolean bl2 = false;
                String $this$catProcFileLong_u24lambda_u2d0 = string2;
                boolean bl3 = false;
                try {
                    object2 = $this$catProcFileLong_u24lambda_u2d0;
                    boolean bl4 = false;
                    object2 = Long.parseLong((String)object2);
                }
                catch (NumberFormatException exception) {
                    object2 = null;
                }
                object = object2;
            }
        }
        return object;
    }

    @RequiresApi(value=21)
    public final void chmodExecutable(@NotNull String absoluteFilePath) {
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        if (Build.VERSION.SDK_INT >= 23) {
            ShellImpl.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"chmod +x ", (Object)absoluteFilePath));
        } else {
            ShellImpl.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"chmod 777 ", (Object)absoluteFilePath));
        }
    }

    @RequiresApi(value=21)
    public final void moveToTmpAndMakeExecutable(@NotNull String src, @NotNull String dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ShellImpl.INSTANCE.executeCommand("cp " + src + ' ' + dst);
        this.chmodExecutable(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=21)
    @NotNull
    public final String createRunnableExecutable(@NotNull String name, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        File externalDir = Outputs.INSTANCE.getDirUsableByAppAndShell();
        File writableExecutableFile = File.createTempFile(Intrinsics.stringPlus((String)"temporary_", (Object)name), null, externalDir);
        String runnableExecutablePath = Intrinsics.stringPlus((String)"/data/local/tmp/", (Object)name);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)writableExecutableFile, (String)"writableExecutableFile");
            Object object = writableExecutableFile;
            boolean bl = false;
            object = new FileOutputStream((File)object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl3 = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = writableExecutableFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"writableExecutableFile.absolutePath");
            this.moveToTmpAndMakeExecutable((String)object, runnableExecutablePath);
        }
        finally {
            writableExecutableFile.delete();
        }
        return runnableExecutablePath;
    }

    @RequiresApi(value=21)
    public final boolean isSessionRooted() {
        String string = ShellImpl.INSTANCE.executeCommand("getprop service.adb.root");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)"1");
    }

    @RequiresApi(value=21)
    @NotNull
    public final String executeScript(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return (String)ShellImpl.INSTANCE.executeScript(script, stdin, false).getFirst();
    }

    public static /* synthetic */ String executeScript$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScript(string, string2);
    }

    @RequiresApi(value=21)
    @NotNull
    public final Output executeScriptWithStderr(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Pair<String, String> pair = ShellImpl.INSTANCE.executeScript(script, stdin, true);
        boolean bl = false;
        boolean bl2 = false;
        Pair<String, String> $this$executeScriptWithStderr_u24lambda_u2d2 = pair;
        boolean bl3 = false;
        String string = (String)$this$executeScriptWithStderr_u24lambda_u2d2.getFirst();
        Object object = $this$executeScriptWithStderr_u24lambda_u2d2.getSecond();
        Intrinsics.checkNotNull((Object)object);
        return new Output(string, (String)object);
    }

    public static /* synthetic */ Output executeScriptWithStderr$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScriptWithStderr(string, string2);
    }

    @RequiresApi(value=21)
    public final boolean isPackageAlive(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Collection collection = this.getPidsForProcess(packageName);
        boolean bl = false;
        return !collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @NotNull
    public final List<Integer> getPidsForProcess(@NotNull String processName) {
        Object $this$filterTo$iv$iv;
        Object object;
        boolean bl;
        CharSequence charSequence;
        Collection collection;
        String it;
        Object item$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        if (Build.VERSION.SDK_INT >= 24) {
            void $this$mapTo$iv$iv22;
            boolean bl2;
            CharSequence charSequence2;
            String it2;
            Iterable $this$filterTo$iv$iv2;
            CharSequence charSequence3 = this.executeCommand(Intrinsics.stringPlus((String)"pidof ", (Object)processName));
            boolean bl3 = false;
            String string = charSequence3;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Regex regex = new Regex("\\s+");
            int n = 0;
            boolean bl4 = false;
            Iterable $this$filter$iv = regex.split(charSequence3, n);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (String)element$iv$iv;
                boolean bl5 = false;
                charSequence2 = it2;
                bl2 = false;
                boolean bl6 = charSequence2.length() > 0;
                if (!bl6) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv22) {
                it2 = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv;
                boolean bl7 = false;
                charSequence2 = it2;
                bl2 = false;
                Integer n2 = Integer.parseInt((String)charSequence2);
                collection2.add(n2);
            }
            return (List)destination$iv$iv;
        }
        Object $this$map$iv = Shell.executeScript$default(this, Intrinsics.stringPlus((String)"ps | grep ", (Object)processName), null, 2, null);
        Regex $i$f$map = new Regex("\r?\n");
        int $this$mapTo$iv$iv22 = 0;
        boolean destination$iv$iv = false;
        $this$map$iv = $i$f$map.split((CharSequence)$this$map$iv, $this$mapTo$iv$iv22);
        boolean $i$f$map2 = false;
        Object $this$mapTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv22.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl8 = false;
            charSequence = it;
            bl = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)string)).toString();
            collection.add(object);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv22 = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl9 = false;
            if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv22.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl10 = false;
            charSequence = it;
            Regex regex = new Regex("\\s+");
            int n = 0;
            boolean bl11 = false;
            charSequence = (String)regex.split(charSequence, n).get(1);
            bl = false;
            object = Integer.parseInt(charSequence);
            collection.add(object);
        }
        return (List)destination$iv$iv2;
    }

    @RequiresApi(value=21)
    public final boolean isProcessAlive(int pid, @NotNull String processName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            CharSequence charSequence = this.executeCommand(Intrinsics.stringPlus((String)"ps ", (Object)pid));
            Regex regex = new Regex("\r?\n");
            int n = 0;
            boolean bl2 = false;
            Iterable $this$any$iv = regex.split(charSequence, n);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    public final void terminateProcessesAndWait(long waitPollPeriodMs, int waitPollMaxCount, @NotNull String processName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Iterable $this$map$iv = this.getPidsForProcess(processName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pid;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProcessPid processPid = new ProcessPid(processName, (int)pid);
            collection.add(processPid);
        }
        List processes = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = processes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProcessPid[] processPidArray = thisCollection$iv.toArray(new ProcessPid[0]);
        if (processPidArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ProcessPid[] processPidArray2 = processPidArray;
        this.terminateProcessesAndWait(waitPollPeriodMs, waitPollMaxCount, Arrays.copyOf(processPidArray2, processPidArray2.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    public final void terminateProcessesAndWait(long waitPollPeriodMs, int waitPollMaxCount, ProcessPid ... processes) {
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        ProcessPid[] $this$forEach$iv = processes;
        boolean $i$f$forEach = false;
        ProcessPid[] processPidArray = $this$forEach$iv;
        int n = processPidArray.length;
        for (int i = 0; i < n; ++i) {
            ProcessPid element$iv;
            ProcessPid it = element$iv = processPidArray[i];
            boolean bl = false;
            String stopOutput = INSTANCE.executeCommand(Intrinsics.stringPlus((String)"kill -TERM ", (Object)it.getPid()));
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"kill -TERM command output - ", (Object)stopOutput));
        }
        List runningProcesses = null;
        runningProcesses = ArraysKt.toList((Object[])processes);
        boolean bl = false;
        int n2 = 0;
        n = waitPollMaxCount;
        for (n2 = 0; n2 < n; ++n2) {
            void $this$filterTo$iv$iv;
            int it = n2;
            boolean bl2 = false;
            Iterable $this$filter$iv = runningProcesses;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProcessPid it2 = (ProcessPid)element$iv$iv;
                boolean bl3 = false;
                if (!INSTANCE.isProcessAlive(it2.getPid(), it2.getProcessName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            runningProcesses = list;
            if (runningProcesses.isEmpty()) {
                return;
            }
            String label$iv = "wait for " + runningProcesses + " to die";
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.INSTANCE.startSection(label$iv);
            try {
                boolean bl4 = false;
                SystemClock.sleep((long)waitPollPeriodMs);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                UserspaceTracing.INSTANCE.endSection();
            }
            Log.d((String)"Benchmark", (String)("Waiting " + waitPollPeriodMs + " ms for " + runningProcesses + " to die"));
        }
        throw new IllegalStateException(Intrinsics.stringPlus((String)"Failed to stop ", (Object)runningProcesses));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/Shell$Output;", "", "stdout", "", "stderr", "(Ljava/lang/String;Ljava/lang/String;)V", "getStderr", "()Ljava/lang/String;", "getStdout", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "benchmark-common_release"})
    public static final class Output {
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        public Output(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        @NotNull
        public final String component1() {
            return this.stdout;
        }

        @NotNull
        public final String component2() {
            return this.stderr;
        }

        @NotNull
        public final Output copy(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            return new Output(stdout, stderr);
        }

        public static /* synthetic */ Output copy$default(Output output, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = output.stdout;
            }
            if ((n & 2) != 0) {
                string2 = output.stderr;
            }
            return output.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Output(stdout=" + this.stdout + ", stderr=" + this.stderr + ')';
        }

        public int hashCode() {
            int result = this.stdout.hashCode();
            result = result * 31 + this.stderr.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.stdout, (Object)output.stdout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stderr, (Object)output.stderr);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u000fJ\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/benchmark/Shell$ProcessPid;", "", "processName", "", "pid", "", "(Ljava/lang/String;I)V", "getPid", "()I", "getProcessName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "isAlive", "toString", "benchmark-common_release"})
    @RequiresApi(value=21)
    public static final class ProcessPid {
        @NotNull
        private final String processName;
        private final int pid;

        public ProcessPid(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            this.processName = processName;
            this.pid = pid;
        }

        @NotNull
        public final String getProcessName() {
            return this.processName;
        }

        public final int getPid() {
            return this.pid;
        }

        public final boolean isAlive() {
            return INSTANCE.isProcessAlive(this.pid, this.processName);
        }

        @NotNull
        public final String component1() {
            return this.processName;
        }

        public final int component2() {
            return this.pid;
        }

        @NotNull
        public final ProcessPid copy(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            return new ProcessPid(processName, pid);
        }

        public static /* synthetic */ ProcessPid copy$default(ProcessPid processPid, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = processPid.processName;
            }
            if ((n2 & 2) != 0) {
                n = processPid.pid;
            }
            return processPid.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ProcessPid(processName=" + this.processName + ", pid=" + this.pid + ')';
        }

        public int hashCode() {
            int result = this.processName.hashCode();
            result = result * 31 + Integer.hashCode(this.pid);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessPid)) {
                return false;
            }
            ProcessPid processPid = (ProcessPid)other;
            if (!Intrinsics.areEqual((Object)this.processName, (Object)processPid.processName)) {
                return false;
            }
            return this.pid == processPid.pid;
        }
    }
}

