/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.UiAutomation;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J.\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/ShellImpl;", "", "()V", "uiAutomation", "Landroid/app/UiAutomation;", "kotlin.jvm.PlatformType", "executeCommand", "", "cmd", "executeScript", "Lkotlin/Pair;", "script", "stdin", "includeStderr", "", "benchmark-common_release"})
@RequiresApi(value=21)
final class ShellImpl {
    @NotNull
    public static final ShellImpl INSTANCE = new ShellImpl();
    private static final UiAutomation uiAutomation;

    private ShellImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String executeCommand(@NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        ParcelFileDescriptor parcelFileDescriptor = uiAutomation.executeShellCommand(cmd);
        Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ParcelFileDescriptor.AutoCloseInputStream inputStream = (ParcelFileDescriptor.AutoCloseInputStream)closeable;
            boolean bl3 = false;
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)((InputStream)inputStream));
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
            boolean bl4 = false;
            boolean bl5 = false;
            String string = new String(byArray, charset);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<String, String> executeScript(@NotNull String script, @Nullable String stdin, boolean includeStderr) {
        boolean bl;
        File file;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        File externalDir = Outputs.INSTANCE.getDirUsableByAppAndShell();
        File writableScriptFile = File.createTempFile("temporaryScript", ".sh", externalDir);
        String runnableScriptPath = Intrinsics.stringPlus((String)"/data/local/tmp/", (Object)writableScriptFile.getName());
        String string = stdin;
        if (string == null) {
            file = null;
        } else {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String $this$executeScript_u24lambda_u2d2 = string2;
            boolean bl4 = false;
            file = File.createTempFile("temporaryStdin", null, externalDir);
        }
        File stdinFile = file;
        String stderrPath = includeStderr ? Intrinsics.stringPlus((String)runnableScriptPath, (Object)"_stderr") : (String)null;
        try {
            String string3;
            String scriptText = script;
            if (stdinFile != null) {
                FilesKt.writeText$default((File)stdinFile, (String)stdin, null, (int)2, null);
                scriptText = "cat " + stdinFile.getAbsolutePath() + " | " + scriptText;
            }
            if (stderrPath != null) {
                scriptText = scriptText + " 2> " + stderrPath;
            }
            Intrinsics.checkNotNullExpressionValue((Object)writableScriptFile, (String)"writableScriptFile");
            FilesKt.writeText$default((File)writableScriptFile, (String)scriptText, null, (int)2, null);
            this.executeCommand("cp " + writableScriptFile.getAbsolutePath() + ' ' + runnableScriptPath);
            Shell.INSTANCE.chmodExecutable(runnableScriptPath);
            String stdout = this.executeCommand(runnableScriptPath);
            String string4 = stderrPath;
            if (string4 == null) {
                string3 = null;
            } else {
                String string5 = string4;
                boolean bl5 = false;
                bl = false;
                String $this$executeScript_u24lambda_u2d3 = string5;
                boolean bl6 = false;
                string3 = INSTANCE.executeCommand(Intrinsics.stringPlus((String)"cat ", (Object)stderrPath));
            }
            String stderr = string3;
            string4 = new Pair((Object)stdout, stderr);
            return string4;
        }
        finally {
            Object object = stdinFile;
            if (object != null) {
                ((File)object).delete();
            }
            object = stderrPath;
            if (object != null) {
                Object object2 = object;
                bl = false;
                boolean bl7 = false;
                Object $this$executeScript_u24lambda_u2d4 = object2;
                boolean bl8 = false;
                INSTANCE.executeCommand(Intrinsics.stringPlus((String)"rm ", (Object)stderrPath));
            }
            writableScriptFile.delete();
            this.executeCommand(Intrinsics.stringPlus((String)"rm ", (Object)runnableScriptPath));
        }
    }

    static {
        boolean bl = !Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "ShellImpl must not be initialized on the UI thread - UiAutomation must not be connected on the main thread!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
    }
}

