/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.perfetto.PerfettoConfigKt;
import androidx.benchmark.perfetto.PerfettoHelper;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0003J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/perfetto/PerfettoCapture;", "", "unbundled", "", "(Z)V", "helper", "Landroidx/benchmark/perfetto/PerfettoHelper;", "isRunning", "start", "", "packages", "", "", "stop", "destinationPath", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public final class PerfettoCapture {
    @NotNull
    private final PerfettoHelper helper;

    public PerfettoCapture(boolean unbundled) {
        this.helper = new PerfettoHelper(unbundled);
    }

    public /* synthetic */ PerfettoCapture(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int n2 = Build.VERSION.SDK_INT;
            bl = 21 <= n2 ? n2 <= 28 : false;
        }
        this(bl);
    }

    public final boolean isRunning() {
        return this.helper.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull List<String> packages) {
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        String label$iv = "start perfetto";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.INSTANCE.startSection(label$iv);
        try {
            boolean bl = false;
            File configProtoFile = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), "trace_config.pb");
            try {
                Unit unit;
                String label$iv2 = "write config";
                boolean $i$f$userspaceTrace2 = false;
                UserspaceTracing.INSTANCE.startSection(label$iv2);
                try {
                    boolean bl2 = false;
                    List atraceApps = Build.VERSION.SDK_INT <= 28 ? packages : CollectionsKt.listOf((Object)"*");
                    FilesKt.writeBytes((File)configProtoFile, (byte[])PerfettoConfigKt.validateAndEncode(PerfettoConfigKt.perfettoConfig(atraceApps)));
                    unit = Unit.INSTANCE;
                }
                finally {
                    UserspaceTracing.INSTANCE.endSection();
                }
                label$iv2 = "start perfetto process";
                $i$f$userspaceTrace2 = false;
                UserspaceTracing.INSTANCE.startSection(label$iv2);
                try {
                    boolean bl3 = false;
                    String string = configProtoFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configProtoFile.absolutePath");
                    this.helper.startCollecting(string, false);
                    unit = Unit.INSTANCE;
                }
                finally {
                    UserspaceTracing.INSTANCE.endSection();
                }
            }
            finally {
                configProtoFile.delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.INSTANCE.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull String destinationPath) {
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        String label$iv = "stop perfetto";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.INSTANCE.startSection(label$iv);
        try {
            boolean bl = false;
            this.helper.stopCollecting(500L, destinationPath);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.INSTANCE.endSection();
        }
    }

    public PerfettoCapture() {
        this(false, 1, null);
    }
}

