/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.app.Instrumentation;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.perfetto.PerfettoHelper;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0006\u0010\u0011\u001a\u00020\u0003J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J$\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\rJ\b\u0010!\u001a\u00020\u001dH\u0002R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/benchmark/perfetto/PerfettoHelper;", "", "unbundled", "", "(Z)V", "perfettoPid", "", "getPerfettoPid", "()Ljava/lang/Integer;", "setPerfettoPid", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "perfettoProcessName", "", "copyFileOutput", "destinationFile", "getPerfettoTmpOutputFilePath", "isRunning", "perfettoCommand", "configFilePath", "isTextProtoConfig", "perfettoStartupException", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "label", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "startCollecting", "", "stopCollecting", "waitTimeInMsecs", "", "stopPerfetto", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public final class PerfettoHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean unbundled;
    @Nullable
    private Integer perfettoPid;
    @NotNull
    private final String perfettoProcessName;
    @NotNull
    public static final String LOG_TAG = "PerfettoCapture";
    public static final int LOWEST_BUNDLED_VERSION_SUPPORTED = 29;
    @NotNull
    private static final String PERFETTO_TMP_OUTPUT_FILE = "/data/misc/perfetto-traces/trace_output.pb";
    @NotNull
    private static final String PERFETTO_TXT_PROTO_ARG = " --txt";
    private static final int PERFETTO_KILL_WAIT_COUNT = 30;
    private static final long PERFETTO_KILL_WAIT_TIME_MS = 500L;
    @NotNull
    private static final String UNBUNDLED_PERFETTO_ROOT_DIR = "/data/local/tmp";
    @NotNull
    private static final String UNBUNDLED_TEMP_OUTPUT_FILE = "/data/local/tmp/trace_output.pb";
    @NotNull
    private static final Set<String> SUPPORTED_64_ABIS;
    @NotNull
    private static final Set<String> SUPPORTED_32_ABIS;
    @NotNull
    private static final Lazy<String> unbundledPerfettoShellPath$delegate;

    public PerfettoHelper(boolean unbundled) {
        this.unbundled = unbundled;
        boolean bl = this.unbundled || Build.VERSION.SDK_INT >= 29;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Perfetto capture using the os version of perfetto requires API 29 or greater.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.perfettoProcessName = this.unbundled ? "tracebox" : "perfetto";
    }

    public /* synthetic */ PerfettoHelper(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = Build.VERSION.SDK_INT < 29;
        }
        this(bl);
    }

    @Nullable
    public final Integer getPerfettoPid() {
        return this.perfettoPid;
    }

    public final void setPerfettoPid(@Nullable Integer n) {
        this.perfettoPid = n;
    }

    private final IllegalStateException perfettoStartupException(String label, Exception cause) {
        return new IllegalStateException(StringsKt.trimIndent((String)("\n            " + label + "\n            Please report a bug, and include a logcat capture of the test run and failure.\n            " + DeviceInfo.INSTANCE.getDeviceSummaryString() + "\n            ")), cause);
    }

    public final void startCollecting(@NotNull String configFilePath, boolean isTextProtoConfig) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        CharSequence charSequence = configFilePath;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Perfetto config cannot be empty.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl2 = this.perfettoPid == null;
        bl = false;
        bl3 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Perfetto instance is already running";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        try {
            String string;
            Log.i((String)LOG_TAG, (String)"Cleanup perfetto before starting.");
            Companion.stopAllPerfettoProcesses();
            if (this.unbundled) {
                String path = "/data/local/tmp/config.pb";
                Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"rm ", (Object)path));
                Shell.INSTANCE.executeCommand("mv " + configFilePath + ' ' + path);
                string = path;
            } else {
                string = configFilePath;
            }
            String actualConfigPath = string;
            String outputPath = this.getPerfettoTmpOutputFilePath();
            String output = Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"rm ", (Object)outputPath));
            Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Perfetto output file cleanup - ", (Object)output));
            String perfettoCmd = this.perfettoCommand(actualConfigPath, isTextProtoConfig);
            Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Starting perfetto tracing with cmd: ", (Object)perfettoCmd));
            String string2 = Shell.executeScript$default(Shell.INSTANCE, perfettoCmd, null, 2, null);
            boolean bl6 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String perfettoCmdOutput = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Perfetto pid - ", (Object)perfettoCmdOutput));
            string2 = perfettoCmdOutput;
            bl6 = false;
            this.perfettoPid = Integer.parseInt(string2);
        }
        catch (IOException ioe) {
            throw this.perfettoStartupException("Unable to start perfetto tracing", ioe);
        }
        if (!this.isRunning()) {
            throw this.perfettoStartupException("Perfetto tracing failed to start.", null);
        }
        Log.i((String)LOG_TAG, (String)("Perfetto tracing started successfully with pid " + this.perfettoPid + '.'));
    }

    public final boolean isRunning() {
        boolean bl;
        Integer n = this.perfettoPid;
        if (n == null) {
            bl = false;
        } else {
            boolean bl2;
            Integer n2 = n;
            boolean bl3 = false;
            boolean bl4 = false;
            int it = ((Number)n2).intValue();
            boolean bl5 = false;
            bl = bl2 = Shell.INSTANCE.isProcessAlive(it, this.perfettoProcessName);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopCollecting(long waitTimeInMsecs, @NotNull String destinationFile) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        String label$iv = "Wait for perfetto flush";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.INSTANCE.startSection(label$iv);
        try {
            boolean bl = false;
            Log.i((String)LOG_TAG, (String)("Waiting for " + waitTimeInMsecs + " millis before stopping perfetto."));
            SystemClock.sleep((long)waitTimeInMsecs);
            unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.INSTANCE.endSection();
        }
        Log.i((String)LOG_TAG, (String)"Stopping perfetto.");
        label$iv = "stop perfetto process";
        $i$f$userspaceTrace = false;
        UserspaceTracing.INSTANCE.startSection(label$iv);
        try {
            boolean bl = false;
            this.stopPerfetto();
            unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.INSTANCE.endSection();
        }
        Log.i((String)LOG_TAG, (String)("Writing to " + destinationFile + '.'));
        label$iv = "copy trace to output dir";
        $i$f$userspaceTrace = false;
        UserspaceTracing.INSTANCE.startSection(label$iv);
        try {
            boolean bl = false;
            boolean bl2 = this.copyFileOutput(destinationFile);
        }
        finally {
            UserspaceTracing.INSTANCE.endSection();
        }
    }

    private final void stopPerfetto() {
        Integer pid = this.perfettoPid;
        boolean bl = pid != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Shell.ProcessPid[] processPidArray = new Shell.ProcessPid[1];
        String string = this.perfettoProcessName;
        processPidArray[0] = new Shell.ProcessPid(string, pid);
        Shell.INSTANCE.terminateProcessesAndWait(500L, 30, processPidArray);
        this.perfettoPid = null;
    }

    private final String perfettoCommand(String configFilePath, boolean isTextProtoConfig) {
        String command;
        String outputPath = this.getPerfettoTmpOutputFilePath();
        String string = command = !this.unbundled ? "cat " + configFilePath + " | perfetto --background -c - -o " + outputPath : Companion.getUnbundledPerfettoShellPath() + " --background -c " + configFilePath + " -o " + outputPath;
        if (isTextProtoConfig) {
            command = Intrinsics.stringPlus((String)command, (Object)PERFETTO_TXT_PROTO_ARG);
        }
        return command;
    }

    private final String getPerfettoTmpOutputFilePath() {
        return this.unbundled ? UNBUNDLED_TEMP_OUTPUT_FILE : PERFETTO_TMP_OUTPUT_FILE;
    }

    private final boolean copyFileOutput(String destinationFile) {
        boolean success;
        File directory;
        String sourceFile = this.getPerfettoTmpOutputFilePath();
        File filePath = new File(destinationFile);
        String destDirectory = filePath.getParent();
        if (destDirectory != null && !(directory = new File(destDirectory)).exists() && !(success = directory.mkdirs())) {
            Log.e((String)LOG_TAG, (String)("Result output directory " + destDirectory + " not created successfully."));
            return false;
        }
        try {
            String moveResult = Shell.INSTANCE.executeCommand("mv " + sourceFile + ' ' + destinationFile);
            CharSequence charSequence = moveResult;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Log.e((String)LOG_TAG, (String)StringsKt.trimIndent((String)("\n                        Unable to move perfetto output file from " + sourceFile + "\n                        to " + destinationFile + " due to " + moveResult + ".\n                    ")));
                return false;
            }
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)"Unable to move the perfetto trace file to destination file.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    public PerfettoHelper() {
        this(false, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"arm64-v8a", "x86_64"};
        SUPPORTED_64_ABIS = SetsKt.setOf((Object[])objectArray);
        SUPPORTED_32_ABIS = SetsKt.setOf((Object)"armeabi");
        unbundledPerfettoShellPath$delegate = LazyKt.lazy((Function0)Companion.unbundledPerfettoShellPath.2.INSTANCE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/perfetto/PerfettoHelper$Companion;", "", "()V", "LOG_TAG", "", "LOWEST_BUNDLED_VERSION_SUPPORTED", "", "PERFETTO_KILL_WAIT_COUNT", "PERFETTO_KILL_WAIT_TIME_MS", "", "PERFETTO_TMP_OUTPUT_FILE", "PERFETTO_TXT_PROTO_ARG", "SUPPORTED_32_ABIS", "", "SUPPORTED_64_ABIS", "UNBUNDLED_PERFETTO_ROOT_DIR", "UNBUNDLED_TEMP_OUTPUT_FILE", "unbundledPerfettoShellPath", "getUnbundledPerfettoShellPath", "()Ljava/lang/String;", "unbundledPerfettoShellPath$delegate", "Lkotlin/Lazy;", "createExecutable", "tool", "isAbiSupported", "", "stopAllPerfettoProcesses", "", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAbiSupported() {
            String it;
            String[] stringArray = Build.SUPPORTED_ABIS;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SUPPORTED_ABIS");
            Log.d((String)PerfettoHelper.LOG_TAG, (String)Intrinsics.stringPlus((String)"Supported ABIs: ", (Object)ArraysKt.joinToString$default((Object[])stringArray, null, null, null, (int)0, null, null, (int)63, null)));
            String string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Cuttlefish", (boolean)false, (int)2, null)) return false;
            String[] stringArray2 = Build.SUPPORTED_64_BIT_ABIS;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"SUPPORTED_64_BIT_ABIS");
            Object[] objectArray = stringArray2;
            boolean $i$f$any = false;
            for (Object element$iv : objectArray) {
                it = (String)element$iv;
                boolean bl = false;
                if (!SUPPORTED_64_ABIS.contains(it)) continue;
                return true;
            }
            boolean bl = false;
            if (bl) return true;
            String[] stringArray3 = Build.SUPPORTED_32_BIT_ABIS;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"SUPPORTED_32_BIT_ABIS");
            Object[] objectArray2 = stringArray3;
            $i$f$any = false;
            Object[] objectArray3 = objectArray2;
            int n = objectArray3.length;
            int n2 = 0;
            while (n2 < n) {
                Object element$iv;
                element$iv = objectArray3[n2];
                it = (String)element$iv;
                boolean bl2 = false;
                if (SUPPORTED_32_ABIS.contains(it)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @NotNull
        public final String getUnbundledPerfettoShellPath() {
            Lazy lazy = unbundledPerfettoShellPath$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String createExecutable(@NotNull String tool) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            String label$iv = Intrinsics.stringPlus((String)"create executable: ", (Object)tool);
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.INSTANCE.startSection(label$iv);
            try {
                Serializable serializable;
                boolean bl;
                String it;
                boolean $i$f$any;
                Object[] $this$any$iv;
                block13: {
                    boolean bl2 = false;
                    if (!Companion.isAbiSupported()) {
                        StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
                        String[] stringArray = Build.SUPPORTED_ABIS;
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SUPPORTED_ABIS");
                        throw new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])stringArray, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
                    }
                    String[] stringArray = Build.SUPPORTED_64_BIT_ABIS;
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SUPPORTED_64_BIT_ABIS");
                    $this$any$iv = stringArray;
                    $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.startsWith$default((String)it, (String)"x86_64", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
                if (bl) {
                    serializable = (Serializable)((Object)"x86_64");
                } else {
                    boolean bl2;
                    block14: {
                        $this$any$iv = Build.SUPPORTED_64_BIT_ABIS;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"SUPPORTED_64_BIT_ABIS");
                        $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl5 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!StringsKt.startsWith$default((String)it, (String)"arm64", (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block14;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        serializable = (Serializable)((Object)"aarch64");
                    } else {
                        boolean bl3;
                        block15: {
                            $this$any$iv = Build.SUPPORTED_32_BIT_ABIS;
                            Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"SUPPORTED_32_BIT_ABIS");
                            $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl7 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                if (!StringsKt.startsWith$default((String)it, (String)"armeabi", (boolean)false, (int)2, null)) continue;
                                bl3 = true;
                                break block15;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            serializable = (Serializable)((Object)"arm");
                        } else {
                            StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
                            $this$any$iv = Build.SUPPORTED_ABIS;
                            Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"SUPPORTED_ABIS");
                            serializable = new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])$this$any$iv, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
                        }
                    }
                }
                Serializable suffix = serializable;
                Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
                InputStream inputStream = instrumentation.getContext().getAssets().open(tool + '_' + suffix);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"instrumentation.context.\u2026s.open(\"${tool}_$suffix\")");
                InputStream inputStream2 = inputStream;
                String string = Shell.INSTANCE.createRunnableExecutable(tool, inputStream2);
                return string;
            }
            finally {
                UserspaceTracing.INSTANCE.endSection();
            }
        }

        public final void stopAllPerfettoProcesses() {
            Object[] objectArray = new String[]{"perfetto", "tracebox"};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String processName = (String)element$iv;
                boolean bl = false;
                Shell.INSTANCE.terminateProcessesAndWait(500L, 30, processName);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

