/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.annotation.RestrictTo;
import androidx.benchmark.ConfigurationError;
import androidx.benchmark.ConfigurationErrorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u001a\"\u0010\b\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0007\u001a\u001a\u0010\r\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u00a8\u0006\u000f"}, d2={"conditionalError", "Landroidx/benchmark/ConfigurationError;", "hasError", "", "id", "", "summary", "message", "checkAndGetSuppressionState", "Landroidx/benchmark/ConfigurationError$SuppressionState;", "", "suppressedErrorIds", "", "prettyPrint", "prefix", "benchmark-common_release"})
public final class ConfigurationErrorKt {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final ConfigurationError conditionalError(boolean hasError, @NotNull String id, @NotNull String summary, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ConfigurationError.Companion.validateParams$benchmark_common_release(id, summary);
        return hasError ? new ConfigurationError(id, summary, message) : null;
    }

    @NotNull
    public static final String prettyPrint(@NotNull List<ConfigurationError> $this$prettyPrint, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter($this$prettyPrint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        return CollectionsKt.joinToString$default((Iterable)$this$prettyPrint, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<ConfigurationError, CharSequence>(prefix2){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ConfigurationError it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$prefix + it.getSummary() + '\n' + StringsKt.prependIndent$default((String)it.getMessage(), null, (int)1, null) + '\n';
            }
        }), (int)30, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final ConfigurationError.SuppressionState checkAndGetSuppressionState(@NotNull List<ConfigurationError> $this$checkAndGetSuppressionState, @NotNull Set<String> suppressedErrorIds) {
        Intrinsics.checkNotNullParameter($this$checkAndGetSuppressionState, (String)"<this>");
        Intrinsics.checkNotNullParameter(suppressedErrorIds, (String)"suppressedErrorIds");
        Iterable $this$partition$iv = $this$checkAndGetSuppressionState;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            ConfigurationError it = (ConfigurationError)element$iv;
            boolean bl = false;
            if (suppressedErrorIds.contains(it.getId())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List suppressed = (List)pair.component1();
        List unsuppressed = (List)pair.component2();
        String prefix2 = CollectionsKt.joinToString$default((Iterable)suppressed, (CharSequence)"_", null, null, (int)0, null, (Function1)checkAndGetSuppressionState.prefix.1.INSTANCE, (int)30, null) + '_';
        String unsuppressedString2 = CollectionsKt.joinToString$default((Iterable)unsuppressed, (CharSequence)" ", null, null, (int)0, null, (Function1)checkAndGetSuppressionState.unsuppressedString.1.INSTANCE, (int)30, null);
        String suppressedString2 = CollectionsKt.joinToString$default((Iterable)suppressed, (CharSequence)" ", null, null, (int)0, null, (Function1)checkAndGetSuppressionState.suppressedString.1.INSTANCE, (int)30, null);
        String howToSuppressString2 = CollectionsKt.joinToString$default((Iterable)$this$checkAndGetSuppressionState, (CharSequence)",", null, null, (int)0, null, (Function1)checkAndGetSuppressionState.howToSuppressString.1.INSTANCE, (int)30, null);
        if (!((Collection)unsuppressed).isEmpty()) {
            throw new AssertionError((Object)StringsKt.trimMargin$default((String)("\n                |ERRORS (not suppressed): " + unsuppressedString2 + "\n                |WARNINGS (suppressed): " + suppressedString2 + "\n                |\n                |" + ConfigurationErrorKt.prettyPrint(unsuppressed, "ERROR: ") + "\n                |While you can suppress these errors (turning them into warnings)\n                |PLEASE NOTE THAT EACH SUPPRESSED ERROR COMPROMISES ACCURACY\n                |\n                |// Sample suppression, in a benchmark module's build.gradle:\n                |android {\n                |    defaultConfig {\n                |        testInstrumentationRunnerArguments[\"androidx.benchmark.suppressErrors\"] = \"" + howToSuppressString2 + "\"\n                |    }\n                |}\n            "), null, (int)1, null));
        }
        if (suppressed.isEmpty()) {
            return null;
        }
        return new ConfigurationError.SuppressionState(prefix2, ConfigurationErrorKt.prettyPrint(suppressed, "WARNING: "));
    }
}

