/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Shell;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/benchmark/PropOverride;", "", "propName", "", "overrideValue", "(Ljava/lang/String;Ljava/lang/String;)V", "resetValue", "forceValue", "", "resetIfOverridden", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public final class PropOverride {
    @NotNull
    private final String propName;
    @NotNull
    private final String overrideValue;
    @Nullable
    private String resetValue;

    public PropOverride(@NotNull String propName, @NotNull String overrideValue) {
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        Intrinsics.checkNotNullParameter((Object)overrideValue, (String)"overrideValue");
        this.propName = propName;
        this.overrideValue = overrideValue;
    }

    public final void forceValue() {
        if (this.resetValue != null) {
            return;
        }
        String currentPropVal = ((Object)StringsKt.trim((CharSequence)Shell.INSTANCE.executeCommand("getprop " + this.propName))).toString();
        if (!Intrinsics.areEqual((Object)currentPropVal, (Object)this.overrideValue)) {
            this.resetValue = currentPropVal;
            Log.d((String)"Benchmark", (String)("setting " + this.propName + " to " + this.overrideValue + " (was " + currentPropVal + ')'));
            Shell.INSTANCE.executeCommand("setprop " + this.propName + ' ' + this.overrideValue);
        }
    }

    public final void resetIfOverridden() {
        if (this.resetValue != null) {
            Log.d((String)"Benchmark", (String)("resetting " + this.propName + " to " + this.resetValue));
        }
    }
}

