/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.UiAutomation;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.Trace;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ.\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/benchmark/ShellImpl;", "", "()V", "isSessionRooted", "", "()Z", "setSessionRooted", "(Z)V", "isSuAvailable", "setSuAvailable", "uiAutomation", "Landroid/app/UiAutomation;", "kotlin.jvm.PlatformType", "executeCommand", "", "cmd", "executeScript", "Lkotlin/Pair;", "script", "stdin", "includeStderr", "benchmark-common_release"})
@RequiresApi(value=21)
final class ShellImpl {
    @NotNull
    public static final ShellImpl INSTANCE = new ShellImpl();
    private static final UiAutomation uiAutomation;
    private static boolean isSessionRooted;
    private static boolean isSuAvailable;

    private ShellImpl() {
    }

    public final boolean isSessionRooted() {
        return isSessionRooted;
    }

    public final void setSessionRooted(boolean bl) {
        isSessionRooted = bl;
    }

    public final boolean isSuAvailable() {
        return isSuAvailable;
    }

    public final void setSuAvailable(boolean bl) {
        isSuAvailable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String executeCommand(@NotNull String cmd) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String label$iv = StringsKt.take((String)("executeCommand " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            String string2;
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            ParcelFileDescriptor parcelFileDescriptor = ShellImpl.uiAutomation.executeShellCommand(!INSTANCE.isSessionRooted() && INSTANCE.isSuAvailable() ? "su root " + cmd : cmd);
            Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
            Throwable throwable = null;
            try {
                ParcelFileDescriptor.AutoCloseInputStream inputStream = (ParcelFileDescriptor.AutoCloseInputStream)closeable;
                boolean bl2 = false;
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)((InputStream)inputStream));
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                Charset charset2 = charset;
                string2 = new String(byArray, charset2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = string2;
        }
        finally {
            Trace.endSection();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<String, String> executeScript(@NotNull String script, @Nullable String stdin, boolean includeStderr) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String label$iv = StringsKt.take((String)("executeScript " + script), (int)127);
        boolean $i$f$trace = false;
        try {
            Pair pair2;
            File file;
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            File externalDir = Outputs.INSTANCE.getDirUsableByAppAndShell();
            File writableScriptFile = File.createTempFile("temporaryScript", ".sh", externalDir);
            String runnableScriptPath = "/data/local/tmp/" + writableScriptFile.getName();
            String string = stdin;
            if (string != null) {
                String $this$executeScript_u24lambda_u2d5_u24lambda_u2d3 = string;
                boolean bl2 = false;
                file = File.createTempFile("temporaryStdin", null, externalDir);
            } else {
                file = null;
            }
            File stdinFile = file;
            String stderrPath = includeStderr ? runnableScriptPath + "_stderr" : (String)null;
            try {
                String string2;
                String scriptText = script;
                if (stdinFile != null) {
                    FilesKt.writeText$default((File)stdinFile, (String)stdin, null, (int)2, null);
                    scriptText = "cat " + stdinFile.getAbsolutePath() + " | " + scriptText;
                }
                if (stderrPath != null) {
                    scriptText = scriptText + " 2> " + stderrPath;
                }
                Intrinsics.checkNotNullExpressionValue((Object)writableScriptFile, (String)"writableScriptFile");
                FilesKt.writeText$default((File)writableScriptFile, (String)scriptText, null, (int)2, null);
                INSTANCE.executeCommand("cp " + writableScriptFile.getAbsolutePath() + ' ' + runnableScriptPath);
                Shell.INSTANCE.chmodExecutable(runnableScriptPath);
                String stdout = INSTANCE.executeCommand(runnableScriptPath);
                String string3 = stderrPath;
                if (string3 != null) {
                    String $this$executeScript_u24lambda_u2d5_u24lambda_u2d4 = string3;
                    boolean bl3 = false;
                    string2 = INSTANCE.executeCommand("cat " + stderrPath);
                } else {
                    string2 = null;
                }
                String stderr = string2;
                pair2 = new Pair((Object)stdout, stderr);
            }
            finally {
                File file2 = stdinFile;
                if (file2 != null) {
                    file2.delete();
                }
                writableScriptFile.delete();
                if (stderrPath != null) {
                    INSTANCE.executeCommand("rm " + stderrPath + ' ' + runnableScriptPath);
                } else {
                    INSTANCE.executeCommand("rm " + runnableScriptPath);
                }
            }
            pair = pair2;
        }
        finally {
            Trace.endSection();
        }
        return pair;
    }

    static {
        if (!(!Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread()))) {
            boolean bl = false;
            String string = "ShellImpl must not be initialized on the UI thread - UiAutomation must not be connected on the main thread!";
            throw new IllegalArgumentException(string.toString());
        }
        uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        isSessionRooted = StringsKt.contains$default((CharSequence)INSTANCE.executeCommand("id"), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
        isSuAvailable = StringsKt.contains$default((CharSequence)((CharSequence)INSTANCE.executeScript("su root id", null, false).getFirst()), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
    }
}

