/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.opengl.Matrix;
import android.os.Build;
import android.os.PowerManager;
import androidx.annotation.RequiresApi;
import androidx.benchmark.BenchmarkState;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.Errors;
import androidx.benchmark.IsolationActivity;
import androidx.test.platform.app.InstrumentationRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0006\u0010\b\u001a\u00020\tJ\r\u0010\n\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000bJ\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/benchmark/ThrottleDetector;", "", "()V", "initNs", "", "computeThrottleBaselineIfNeeded", "", "copySomeData", "isDeviceThermalThrottled", "", "measureWorkNs", "measureWorkNs$benchmark_common_release", "resetThrottleBaseline", "Api29Helper", "benchmark-common_release"})
public final class ThrottleDetector {
    @NotNull
    public static final ThrottleDetector INSTANCE = new ThrottleDetector();
    private static double initNs;

    private ThrottleDetector() {
    }

    private final void copySomeData() {
        byte[] a = new byte[400000];
        byte[] b = new byte[400000];
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            System.arraycopy(a, 0, b, 0, a.length);
        }
    }

    public final double measureWorkNs$benchmark_common_release() {
        this.copySomeData();
        BenchmarkState state = new BenchmarkState(true);
        int n = 0;
        float[] fArray = new float[16];
        while (n < 16) {
            int n2 = n++;
            fArray[n2] = System.nanoTime();
        }
        float[] sourceMatrix = fArray;
        float[] resultMatrix = new float[16];
        while (true) {
            boolean bl;
            BenchmarkState this_$iv = state;
            boolean $i$f$keepRunningInline = false;
            if (this_$iv.iterationsRemaining > 1) {
                int n3 = this_$iv.iterationsRemaining;
                this_$iv.iterationsRemaining = n3 + -1;
                bl = true;
            } else {
                bl = this_$iv.keepRunningInternal();
            }
            if (!bl) break;
            Matrix.translateM((float[])resultMatrix, (int)0, (float[])sourceMatrix, (int)0, (float)1.0f, (float)2.0f, (float)3.0f);
        }
        return state.getMinTimeNanos();
    }

    public final void computeThrottleBaselineIfNeeded() {
        if (Build.VERSION.SDK_INT < 29 && initNs == 0.0 && !CpuInfo.INSTANCE.getLocked() && !IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release() && !Errors.INSTANCE.isEmulator()) {
            initNs = this.measureWorkNs$benchmark_common_release();
        }
    }

    public final void resetThrottleBaseline() {
        initNs = 0.0;
    }

    public final boolean isDeviceThermalThrottled() {
        if (Build.VERSION.SDK_INT >= 29) {
            return Api29Helper.INSTANCE.isDeviceThermalThrottled();
        }
        if (initNs == 0.0) {
            return false;
        }
        double workNs = this.measureWorkNs$benchmark_common_release();
        return workNs > initNs * 1.1;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/benchmark/ThrottleDetector$Api29Helper;", "", "()V", "isDeviceThermalThrottled", "", "benchmark-common_release"})
    @RequiresApi(value=29)
    public static final class Api29Helper {
        @NotNull
        public static final Api29Helper INSTANCE = new Api29Helper();

        private Api29Helper() {
        }

        public final boolean isDeviceThermalThrottled() {
            Object object = InstrumentationRegistry.getInstrumentation().getContext().getSystemService("power");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
            return ((PowerManager)object).getCurrentThermalStatus() > 0;
        }
    }
}

