/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.PropOverride;
import androidx.benchmark.perfetto.PerfettoCapture;
import androidx.benchmark.perfetto.PerfettoHelper;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0003J\u001f\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0003\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/benchmark/perfetto/PerfettoCaptureWrapper;", "", "()V", "TRACE_ENABLE_PROP", "", "capture", "Landroidx/benchmark/perfetto/PerfettoCapture;", "record", "benchmarkName", "packages", "", "iteration", "", "block", "Lkotlin/Function0;", "", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;Lkotlin/jvm/functions/Function0;)Ljava/lang/String;", "start", "", "stop", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/String;", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PerfettoCaptureWrapper {
    @Nullable
    private PerfettoCapture capture;
    @NotNull
    private final String TRACE_ENABLE_PROP;

    public PerfettoCaptureWrapper() {
        this.TRACE_ENABLE_PROP = "persist.traced.enable";
        if (Build.VERSION.SDK_INT >= 21) {
            this.capture = new PerfettoCapture(false, 1, null);
        }
    }

    @RequiresApi(value=21)
    private final boolean start(List<String> packages) {
        block1: {
            if (Build.VERSION.SDK_INT < 21) break block1;
            Log.d((String)"PerfettoCapture", (String)"Recording perfetto trace");
            PerfettoCapture perfettoCapture = this.capture;
            if (perfettoCapture != null) {
                perfettoCapture.start(packages);
            }
        }
        return true;
    }

    @RequiresApi(value=21)
    private final String stop(String benchmarkName, Integer iteration) {
        String traceName = null;
        String reportKey = null;
        if (iteration != null) {
            String iterString = StringsKt.padStart((String)iteration.toString(), (int)3, (char)'0');
            traceName = benchmarkName + "_iter" + iterString + '_' + Outputs.dateToFileName$default(Outputs.INSTANCE, null, 1, null) + ".perfetto-trace";
            reportKey = "perfetto_trace_" + iterString;
        } else {
            traceName = benchmarkName + '_' + Outputs.dateToFileName$default(Outputs.INSTANCE, null, 1, null) + ".perfetto-trace";
            reportKey = "perfetto_trace";
        }
        return Outputs.writeFile$default(Outputs.INSTANCE, traceName, reportKey, false, (Function1)new Function1<File, Unit>(this){
            final /* synthetic */ PerfettoCaptureWrapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PerfettoCapture perfettoCapture = PerfettoCaptureWrapper.access$getCapture$p(this.this$0);
                Intrinsics.checkNotNull((Object)perfettoCapture);
                String string = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
                perfettoCapture.stop(string);
            }
        }, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String record(@NotNull String benchmarkName, @NotNull List<String> packages, @Nullable Integer iteration, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)benchmarkName, (String)"benchmarkName");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (Build.VERSION.SDK_INT < 21 || !PerfettoHelper.Companion.isAbiSupported()) {
            block.invoke();
            return null;
        }
        PropOverride propOverride = Build.VERSION.SDK_INT <= 29 ? new PropOverride(this.TRACE_ENABLE_PROP, "1") : null;
        try {
            PropOverride propOverride2 = propOverride;
            if (propOverride2 != null) {
                propOverride2.forceValue();
            }
            this.start(packages);
            String path = null;
            try {
                block.invoke();
            }
            finally {
                path = this.stop(benchmarkName, iteration);
            }
            String string = path;
            return string;
        }
        finally {
            block9: {
                PropOverride propOverride3 = propOverride;
                if (propOverride3 == null) break block9;
                propOverride3.resetIfOverridden();
            }
        }
    }

    public static /* synthetic */ String record$default(PerfettoCaptureWrapper perfettoCaptureWrapper, String string, List list, Integer n, Function0 function0, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return perfettoCaptureWrapper.record(string, list, n, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ PerfettoCapture access$getCapture$p(PerfettoCaptureWrapper $this) {
        return $this.capture;
    }
}

