/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.AllocationCountCapture;
import androidx.benchmark.Arguments;
import androidx.benchmark.BenchmarkResult;
import androidx.benchmark.Errors;
import androidx.benchmark.ExperimentalBenchmarkStateApi;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.MetricCapture;
import androidx.benchmark.MetricResult;
import androidx.benchmark.MetricsContainer;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import androidx.benchmark.ResultWriter;
import androidx.benchmark.ThreadPriority;
import androidx.benchmark.ThrottleDetector;
import androidx.benchmark.TimeCapture;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.WarmupManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.RequiresOptIn;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0017\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006B)\b\u0000\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000204H\u0002J\b\u00106\u001a\u000204H\u0002J\u001f\u00107\u001a\u0002042\u0006\u00108\u001a\u00020\t2\f\u00109\u001a\b\u0012\u0004\u0012\u00020+0:H\u0082\bJ\b\u0010;\u001a\u000204H\u0002J\b\u0010<\u001a\u00020\u0004H\u0002J\b\u0010=\u001a\u00020\tH\u0002J'\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020\t2\b\u0010B\u001a\u0004\u0018\u00010+H\u0000\u00a2\u0006\u0002\bCJ\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020E0$H\u0007J\b\u0010F\u001a\u00020EH\u0007J\r\u0010G\u001a\u00020HH\u0000\u00a2\u0006\u0002\bIJ\u0018\u0010G\u001a\u00020H2\u0006\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020+H\u0002J\u0006\u0010L\u001a\u00020\tJ\t\u0010M\u001a\u00020\tH\u0087\bJ\b\u0010N\u001a\u00020\tH\u0001J\u0006\u0010O\u001a\u000204J*\u0010P\u001a\u0002042\u0006\u0010Q\u001a\u00020+2\u0006\u0010R\u001a\u00020+2\u0006\u0010S\u001a\u00020+2\b\u0010B\u001a\u0004\u0018\u00010+H\u0007J\u0006\u0010T\u001a\u000204J\u0010\u0010U\u001a\u00020\t2\u0006\u0010V\u001a\u00020\"H\u0002J\b\u0010W\u001a\u00020\tH\u0002J\b\u0010X\u001a\u000204H\u0002R$\u0010\u000b\u001a\u00020\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0002R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b \u0010\u000eR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u00020+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Landroidx/benchmark/BenchmarkState;", "", "()V", "warmupCount", "", "repeatCount", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "measurementCount", "simplifiedTimingOnlyMode", "", "(Ljava/lang/Integer;Ljava/lang/Integer;Z)V", "iterationsPerRepeat", "getIterationsPerRepeat$benchmark_common_release$annotations", "getIterationsPerRepeat$benchmark_common_release", "()I", "setIterationsPerRepeat$benchmark_common_release", "(I)V", "iterationsRemaining", "getIterationsRemaining$annotations", "Ljava/lang/Integer;", "metricResults", "", "Landroidx/benchmark/MetricResult;", "metrics", "Landroidx/benchmark/MetricsContainer;", "paused", "profiler", "Landroidx/benchmark/Profiler;", "profilerResult", "Landroidx/benchmark/Profiler$ResultFile;", "repeatCountTime", "getRepeatCountTime$benchmark_common_release$annotations", "getRepeatCountTime$benchmark_common_release", "repeatDurationTargetNs", "", "stages", "", "state", "thermalThrottleSleepSeconds", "throttleRemainingRetries", "totalRunTimeNs", "totalRunTimeStartNs", "traceUniqueName", "", "getTraceUniqueName", "()Ljava/lang/String;", "setTraceUniqueName", "(Ljava/lang/String;)V", "warmupManager", "Landroidx/benchmark/WarmupManager;", "warmupRepeats", "afterBenchmark", "", "beforeBenchmark", "beginRunningStage", "check", "value", "lazyMessage", "Lkotlin/Function0;", "checkState", "computeMaxIterations", "endRunningStage", "getFullStatusReport", "Landroid/os/Bundle;", "key", "reportMetrics", "tracePath", "getFullStatusReport$benchmark_common_release", "getMeasurementTimeNs", "", "getMinTimeNanos", "getReport", "Landroidx/benchmark/BenchmarkResult;", "getReport$benchmark_common_release", "testName", "className", "keepRunning", "keepRunningInline", "keepRunningInternal", "pauseTiming", "report", "fullClassName", "simpleClassName", "methodName", "resumeTiming", "sleepIfThermalThrottled", "sleepSeconds", "startNextRepeat", "throwIfPaused", "Companion", "benchmark-common_release"})
public final class BenchmarkState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer warmupCount;
    @Nullable
    private final Integer measurementCount;
    private final boolean simplifiedTimingOnlyMode;
    private final int repeatCountTime;
    private final long repeatDurationTargetNs;
    @NotNull
    private List<MetricsContainer> stages;
    @NotNull
    private MetricsContainer metrics;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private String traceUniqueName;
    private int warmupRepeats;
    @JvmField
    public int iterationsRemaining;
    private int iterationsPerRepeat;
    private int state;
    @NotNull
    private final WarmupManager warmupManager;
    private boolean paused;
    private long thermalThrottleSleepSeconds;
    private long totalRunTimeStartNs;
    private long totalRunTimeNs;
    private int repeatCount;
    private int throttleRemainingRetries;
    @NotNull
    private List<MetricResult> metricResults;
    @Nullable
    private final Profiler profiler;
    @Nullable
    private Profiler.ResultFile profilerResult;
    @NotNull
    public static final String TAG = "Benchmark";
    private static final int NOT_STARTED = -1;
    private static final int RUNNING_WARMUP_STAGE = 0;
    private static final int RUNNING_TIME_STAGE = 1;
    private static final int RUNNING_ALLOCATION_STAGE = 2;
    private static final int FINISHED = 3;
    public static final int REPEAT_COUNT_ALLOCATION = 5;
    @Nullable
    private static final Integer OVERRIDE_ITERATIONS;
    public static final int MAX_TEST_ITERATIONS = 1000000;
    public static final int MIN_TEST_ITERATIONS = 1;
    private static final int THROTTLE_MAX_RETRIES = 2;
    private static final long THROTTLE_BACKOFF_S = 90L;
    private static boolean firstBenchmark;

    public BenchmarkState(@Nullable Integer warmupCount, @Nullable Integer measurementCount, boolean simplifiedTimingOnlyMode) {
        int n;
        this.warmupCount = warmupCount;
        this.measurementCount = measurementCount;
        this.simplifiedTimingOnlyMode = simplifiedTimingOnlyMode;
        if (!(this.warmupCount == null || this.warmupCount > 0)) {
            boolean $i$a$-require-BenchmarkState$32 = false;
            String $i$a$-require-BenchmarkState$32 = "warmupCount (" + this.warmupCount + ") must null or positive";
            throw new IllegalArgumentException($i$a$-require-BenchmarkState$32.toString());
        }
        if (!(this.measurementCount == null || this.measurementCount >= 1)) {
            boolean bl = false;
            String string = "measurementCount (" + this.measurementCount + ") must be null or positive";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.measurementCount != null) {
            n = this.measurementCount;
        } else if (Arguments.INSTANCE.getDryRunMode()) {
            n = 1;
        } else {
            Profiler profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release();
            n = (profiler != null ? profiler.getRequiresSingleMeasurementIteration() : false) ? 1 : (Arguments.INSTANCE.getStartupMode$benchmark_common_release() ? 10 : 50);
        }
        this.repeatCountTime = n;
        Profiler profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release();
        this.repeatDurationTargetNs = Intrinsics.areEqual((Object)(profiler != null ? Boolean.valueOf(profiler.getRequiresExtraRuntime()) : null), (Object)true) ? TimeUnit.MILLISECONDS.toNanos(50L) : TimeUnit.SECONDS.toNanos(Arguments.INSTANCE.getProfilerSampleDurationSeconds$benchmark_common_release()) / (long)this.repeatCountTime;
        Object[] objectArray = new MetricsContainer[3];
        MetricCapture[] metricCaptureArray = new MetricCapture[]{new TimeCapture()};
        objectArray[0] = new MetricsContainer(metricCaptureArray, 1);
        metricCaptureArray = new MetricCapture[]{new TimeCapture()};
        objectArray[1] = new MetricsContainer(metricCaptureArray, this.repeatCountTime);
        metricCaptureArray = new MetricCapture[]{new AllocationCountCapture()};
        objectArray[2] = new MetricsContainer(metricCaptureArray, 5);
        this.stages = CollectionsKt.listOf((Object[])objectArray);
        this.metrics = this.stages.get(0);
        this.traceUniqueName = "benchmark";
        this.iterationsRemaining = -1;
        this.iterationsPerRepeat = 1;
        this.state = -1;
        this.warmupManager = new WarmupManager(this.warmupCount);
        this.throttleRemainingRetries = 2;
        this.metricResults = new ArrayList();
        this.profiler = this.simplifiedTimingOnlyMode ? null : Arguments.INSTANCE.getProfiler$benchmark_common_release();
    }

    public /* synthetic */ BenchmarkState(Integer n, Integer n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        this(n, n2, bl);
    }

    public final int getRepeatCountTime$benchmark_common_release() {
        return this.repeatCountTime;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRepeatCountTime$benchmark_common_release$annotations() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BenchmarkState() {
        this(null, null, false, 2, null);
    }

    @ExperimentalBenchmarkStateApi
    public BenchmarkState(@Nullable Integer warmupCount, @Nullable Integer repeatCount) {
        this(warmupCount, repeatCount, false);
    }

    public /* synthetic */ BenchmarkState(Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        this(n, n2);
    }

    @NotNull
    public final String getTraceUniqueName() {
        return this.traceUniqueName;
    }

    public final void setTraceUniqueName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.traceUniqueName = string;
    }

    @PublishedApi
    public static /* synthetic */ void getIterationsRemaining$annotations() {
    }

    public final int getIterationsPerRepeat$benchmark_common_release() {
        return this.iterationsPerRepeat;
    }

    public final void setIterationsPerRepeat$benchmark_common_release(int n) {
        this.iterationsPerRepeat = n;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getIterationsPerRepeat$benchmark_common_release$annotations() {
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final double getMinTimeNanos() {
        Object element$iv2;
        block1: {
            this.checkState();
            Iterable $this$first$iv = this.metricResults;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((MetricResult)element$iv2).getMin();
    }

    private final void checkState() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.state != -1;
        boolean $i$f$check = false;
        if (!value$iv) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string = "Attempting to interact with a benchmark that wasn't started!";
            throw new IllegalStateException(string);
        }
        BenchmarkState this_$iv = this;
        value$iv = this.state == 3;
        $i$f$check = false;
        if (!value$iv) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string = "The benchmark hasn't finished! In Java, use while(BenchmarkState.keepRunning()) to ensure keepRunning() returns false before ending your test. In Kotlin, just use benchmarkRule.measureRepeated {} to avoid the problem.";
            throw new IllegalStateException(string);
        }
    }

    public final void pauseTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string = "Unable to pause the benchmark. The benchmark has already paused.";
            throw new IllegalStateException(string);
        }
        if (this.state != 0) {
            this.metrics.capturePaused();
        }
        this.paused = true;
    }

    public final void resumeTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string = "Unable to resume the benchmark. The benchmark is already running.";
            throw new IllegalStateException(string);
        }
        if (this.state != 0) {
            this.metrics.captureResumed();
        }
        this.paused = false;
    }

    private final void beginRunningStage() {
        this.metrics = this.stages.get(this.state);
        this.repeatCount = 0;
        this.metrics.captureInit();
        switch (this.state) {
            case 0: {
                Runtime.getRuntime().gc();
                this.iterationsPerRepeat = 1;
                UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, "Warmup", 0L, 2, null);
                break;
            }
            case 1: {
                Profiler profiler = this.profiler;
                this.profilerResult = profiler != null ? profiler.start(this.traceUniqueName) : null;
                UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, "Benchmark Time", 0L, 2, null);
                break;
            }
            case 2: {
                UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, "Benchmark Allocations", 0L, 2, null);
            }
        }
        this.iterationsRemaining = this.iterationsPerRepeat;
        this.metrics.captureStart();
    }

    private final boolean endRunningStage() {
        if (this.state != 0 && !this.simplifiedTimingOnlyMode && this.throttleRemainingRetries > 0 && this.sleepIfThermalThrottled(90L)) {
            Profiler profiler = this.profiler;
            if (profiler != null) {
                Profiler profiler2;
                Profiler $this$endRunningStage_u24lambda_u2d7 = profiler2 = profiler;
                boolean bl = false;
                $this$endRunningStage_u24lambda_u2d7.stop();
                $this$endRunningStage_u24lambda_u2d7.start(this.traceUniqueName);
            }
            --this.throttleRemainingRetries;
            this.metrics.captureInit();
            this.repeatCount = 0;
            return false;
        }
        UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
        switch (this.state) {
            case 0: {
                this.warmupRepeats = this.repeatCount;
                this.iterationsPerRepeat = this.computeMaxIterations();
                break;
            }
            case 1: 
            case 2: {
                this.metricResults.addAll((Collection<MetricResult>)this.metrics.captureFinished(this.iterationsPerRepeat));
            }
        }
        int n = this.state;
        this.state = n + 1;
        if (this.state == 2) {
            Profiler profiler = this.profiler;
            if (profiler != null) {
                profiler.stop();
            }
            if (this.simplifiedTimingOnlyMode || Arguments.INSTANCE.getStartupMode$benchmark_common_release() || Arguments.INSTANCE.getDryRunMode()) {
                n = this.state;
                this.state = n + 1;
            }
        }
        return true;
    }

    private final boolean startNextRepeat() {
        this.metrics.captureStop();
        int n = this.repeatCount;
        this.repeatCount = n + 1;
        if (this.state == 0) {
            this.metrics.captureInit();
            if (this.warmupManager.onNextIteration(((long[])ArraysKt.last((Object[])((Object[])this.metrics.getData$benchmark_common_release())))[0])) {
                this.endRunningStage();
                this.beginRunningStage();
            }
        } else if ((this.state == 1 && this.repeatCount >= this.repeatCountTime || this.state == 2 && this.repeatCount >= 5) && this.endRunningStage()) {
            if (this.state == 3) {
                this.afterBenchmark();
                return false;
            }
            this.beginRunningStage();
        }
        this.iterationsRemaining = this.iterationsPerRepeat;
        this.metrics.captureStart();
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean keepRunningInline() {
        boolean $i$f$keepRunningInline = false;
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    public final boolean keepRunning() {
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    private final void check(boolean value, Function0<String> lazyMessage) {
        boolean $i$f$check = false;
        if (!value) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            throw new IllegalStateException((String)lazyMessage.invoke());
        }
    }

    @PublishedApi
    public final boolean keepRunningInternal() {
        switch (this.state) {
            case -1: {
                this.beforeBenchmark();
                this.beginRunningStage();
                return true;
            }
            case 0: 
            case 1: 
            case 2: {
                int n = this.iterationsRemaining;
                this.iterationsRemaining = n + -1;
                if (this.iterationsRemaining <= 0) {
                    this.throwIfPaused();
                    return this.startNextRepeat();
                }
                return true;
            }
        }
        throw new IllegalStateException("The benchmark is in an invalid state.");
    }

    private final void beforeBenchmark() {
        block6: {
            block5: {
                Errors.INSTANCE.throwIfError();
                if (!firstBenchmark && Arguments.INSTANCE.getStartupMode$benchmark_common_release()) {
                    throw new AssertionError((Object)"Error - multiple benchmarks in startup mode. Only one benchmark may be run per 'am instrument' call, to ensure result isolation.");
                }
                firstBenchmark = false;
                this.thermalThrottleSleepSeconds = 0L;
                if (!this.simplifiedTimingOnlyMode) {
                    ThrottleDetector.INSTANCE.computeThrottleBaselineIfNeeded();
                    ThreadPriority.INSTANCE.bumpCurrentThreadPriority();
                }
                this.totalRunTimeStartNs = System.nanoTime();
                this.state = 0;
                if (Arguments.INSTANCE.getDryRunMode() || Arguments.INSTANCE.getStartupMode$benchmark_common_release()) break block5;
                Integer n = this.warmupCount;
                if (n == null || n != 0) break block6;
            }
            this.state = 1;
        }
    }

    private final void afterBenchmark() {
        this.totalRunTimeNs = System.nanoTime() - this.totalRunTimeStartNs;
        if (!this.simplifiedTimingOnlyMode) {
            ThreadPriority.INSTANCE.resetBumpedThread();
        }
        this.warmupManager.logInfo();
        if (this.throttleRemainingRetries == 0) {
            ThrottleDetector.INSTANCE.resetThrottleBaseline();
        }
    }

    private final int computeMaxIterations() {
        Integer n = OVERRIDE_ITERATIONS;
        return n != null ? n : RangesKt.coerceIn((int)((int)((float)this.repeatDurationTargetNs / this.warmupManager.getEstimatedIterationTimeNs())), (int)1, (int)1000000);
    }

    private final void throwIfPaused() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string = "Benchmark loop finished in paused state. Call BenchmarkState.resumeTiming() before BenchmarkState.keepRunning().";
            throw new IllegalStateException(string);
        }
    }

    private final BenchmarkResult getReport(String testName, String className) {
        return new BenchmarkResult(className, testName, this.totalRunTimeNs, this.metricResults, this.iterationsPerRepeat, this.thermalThrottleSleepSeconds, this.warmupRepeats);
    }

    @ExperimentalBenchmarkStateApi
    @NotNull
    public final List<Double> getMeasurementTimeNs() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.metricResults;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((MetricResult)element$iv2).getData();
    }

    @NotNull
    public final BenchmarkResult getReport$benchmark_common_release() {
        this.checkState();
        Unit $this$getReport_u24lambda_u2d10 = Unit.INSTANCE;
        boolean bl = false;
        return this.getReport("", "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bundle getFullStatusReport$benchmark_common_release(@NotNull String key, boolean reportMetrics, @Nullable String tracePath) {
        String string;
        Object v0;
        Object $this$firstOrNull$iv;
        double nanos;
        MetricResult it;
        Bundle status;
        Object object;
        Object object2;
        CharSequence charSequence;
        block6: {
            Object object3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable iterable = this.metricResults;
            charSequence = new StringBuilder().append(key);
            object2 = TAG;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                object3 = (MetricResult)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it2.getSummary$benchmark_common_release());
            }
            object = (List)destination$iv$iv;
            Log.i((String)object2, (String)charSequence.append(object).append("count=").append(this.iterationsPerRepeat).toString());
            status = new Bundle();
            if (reportMetrics) {
                Iterable $this$forEach$iv = this.metricResults;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (MetricResult)element$iv;
                    boolean bl = false;
                    it.putInBundle(status, Errors.INSTANCE.getPREFIX());
                }
            }
            nanos = this.getMinTimeNanos();
            $this$firstOrNull$iv = this.metricResults;
            boolean $i$f$firstOrNull = false;
            object3 = $this$firstOrNull$iv.iterator();
            while (object3.hasNext()) {
                Object element$iv = object3.next();
                MetricResult it3 = (MetricResult)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it3.getName(), (Object)"allocationCount")) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        MetricResult metricResult = v0;
        Double allocations = metricResult != null ? Double.valueOf(metricResult.getMedian()) : null;
        Object object4 = new InstrumentationResultScope(status);
        CharSequence charSequence2 = InstrumentationResults.INSTANCE.ideSummaryLineWrapped$benchmark_common_release(key, nanos, allocations, null, null);
        Object object5 = InstrumentationResults.INSTANCE;
        String string2 = key;
        double d = nanos;
        Double d2 = allocations;
        String string3 = tracePath;
        if (string3 != null) {
            $this$firstOrNull$iv = string3;
            Double d3 = d2;
            double d4 = d;
            String string4 = string2;
            object = object5;
            charSequence = charSequence2;
            object2 = object4;
            boolean bl = false;
            String string5 = Outputs.INSTANCE.relativePathFor((String)((Object)it));
            object4 = object2;
            charSequence2 = charSequence;
            object5 = object;
            string2 = string4;
            d = d4;
            d2 = d3;
            string = string5;
        } else {
            string = null;
        }
        ((InstrumentationResultScope)object4).ideSummaryRecord((String)charSequence2, ((InstrumentationResults)object5).ideSummaryLineWrapped$benchmark_common_release(string2, d, d2, string, this.profilerResult));
        return status;
    }

    private final boolean sleepIfThermalThrottled(long sleepSeconds) {
        boolean bl;
        if (ThrottleDetector.INSTANCE.isDeviceThermalThrottled()) {
            Log.d((String)TAG, (String)("THERMAL THROTTLE DETECTED, SLEEPING FOR " + sleepSeconds + " SECONDS"));
            long startTimeNs = System.nanoTime();
            Thread.sleep(TimeUnit.SECONDS.toMillis(sleepSeconds));
            long sleepTimeNs = System.nanoTime() - startTimeNs;
            this.thermalThrottleSleepSeconds += TimeUnit.NANOSECONDS.toSeconds(sleepTimeNs);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void report(@NotNull String fullClassName, @NotNull String simpleClassName, @NotNull String methodName, @Nullable String tracePath) {
        Intrinsics.checkNotNullParameter((Object)fullClassName, (String)"fullClassName");
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        if (this.state == -1) {
            return;
        }
        this.checkState();
        String fullTestName = Errors.INSTANCE.getPREFIX() + simpleClassName + '.' + methodName;
        Bundle bundle = this.getFullStatusReport$benchmark_common_release(fullTestName, !Arguments.INSTANCE.getDryRunMode(), tracePath);
        InstrumentationResults.INSTANCE.reportBundle$benchmark_common_release(bundle);
        ResultWriter.INSTANCE.appendReport(this.getReport(Errors.INSTANCE.getPREFIX() + methodName, fullClassName));
    }

    @JvmStatic
    @Companion.ExperimentalExternalReport
    public static final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
        Companion.reportData(className, testName, totalRunTimeNs, dataNs, warmupIterations, thermalThrottleSleepSeconds, repeatIterations);
    }

    /*
     * Unable to fully structure code
     */
    static {
        if (Arguments.INSTANCE.getDryRunMode() || Arguments.INSTANCE.getStartupMode$benchmark_common_release()) ** GOTO lbl-1000
        v0 = Arguments.INSTANCE.getProfiler$benchmark_common_release();
        v1 = v0 != null ? v0.getRequiresSingleMeasurementIteration() : false;
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = 1;
        } else {
            v2 = Arguments.INSTANCE.getIterations$benchmark_common_release() != null ? Arguments.INSTANCE.getIterations$benchmark_common_release() : null;
        }
        BenchmarkState.OVERRIDE_ITERATIONS = v2;
        BenchmarkState.firstBenchmark = true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\b\b\u0001\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u00042\b\b\u0001\u0010\u001d\u001a\u00020\u00112\b\b\u0001\u0010\u001e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/benchmark/BenchmarkState$Companion;", "", "()V", "FINISHED", "", "MAX_TEST_ITERATIONS", "MIN_TEST_ITERATIONS", "NOT_STARTED", "OVERRIDE_ITERATIONS", "Ljava/lang/Integer;", "REPEAT_COUNT_ALLOCATION", "RUNNING_ALLOCATION_STAGE", "RUNNING_TIME_STAGE", "RUNNING_WARMUP_STAGE", "TAG", "", "THROTTLE_BACKOFF_S", "", "THROTTLE_MAX_RETRIES", "firstBenchmark", "", "reportData", "", "className", "testName", "totalRunTimeNs", "dataNs", "", "warmupIterations", "thermalThrottleSleepSeconds", "repeatIterations", "ExperimentalExternalReport", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @ExperimentalExternalReport
        public final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter(dataNs, (String)"dataNs");
            MetricsContainer metricsContainer = new MetricsContainer(null, dataNs.size(), 1, null);
            metricsContainer.getData$benchmark_common_release()[ArraysKt.getLastIndex((Object[])((Object[])metricsContainer.getData$benchmark_common_release()))] = CollectionsKt.toLongArray((Collection)dataNs);
            BenchmarkResult report = new BenchmarkResult(className, testName, totalRunTimeNs, metricsContainer.captureFinished(1), repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
            String fullTestName = Errors.INSTANCE.getPREFIX() + (((CharSequence)className).length() > 0 ? className + '.' + testName : testName);
            InstrumentationResults.INSTANCE.instrumentationReport((Function1<? super InstrumentationResultScope, Unit>)((Function1)new Function1<InstrumentationResultScope, Unit>(fullTestName, report){
                final /* synthetic */ String $fullTestName;
                final /* synthetic */ BenchmarkResult $report;
                {
                    this.$fullTestName = $fullTestName;
                    this.$report = $report;
                    super(1);
                }

                public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    InstrumentationResultScope.ideSummaryRecord$default($this$instrumentationReport, InstrumentationResults.INSTANCE.ideSummaryLineWrapped$benchmark_common_release(this.$fullTestName, this.$report.getMetricResult("timeNs").getMin(), null, null, null), null, 2, null);
                }
            }));
            ResultWriter.INSTANCE.appendReport(report);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.BINARY)
        @kotlin.annotation.Target(allowedTargets={AnnotationTarget.FUNCTION})
        @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
        @Target(value={ElementType.METHOD})
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/benchmark/BenchmarkState$Companion$ExperimentalExternalReport;", "", "benchmark-common_release"})
        @RequiresOptIn
        public static @interface ExperimentalExternalReport {
        }
    }
}

