/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import androidx.benchmark.MetricCapture;
import androidx.benchmark.MetricResult;
import androidx.benchmark.MetricsContainer;
import androidx.benchmark.TimeCapture;
import androidx.benchmark.UserspaceTracing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/MetricsContainer;", "", "metrics", "", "Landroidx/benchmark/MetricCapture;", "REPEAT_COUNT", "", "([Landroidx/benchmark/MetricCapture;I)V", "data", "", "getData$benchmark_common_release", "()[[J", "[[J", "[Landroidx/benchmark/MetricCapture;", "runNum", "traceTiming", "captureFinished", "", "Landroidx/benchmark/MetricResult;", "maxIterations", "captureInit", "", "capturePaused", "captureResumed", "captureStart", "captureStop", "benchmark-common_release"})
public final class MetricsContainer {
    @NotNull
    private final MetricCapture[] metrics;
    private final int REPEAT_COUNT;
    @NotNull
    private final long[][] data;
    @NotNull
    private final long[] traceTiming;
    private int runNum;

    public MetricsContainer(@NotNull MetricCapture[] metrics, int REPEAT_COUNT) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.metrics = metrics;
        this.REPEAT_COUNT = REPEAT_COUNT;
        int n = 0;
        int n2 = this.metrics.length;
        long[][] lArrayArray = new long[n2][];
        MetricsContainer metricsContainer = this;
        while (n < n2) {
            int n3 = n++;
            lArrayArray[n3] = new long[this.REPEAT_COUNT];
        }
        metricsContainer.data = lArrayArray;
        this.traceTiming = new long[this.REPEAT_COUNT * 2];
    }

    public /* synthetic */ MetricsContainer(MetricCapture[] metricCaptureArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            MetricCapture[] metricCaptureArray2 = new MetricCapture[]{new TimeCapture()};
            metricCaptureArray = metricCaptureArray2;
        }
        this(metricCaptureArray, n);
    }

    @NotNull
    public final long[][] getData$benchmark_common_release() {
        return this.data;
    }

    public final void captureInit() {
        this.runNum = 0;
    }

    public final void captureStart() {
        long timeNs;
        this.traceTiming[this.runNum * 2] = timeNs = System.nanoTime();
        int i = 0;
        int n = ArraysKt.getLastIndex((Object[])this.metrics);
        if (i <= n) {
            while (true) {
                this.metrics[i].captureStart(timeNs);
                if (i == n) break;
                ++i;
            }
        }
    }

    public final void captureStop() {
        long timeNs = System.nanoTime();
        for (int i = ArraysKt.getLastIndex((Object[])this.metrics); -1 < i; --i) {
            this.data[i][this.runNum] = this.metrics[i].captureStop(timeNs);
        }
        this.traceTiming[this.runNum * 2 + 1] = timeNs;
        ++this.runNum;
    }

    public final void capturePaused() {
        for (int i = ArraysKt.getLastIndex((Object[])this.metrics); -1 < i; --i) {
            this.metrics[ArraysKt.getLastIndex((Object[])this.metrics) - i].capturePaused();
        }
    }

    public final void captureResumed() {
        int i = 0;
        int n = ArraysKt.getLastIndex((Object[])this.metrics);
        if (i <= n) {
            while (true) {
                this.metrics[i].captureResumed();
                if (i == n) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MetricResult> captureFinished(int maxIterations) {
        void $this$mapIndexedTo$iv$iv;
        int i = 0;
        int n = ArraysKt.getLastIndex((long[])this.traceTiming);
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                UserspaceTracing.INSTANCE.beginSection("measurement " + i / 2, this.traceTiming[i]);
                UserspaceTracing.INSTANCE.endSection(this.traceTiming[i + 1]);
                if (i == n2) break;
                i += 2;
            }
        }
        Object[] $this$mapIndexed$iv = (Object[])this.data;
        boolean $i$f$mapIndexed = false;
        Object[] objectArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$forEachIndexed$iv;
            int n3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void longMeasurementArray;
            void index;
            int n4 = index$iv$iv++;
            long[] lArray = (long[])item$iv$iv;
            int n5 = n4;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MetricCapture metric = this.metrics[index];
            void var15_17 = longMeasurementArray;
            boolean $i$f$map = false;
            void var17_20 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n6 = ((void)$this$mapTo$iv$iv).length;
            for (n3 = 0; n3 < n6; ++n3) {
                void it;
                void item$iv$iv2;
                void var24_28 = item$iv$iv2 = $this$mapTo$iv$iv[n3];
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add((double)it / (double)maxIterations);
            }
            List scaledMeasurements = (List)destination$iv$iv2;
            $this$map$iv = CollectionsKt.chunked((Iterable)scaledMeasurements, (int)10);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void chunk;
                if ((n3 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv;
                int chunkNum = n3;
                boolean bl3 = false;
                StringBuilder stringBuilder = new StringBuilder().append(metric.getName());
                String string = "[%2d:%2d]: %s";
                Object[] objectArray2 = new Object[]{chunkNum * 10, (chunkNum + 1) * 10, CollectionsKt.joinToString$default((Iterable)((Iterable)chunk), (CharSequence)" ", null, null, (int)0, null, (Function1)captureFinished.1.1.1.INSTANCE, (int)30, null)};
                String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                Log.d((String)"Benchmark", (String)stringBuilder.append(string2).toString());
            }
            collection.add(new MetricResult(metric.getName(), scaledMeasurements, null, 4, null));
        }
        return (List)destination$iv$iv;
    }
}

