/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.ShellImpl;
import androidx.benchmark.ShellScript;
import androidx.benchmark.UserspaceTracing;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u000289B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0006\u0010\u000b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0007J\u001c\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001d\u001a\u00020\u0006H\u0007J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\"\u001a\u00020\u0006H\u0007J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0006H\u0007J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0006H\u0007J\b\u0010&\u001a\u00020\u0015H\u0007J\u0018\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0007J\u0010\u0010*\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0006H\u0007J\"\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00060-0\u001f2\u0006\u0010.\u001a\u00020\u0006H\u0003J\u0018\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J1\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020 2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020605\"\u000206H\u0007\u00a2\u0006\u0002\u00107J \u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0006H\u0007\u00a8\u0006:"}, d2={"Landroidx/benchmark/Shell;", "", "()V", "catProcFileLong", "", "path", "", "(Ljava/lang/String;)Ljava/lang/Long;", "chmodExecutable", "", "absoluteFilePath", "connectUiAutomation", "createRunnableExecutable", "name", "inputStream", "Ljava/io/InputStream;", "createShellScript", "Landroidx/benchmark/ShellScript;", "script", "stdin", "includeStderr", "", "executeCommand", "command", "executeScript", "executeScriptWithStderr", "Landroidx/benchmark/Shell$Output;", "fullProcessNameMatchesProcess", "fullProcessName", "processName", "getPidsForProcess", "", "", "getRunningProcessesForPackage", "packageName", "isPackageAlive", "isProcessAlive", "pid", "isSessionRooted", "moveToTmpAndMakeExecutable", "src", "dst", "optionalCommand", "pathExists", "pgrepLF", "Lkotlin/Pair;", "pattern", "psLineContainsProcess", "psOutputLine", "terminateProcessesAndWait", "waitPollPeriodMs", "waitPollMaxCount", "processes", "", "Landroidx/benchmark/Shell$ProcessPid;", "(JI[Landroidx/benchmark/Shell$ProcessPid;)V", "Output", "ProcessPid", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Shell {
    @NotNull
    public static final Shell INSTANCE = new Shell();

    private Shell() {
    }

    private final boolean psLineContainsProcess(String psOutputLine, String processName) {
        return StringsKt.endsWith$default((String)psOutputLine, (String)(' ' + processName), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)psOutputLine, (String)('/' + processName), (boolean)false, (int)2, null);
    }

    private final boolean fullProcessNameMatchesProcess(String fullProcessName, String processName) {
        return Intrinsics.areEqual((Object)fullProcessName, (Object)processName) || StringsKt.endsWith$default((String)fullProcessName, (String)('/' + processName), (boolean)false, (int)2, null);
    }

    public final void connectUiAutomation() {
        if (Build.VERSION.SDK_INT >= 21) {
        }
    }

    @Nullable
    public final String optionalCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return Build.VERSION.SDK_INT >= 21 ? this.executeCommand(command) : (String)null;
    }

    @RequiresApi(value=21)
    @NotNull
    public final String executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return ShellImpl.INSTANCE.executeCommand(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Long catProcFileLong(@NotNull String path) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = this.optionalCommand("cat " + path);
        if (string == null) return null;
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (string2 == null) return null;
        String $this$catProcFileLong_u24lambda_u2d0 = string2;
        boolean bl = false;
        try {
            l = Long.parseLong($this$catProcFileLong_u24lambda_u2d0);
        }
        catch (NumberFormatException exception) {
            l = null;
        }
        Long l2 = l;
        return l2;
    }

    @RequiresApi(value=21)
    public final void chmodExecutable(@NotNull String absoluteFilePath) {
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        if (Build.VERSION.SDK_INT >= 23) {
            ShellImpl.INSTANCE.executeCommand("chmod +x " + absoluteFilePath);
        } else {
            ShellImpl.INSTANCE.executeCommand("chmod 777 " + absoluteFilePath);
        }
    }

    @RequiresApi(value=21)
    public final void moveToTmpAndMakeExecutable(@NotNull String src, @NotNull String dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ShellImpl.INSTANCE.executeCommand("cp " + src + ' ' + dst);
        this.chmodExecutable(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=21)
    @NotNull
    public final String createRunnableExecutable(@NotNull String name, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        File externalDir = Outputs.INSTANCE.getDirUsableByAppAndShell();
        File writableExecutableFile = File.createTempFile("temporary_" + name, null, externalDir);
        String runnableExecutablePath = "/data/local/tmp/" + name;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)writableExecutableFile, (String)"writableExecutableFile");
            Closeable closeable = new FileOutputStream(writableExecutableFile);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = writableExecutableFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writableExecutableFile.absolutePath");
            this.moveToTmpAndMakeExecutable(string, runnableExecutablePath);
        }
        finally {
            writableExecutableFile.delete();
        }
        return runnableExecutablePath;
    }

    @RequiresApi(value=21)
    public final boolean isSessionRooted() {
        return ShellImpl.INSTANCE.isSessionRooted() || ShellImpl.INSTANCE.isSuAvailable();
    }

    @RequiresApi(value=21)
    @NotNull
    public final String executeScript(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return ShellImpl.INSTANCE.createShellScript(script, stdin, false).start(new String[0]).getOutputAndClose().getStdout();
    }

    public static /* synthetic */ String executeScript$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScript(string, string2);
    }

    @RequiresApi(value=21)
    @NotNull
    public final Output executeScriptWithStderr(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return ShellImpl.INSTANCE.createShellScript(script, stdin, true).start(new String[0]).getOutputAndClose();
    }

    public static /* synthetic */ Output executeScriptWithStderr$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScriptWithStderr(string, string2);
    }

    @RequiresApi(value=21)
    @NotNull
    public final ShellScript createShellScript(@NotNull String script, @Nullable String stdin, boolean includeStderr) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return ShellImpl.INSTANCE.createShellScript(script, stdin, includeStderr);
    }

    public static /* synthetic */ ShellScript createShellScript$default(Shell shell, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return shell.createShellScript(string, string2, bl);
    }

    @RequiresApi(value=21)
    public final boolean isPackageAlive(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return !((Collection)this.getPidsForProcess(packageName)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @NotNull
    public final List<Integer> getPidsForProcess(@NotNull String processName) {
        Iterable $this$filterTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$mapNotNullTo$iv$iv22;
            Iterable $this$mapNotNull$iv = this.pgrepLF(processName);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl2 = false;
                int pid = ((Number)pair.component1()).intValue();
                String fullProcessName = (String)pair.component2();
                if ((INSTANCE.fullProcessNameMatchesProcess(fullProcessName, processName) ? Integer.valueOf(pid) : (Integer)null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        CharSequence $this$mapNotNull$iv = Shell.executeScript$default(this, "ps | grep " + processName, null, 2, null);
        Regex $i$f$mapNotNull = new Regex("\r?\n");
        int $this$mapNotNullTo$iv$iv22 = 0;
        Iterable $this$map$iv = $i$f$mapNotNull.split($this$mapNotNull$iv, $this$mapNotNullTo$iv$iv22);
        boolean $i$f$map = false;
        Iterable $this$mapNotNullTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            Regex regex = new Regex("\\s+");
            int n = 0;
            collection.add(Integer.parseInt((String)regex.split(charSequence, n).get(1)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=23)
    private final List<Pair<Integer, String>> pgrepLF(String pattern) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        CharSequence charSequence = this.executeCommand("pgrep -l -f " + pattern);
        Regex regex = new Regex("\r?\n");
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            List list = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String pidString = (String)list.get(0);
            String process = (String)list.get(1);
            collection.add(new Pair((Object)Integer.parseInt(pidString), (Object)process));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @NotNull
    public final List<String> getRunningProcessesForPackage(@NotNull String packageName) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!(!StringsKt.contains$default((CharSequence)packageName, (CharSequence)":", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-Shell$getRunningProcessesForPackage$22 = false;
            String $i$a$-require-Shell$getRunningProcessesForPackage$22 = "Package " + packageName + " must not contain ':'";
            throw new IllegalArgumentException($i$a$-require-Shell$getRunningProcessesForPackage$22.toString());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$mapNotNullTo$iv$iv22;
            Iterable $this$mapNotNull$iv = this.pgrepLF(packageName);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl2 = false;
                String process = (String)pair.component2();
                if ((Intrinsics.areEqual((Object)process, (Object)packageName) || StringsKt.startsWith$default((String)process, (String)(packageName + ':'), (boolean)false, (int)2, null) ? process : (String)null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        CharSequence $this$mapNotNull$iv = Shell.executeScript$default(this, "ps | grep " + packageName, null, 2, null);
        Regex $i$f$mapNotNull = new Regex("\r?\n");
        int $this$mapNotNullTo$iv$iv22 = 0;
        Iterable $this$map$iv = $i$f$mapNotNull.split($this$mapNotNull$iv, $this$mapNotNullTo$iv$iv22);
        boolean $i$f$map = false;
        Iterable $this$mapNotNullTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringAfterLast$default((String)it, (String)" ", null, (int)2, null));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)packageName) || StringsKt.startsWith$default((String)it, (String)(packageName + ':'), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @RequiresApi(value=21)
    public final boolean isProcessAlive(int pid, @NotNull String processName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            CharSequence charSequence = this.executeCommand("ps " + pid);
            Regex regex = new Regex("\r?\n");
            int n = 0;
            Iterable $this$any$iv = regex.split(charSequence, n);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    public final void terminateProcessesAndWait(long waitPollPeriodMs, int waitPollMaxCount, @NotNull String processName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Iterable $this$map$iv = this.getPidsForProcess(processName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pid;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProcessPid(processName, (int)pid));
        }
        List processes = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = processes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProcessPid[] processPidArray = thisCollection$iv.toArray(new ProcessPid[0]);
        Intrinsics.checkNotNull((Object)processPidArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        ProcessPid[] processPidArray2 = processPidArray;
        this.terminateProcessesAndWait(waitPollPeriodMs, waitPollMaxCount, Arrays.copyOf(processPidArray2, processPidArray2.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    public final void terminateProcessesAndWait(long waitPollPeriodMs, int waitPollMaxCount, ProcessPid ... processes) {
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        ProcessPid[] $this$forEach$iv = processes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ProcessPid processPid;
            ProcessPid it = processPid = $this$forEach$iv[i];
            boolean bl = false;
            String stopOutput = INSTANCE.executeCommand("kill -TERM " + it.getPid());
            Log.d((String)"Benchmark", (String)("kill -TERM command output - " + stopOutput));
        }
        Ref.ObjectRef runningProcesses = new Ref.ObjectRef();
        runningProcesses.element = ArraysKt.toList((Object[])processes);
        for (int i = 0; i < waitPollMaxCount; ++i) {
            void $this$filterTo$iv$iv;
            int it = i;
            boolean bl = false;
            Iterable iterable = (Iterable)runningProcesses.element;
            Ref.ObjectRef objectRef = runningProcesses;
            boolean $i$f$filter = false;
            Iterable stopOutput = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProcessPid it2 = (ProcessPid)element$iv$iv;
                boolean bl2 = false;
                if (!INSTANCE.isProcessAlive(it2.getPid(), it2.getProcessName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            objectRef.element = (List)destination$iv$iv;
            if (((List)runningProcesses.element).isEmpty()) {
                return;
            }
            String string = "wait for " + runningProcesses.element + " to die";
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, string, 0L, 2, null);
            try {
                boolean bl3 = false;
                SystemClock.sleep((long)waitPollPeriodMs);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            Log.d((String)"Benchmark", (String)("Waiting " + waitPollPeriodMs + " ms for " + runningProcesses.element + " to die"));
        }
        throw new IllegalStateException("Failed to stop " + runningProcesses.element);
    }

    @RequiresApi(value=21)
    public final boolean pathExists(@NotNull String absoluteFilePath) {
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)this.executeCommand("ls " + absoluteFilePath))).toString(), (Object)absoluteFilePath);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/Shell$Output;", "", "stdout", "", "stderr", "(Ljava/lang/String;Ljava/lang/String;)V", "getStderr", "()Ljava/lang/String;", "getStdout", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "benchmark-common_release"})
    public static final class Output {
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        public Output(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        @NotNull
        public final String component1() {
            return this.stdout;
        }

        @NotNull
        public final String component2() {
            return this.stderr;
        }

        @NotNull
        public final Output copy(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            return new Output(stdout, stderr);
        }

        public static /* synthetic */ Output copy$default(Output output, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = output.stdout;
            }
            if ((n & 2) != 0) {
                string2 = output.stderr;
            }
            return output.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Output(stdout=" + this.stdout + ", stderr=" + this.stderr + ')';
        }

        public int hashCode() {
            int result = this.stdout.hashCode();
            result = result * 31 + this.stderr.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.stdout, (Object)output.stdout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stderr, (Object)output.stderr);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u000fJ\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/benchmark/Shell$ProcessPid;", "", "processName", "", "pid", "", "(Ljava/lang/String;I)V", "getPid", "()I", "getProcessName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "isAlive", "toString", "benchmark-common_release"})
    @RequiresApi(value=21)
    public static final class ProcessPid {
        @NotNull
        private final String processName;
        private final int pid;

        public ProcessPid(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            this.processName = processName;
            this.pid = pid;
        }

        @NotNull
        public final String getProcessName() {
            return this.processName;
        }

        public final int getPid() {
            return this.pid;
        }

        public final boolean isAlive() {
            return INSTANCE.isProcessAlive(this.pid, this.processName);
        }

        @NotNull
        public final String component1() {
            return this.processName;
        }

        public final int component2() {
            return this.pid;
        }

        @NotNull
        public final ProcessPid copy(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            return new ProcessPid(processName, pid);
        }

        public static /* synthetic */ ProcessPid copy$default(ProcessPid processPid, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = processPid.processName;
            }
            if ((n2 & 2) != 0) {
                n = processPid.pid;
            }
            return processPid.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ProcessPid(processName=" + this.processName + ", pid=" + this.pid + ')';
        }

        public int hashCode() {
            int result = this.processName.hashCode();
            result = result * 31 + Integer.hashCode(this.pid);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessPid)) {
                return false;
            }
            ProcessPid processPid = (ProcessPid)other;
            if (!Intrinsics.areEqual((Object)this.processName, (Object)processPid.processName)) {
                return false;
            }
            return this.pid == processPid.pid;
        }
    }
}

