/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.UiAutomation;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.ShellKt;
import androidx.benchmark.ShellScript;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.Trace;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/benchmark/ShellImpl;", "", "()V", "isSessionRooted", "", "()Z", "setSessionRooted", "(Z)V", "isSuAvailable", "setSuAvailable", "uiAutomation", "Landroid/app/UiAutomation;", "kotlin.jvm.PlatformType", "createShellScript", "Landroidx/benchmark/ShellScript;", "script", "", "stdin", "includeStderr", "executeCommand", "cmd", "executeCommandNonBlocking", "Landroid/os/ParcelFileDescriptor;", "benchmark-common_release"})
@RequiresApi(value=21)
final class ShellImpl {
    @NotNull
    public static final ShellImpl INSTANCE = new ShellImpl();
    private static final UiAutomation uiAutomation;
    private static boolean isSessionRooted;
    private static boolean isSuAvailable;

    private ShellImpl() {
    }

    public final boolean isSessionRooted() {
        return isSessionRooted;
    }

    public final void setSessionRooted(boolean bl) {
        isSessionRooted = bl;
    }

    public final boolean isSuAvailable() {
        return isSuAvailable;
    }

    public final void setSuAvailable(boolean bl) {
        isSuAvailable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String executeCommand(@NotNull String cmd) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String label$iv = StringsKt.take((String)("executeCommand " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            string = ShellKt.fullyReadInputStream(INSTANCE.executeCommandNonBlocking(cmd));
        }
        finally {
            Trace.endSection();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ParcelFileDescriptor executeCommandNonBlocking(@NotNull String cmd) {
        ParcelFileDescriptor parcelFileDescriptor;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String label$iv = StringsKt.take((String)("executeCommandNonBlocking " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            ParcelFileDescriptor parcelFileDescriptor2 = ShellImpl.uiAutomation.executeShellCommand(!INSTANCE.isSessionRooted() && INSTANCE.isSuAvailable() ? "su root " + cmd : cmd);
            parcelFileDescriptor = parcelFileDescriptor2;
        }
        finally {
            Trace.endSection();
        }
        Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"trace(\"executeCommandNon\u2026}\n            )\n        }");
        return parcelFileDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ShellScript createShellScript(@NotNull String script, @Nullable String stdin, boolean includeStderr) {
        ShellScript shellScript;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String label$iv = StringsKt.take((String)("createShellScript " + script), (int)127);
        boolean $i$f$trace = false;
        try {
            ShellScript shellScript2;
            File file;
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            File externalDir = Outputs.INSTANCE.getDirUsableByAppAndShell();
            File writableScriptFile = File.createTempFile("temporaryScript", ".sh", externalDir);
            String runnableScriptPath = "/data/local/tmp/" + writableScriptFile.getName();
            String string = stdin;
            if (string != null) {
                String $this$createShellScript_u24lambda_u2d4_u24lambda_u2d3 = string;
                boolean bl2 = false;
                file = File.createTempFile("temporaryStdin", null, externalDir);
            } else {
                file = null;
            }
            File stdinFile = file;
            String stderrPath = includeStderr ? runnableScriptPath + "_stderr" : (String)null;
            ShellScript shellScript3 = null;
            try {
                String scriptText = script;
                if (stdinFile != null) {
                    FilesKt.writeText$default((File)stdinFile, (String)stdin, null, (int)2, null);
                    scriptText = "cat " + stdinFile.getAbsolutePath() + " | " + scriptText;
                }
                if (stderrPath != null) {
                    scriptText = scriptText + " 2> " + stderrPath;
                }
                Intrinsics.checkNotNullExpressionValue((Object)writableScriptFile, (String)"writableScriptFile");
                FilesKt.writeText$default((File)writableScriptFile, (String)scriptText, null, (int)2, null);
                INSTANCE.executeCommand("cp " + writableScriptFile.getAbsolutePath() + ' ' + runnableScriptPath);
                Shell.INSTANCE.chmodExecutable(runnableScriptPath);
                shellScript2 = shellScript3 = new ShellScript(stdinFile, writableScriptFile, stderrPath, runnableScriptPath);
            }
            catch (Exception e) {
                ShellScript shellScript4 = shellScript3;
                if (shellScript4 != null) {
                    shellScript4.cleanUp();
                }
                throw new Exception("Can't create shell script", e);
            }
            shellScript = shellScript2;
        }
        finally {
            Trace.endSection();
        }
        return shellScript;
    }

    static {
        if (!(!Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread()))) {
            boolean bl = false;
            String string = "ShellImpl must not be initialized on the UI thread - UiAutomation must not be connected on the main thread!";
            throw new IllegalArgumentException(string.toString());
        }
        uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        isSessionRooted = StringsKt.contains$default((CharSequence)INSTANCE.executeCommand("id"), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
        isSuAvailable = StringsKt.contains$default((CharSequence)INSTANCE.createShellScript("su root id", null, false).start(new String[0]).getOutputAndClose().getStdout(), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
    }
}

