/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Shell;
import androidx.benchmark.ShellKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016J\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/StartedShellScript;", "Ljava/io/Closeable;", "stdoutDescriptor", "Landroid/os/ParcelFileDescriptor;", "stderrDescriptorFn", "Lkotlin/Function0;", "", "cleanUpBlock", "", "(Landroid/os/ParcelFileDescriptor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "close", "getOutputAndClose", "Landroidx/benchmark/Shell$Output;", "stdOutLineSequence", "Lkotlin/sequences/Sequence;", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public final class StartedShellScript
implements Closeable {
    @NotNull
    private final ParcelFileDescriptor stdoutDescriptor;
    @Nullable
    private final Function0<String> stderrDescriptorFn;
    @NotNull
    private final Function0<Unit> cleanUpBlock;

    public StartedShellScript(@NotNull ParcelFileDescriptor stdoutDescriptor, @Nullable Function0<String> stderrDescriptorFn2, @NotNull Function0<Unit> cleanUpBlock) {
        Intrinsics.checkNotNullParameter((Object)stdoutDescriptor, (String)"stdoutDescriptor");
        Intrinsics.checkNotNullParameter(cleanUpBlock, (String)"cleanUpBlock");
        this.stdoutDescriptor = stdoutDescriptor;
        this.stderrDescriptorFn = stderrDescriptorFn2;
        this.cleanUpBlock = cleanUpBlock;
    }

    @NotNull
    public final Sequence<String> stdOutLineSequence() {
        InputStream inputStream = (InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.stdoutDescriptor);
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        return TextStreamsKt.lineSequence((BufferedReader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
    }

    @Override
    public void close() {
        this.cleanUpBlock.invoke();
    }

    @NotNull
    public final Shell.Output getOutputAndClose() {
        String string = ShellKt.fullyReadInputStream(this.stdoutDescriptor);
        Object object = this.stderrDescriptorFn;
        if (object == null || (object = (String)object.invoke()) == null) {
            object = "";
        }
        Shell.Output output = new Shell.Output(string, (String)object);
        this.close();
        return output;
    }
}

