/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.perfetto.PerfettoCapture;
import androidx.benchmark.perfetto.PerfettoConfigKt;
import androidx.benchmark.perfetto.PerfettoHelper;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.perfetto.PerfettoHandshake;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0003J\u0014\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/perfetto/PerfettoCapture;", "", "unbundled", "", "(Z)V", "helper", "Landroidx/benchmark/perfetto/PerfettoHelper;", "enableAndroidxTracingPerfetto", "", "targetPackage", "provideBinariesIfMissing", "executeShellCommand", "", "command", "expectedResponse", "Lkotlin/text/Regex;", "isRunning", "start", "packages", "", "stop", "destinationPath", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public final class PerfettoCapture {
    @NotNull
    private final PerfettoHelper helper;

    public PerfettoCapture(boolean unbundled) {
        this.helper = new PerfettoHelper(unbundled);
    }

    public /* synthetic */ PerfettoCapture(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int n2 = Build.VERSION.SDK_INT;
            bl = 21 <= n2 ? n2 < 30 : false;
        }
        this(bl);
    }

    public final boolean isRunning() {
        return this.helper.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull List<String> packages) {
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        String label$iv = "start perfetto";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            File configProtoFile = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), "trace_config.pb");
            try {
                String label$iv2 = "write config";
                boolean $i$f$userspaceTrace2 = false;
                UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv2, 0L, 2, null);
                try {
                    boolean bl2 = false;
                    List atraceApps = Build.VERSION.SDK_INT <= 28 || packages.isEmpty() ? packages : CollectionsKt.listOf((Object)"*");
                    FilesKt.writeBytes((File)configProtoFile, (byte[])PerfettoConfigKt.validateAndEncode(PerfettoConfigKt.perfettoConfig(atraceApps)));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
                }
                label$iv2 = "start perfetto process";
                $i$f$userspaceTrace2 = false;
                UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv2, 0L, 2, null);
                try {
                    boolean bl3 = false;
                    String string = configProtoFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configProtoFile.absolutePath");
                    this.helper.startCollecting(string, false);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
                }
            }
            finally {
                configProtoFile.delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull String destinationPath) {
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        String label$iv = "stop perfetto";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            this.helper.stopCollecting(destinationPath);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
        }
    }

    @RequiresApi(value=30)
    @Nullable
    public final String enableAndroidxTracingPerfetto(@NotNull String targetPackage, boolean provideBinariesIfMissing) {
        String string;
        PerfettoHandshake.EnableTracingResponse enableTracingResponse;
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        if (!PerfettoHelper.Companion.isAbiSupported()) {
            StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
            throw new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])Build.SUPPORTED_ABIS, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
        }
        PerfettoHandshake handshake2 = new PerfettoHandshake(targetPackage, (Function1)enableAndroidxTracingPerfetto.handshake.1.INSTANCE, (Function1)new Function1<String, String>((Object)Shell.INSTANCE){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Shell)this.receiver).executeCommand(p0);
            }
        });
        PerfettoHandshake.EnableTracingResponse it = handshake2.enableTracing(null);
        boolean bl = false;
        if (it.getExitCode() == 11 && provideBinariesIfMissing) {
            String string2 = InstrumentationRegistry.getInstrumentation().getContext().getApplicationInfo().publicSourceDir;
            Intrinsics.checkNotNull((Object)string2);
            File baseApk = new File(string2);
            PerfettoHandshake.ExternalLibraryProvider libraryProvider2 = new PerfettoHandshake.ExternalLibraryProvider(baseApk, Outputs.INSTANCE.getDirUsableByAppAndShell(), (Function2)new Function2<File, File, Unit>(this){
                final /* synthetic */ PerfettoCapture this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull File tmpFile, @NotNull File dstFile) {
                    Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
                    Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
                    StringBuilder stringBuilder = new StringBuilder().append("mkdir -p ");
                    File file = dstFile.getParentFile();
                    Intrinsics.checkNotNull((Object)file);
                    PerfettoCapture.access$executeShellCommand(this.this$0, stringBuilder.append(file.getPath()).toString(), new Regex("^$"));
                    PerfettoCapture.access$executeShellCommand(this.this$0, "mv " + tmpFile.getPath() + ' ' + dstFile.getPath(), new Regex("^$"));
                }
            });
            enableTracingResponse = handshake2.enableTracing(libraryProvider2);
        } else {
            enableTracingResponse = it;
        }
        PerfettoHandshake.EnableTracingResponse response2 = enableTracingResponse;
        switch (response2.getExitCode()) {
            case 0: {
                string = "The broadcast to enable tracing was not received. This most likely means that the app does not contain the `androidx.tracing.tracing-perfetto` library as its dependency.";
                break;
            }
            case 1: {
                string = null;
                break;
            }
            case 2: {
                string = "Perfetto SDK already enabled.";
                break;
            }
            case 11: {
                string = "Perfetto SDK binary dependencies missing. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + ".\nTo fix, declare the following dependency in your *benchmark* project (i.e. not the app under benchmark): \nandroidTestImplementation(\"androidx.tracing:tracing-perfetto-binary:" + response2.getRequiredVersion() + "\")";
                break;
            }
            case 12: {
                string = "Perfetto SDK binary mismatch. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + '.';
                break;
            }
            case 13: {
                string = "Perfetto SDK binary verification failed. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + ". If working with an unreleased snapshot, ensure all modules are built against the same snapshot (e.g. clear caches and rebuild).";
                break;
            }
            case 99: {
                string = "Error: " + response2.getMessage() + '.';
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized exit code: " + response2.getExitCode() + '.');
            }
        }
        return string;
    }

    private final void executeShellCommand(String command, Regex expectedResponse) {
        String response2 = Shell.INSTANCE.executeCommand(command);
        if (!expectedResponse.matches((CharSequence)response2)) {
            throw new IllegalStateException("Command response not matching expected. Command: " + command + ". Expected response: " + expectedResponse.getPattern() + '.');
        }
    }

    public PerfettoCapture() {
        this(false, 1, null);
    }

    public static final /* synthetic */ void access$executeShellCommand(PerfettoCapture $this, String command, Regex expectedResponse) {
        $this.executeShellCommand(command, expectedResponse);
    }
}

