/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.CheckResult;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.ShellImpl;
import androidx.benchmark.ShellScript;
import androidx.benchmark.UserspaceTracing;
import androidx.tracing.Trace;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002?@B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0007J\u001c\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b!J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010\u001f\u001a\u00020\u0006H\u0007J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060#2\u0006\u0010%\u001a\u00020\u0006H\u0007J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0007J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0006H\u0007J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006H\u0007J\b\u0010+\u001a\u00020\u001dH\u0007J\u0018\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0006H\u0003J\u0010\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0006H\u0007J\"\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006030#2\u0006\u00104\u001a\u00020\u0006H\u0003J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00060#2\u0006\u0010%\u001a\u00020\u0006H\u0007J\u0018\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J1\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u00042\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020=0<\"\u00020=H\u0007\u00a2\u0006\u0002\u0010>J \u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006H\u0007\u00a8\u0006A"}, d2={"Landroidx/benchmark/Shell;", "", "()V", "amBroadcast", "", "broadcastArguments", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "catProcFileLong", "", "path", "(Ljava/lang/String;)Ljava/lang/Long;", "connectUiAutomation", "", "createRunnableExecutable", "name", "inputStream", "Ljava/io/InputStream;", "createShellScript", "Landroidx/benchmark/ShellScript;", "script", "stdin", "executeCommandCaptureStdoutOnly", "command", "executeScriptCaptureStdout", "executeScriptCaptureStdoutStderr", "Landroidx/benchmark/Shell$Output;", "executeScriptSilent", "fullProcessNameMatchesProcess", "", "fullProcessName", "processName", "getChecksum", "getChecksum$benchmark_common_release", "getPidsForProcess", "", "getRunningProcessesForPackage", "packageName", "getprop", "propertyName", "isPackageAlive", "isProcessAlive", "pid", "isSessionRooted", "moveToTmpAndMakeExecutable", "src", "dst", "optionalCommand", "pathExists", "absoluteFilePath", "pgrepLF", "Lkotlin/Pair;", "pattern", "pmPath", "psLineContainsProcess", "psOutputLine", "terminateProcessesAndWait", "waitPollPeriodMs", "waitPollMaxCount", "processes", "", "Landroidx/benchmark/Shell$ProcessPid;", "(JI[Landroidx/benchmark/Shell$ProcessPid;)V", "Output", "ProcessPid", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shell.kt\nandroidx/benchmark/Shell\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Trace.kt\nandroidx/tracing/TraceKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 UserspaceTracing.kt\nandroidx/benchmark/UserspaceTracingKt\n*L\n1#1,757:1\n1#2:758\n1#2:769\n1#2:787\n1#2:818\n1603#3,9:759\n1855#3:768\n1856#3:770\n1612#3:771\n1603#3,9:777\n1855#3:786\n1856#3:788\n1612#3:789\n1549#3:790\n1620#3,3:791\n766#3:794\n857#3,2:795\n1549#3:797\n1620#3,3:798\n766#3:801\n857#3,2:802\n1549#3:804\n1620#3,3:805\n1603#3,9:808\n1855#3:817\n1856#3:819\n1612#3:820\n1549#3:821\n1620#3,3:822\n766#3:825\n857#3,2:826\n1747#3,3:828\n1549#3:831\n1620#3,3:832\n766#3:839\n857#3,2:840\n27#4,5:772\n37#5,2:835\n13579#6,2:837\n131#7,6:842\n*S KotlinDebug\n*F\n+ 1 Shell.kt\nandroidx/benchmark/Shell\n*L\n281#1:769\n377#1:787\n434#1:818\n281#1:759,9\n281#1:768\n281#1:770\n281#1:771\n377#1:777,9\n377#1:786\n377#1:788\n377#1:789\n395#1:790\n395#1:791,3\n396#1:794\n396#1:795,2\n397#1:797\n397#1:798,3\n420#1:801\n420#1:802,2\n421#1:804\n421#1:805,3\n434#1:808,9\n434#1:817\n434#1:819\n434#1:820\n450#1:821\n450#1:822,3\n454#1:825\n454#1:826,2\n471#1:828,3\n485#1:831\n485#1:832,3\n510#1:839\n510#1:840,2\n327#1:772,5\n491#1:835,2\n501#1:837,2\n514#1:842,6\n*E\n"})
public final class Shell {
    @NotNull
    public static final Shell INSTANCE = new Shell();

    private Shell() {
    }

    private final boolean psLineContainsProcess(String psOutputLine, String processName) {
        return StringsKt.endsWith$default((String)psOutputLine, (String)(' ' + processName), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)psOutputLine, (String)('/' + processName), (boolean)false, (int)2, null);
    }

    private final boolean fullProcessNameMatchesProcess(String fullProcessName, String processName) {
        return Intrinsics.areEqual((Object)fullProcessName, (Object)processName) || StringsKt.endsWith$default((String)fullProcessName, (String)('/' + processName), (boolean)false, (int)2, null);
    }

    public final void connectUiAutomation() {
        if (Build.VERSION.SDK_INT >= 21) {
        }
    }

    @Nullable
    public final String optionalCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return Build.VERSION.SDK_INT >= 21 ? Shell.executeScriptCaptureStdoutStderr$default(this, command, null, 2, null).getStdout() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Long catProcFileLong(@NotNull String path) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = this.optionalCommand("cat " + path);
        if (string == null) return null;
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (string2 == null) return null;
        String $this$catProcFileLong_u24lambda_u240 = string2;
        boolean bl = false;
        try {
            l = Long.parseLong($this$catProcFileLong_u24lambda_u240);
        }
        catch (NumberFormatException exception) {
            return null;
        }
        Long l2 = l;
        return l2;
    }

    @RequiresApi(value=21)
    @NotNull
    public final String getChecksum$benchmark_common_release(@NotNull String path) {
        String sum;
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Build.VERSION.SDK_INT >= 23) {
            string = StringsKt.substringBefore$default((String)ShellImpl.INSTANCE.executeCommandUnsafe("md5sum " + path), (String)" ", null, (int)2, null);
        } else {
            String result = ShellImpl.INSTANCE.executeCommandUnsafe("ls -l " + path);
            if (StringsKt.isBlank((CharSequence)result)) {
                string = "";
            } else {
                CharSequence charSequence = result;
                Regex regex = new Regex("\\s+");
                int n = 0;
                string = sum = (String)regex.split(charSequence, n).get(3);
            }
        }
        if (!(!StringsKt.isBlank((CharSequence)sum))) {
            boolean bl = false;
            String string2 = "Checksum for " + path + " was blank";
            throw new IllegalStateException(string2.toString());
        }
        return sum;
    }

    @RequiresApi(value=21)
    private final void moveToTmpAndMakeExecutable(String src, String dst) {
        ShellImpl.INSTANCE.executeCommandUnsafe("cp " + src + ' ' + dst);
        if (Build.VERSION.SDK_INT >= 23) {
            ShellImpl.INSTANCE.executeCommandUnsafe("chmod +x " + dst);
        } else {
            ShellImpl.INSTANCE.executeCommandUnsafe("chmod 777 " + dst);
        }
        String srcSum = this.getChecksum$benchmark_common_release(src);
        String dstSum = this.getChecksum$benchmark_common_release(dst);
        if (!Intrinsics.areEqual((Object)srcSum, (Object)dstSum)) {
            throw new IllegalStateException("Failed to verify copied executable " + dst + ", md5 sums " + srcSum + ", " + dstSum + " don't match. Check if root owns " + dst + " and if so, delete it with `adb root`-ed shell session.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=21)
    @NotNull
    public final String createRunnableExecutable(@NotNull String name, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        File writableExecutableFile = File.createTempFile("temporary_" + name, null, Outputs.INSTANCE.getDirUsableByAppAndShell());
        String runnableExecutablePath = "/data/local/tmp/" + name;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)writableExecutableFile, (String)"writableExecutableFile");
            Closeable closeable = new FileOutputStream(writableExecutableFile);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (Outputs.INSTANCE.getForceFilesForShellAccessible()) {
                writableExecutableFile.setReadable(true, false);
            }
            String string = writableExecutableFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writableExecutableFile.absolutePath");
            this.moveToTmpAndMakeExecutable(string, runnableExecutablePath);
        }
        finally {
            writableExecutableFile.delete();
        }
        return runnableExecutablePath;
    }

    @RequiresApi(value=21)
    public final boolean isSessionRooted() {
        return ShellImpl.INSTANCE.isSessionRooted() || ShellImpl.INSTANCE.isSuAvailable();
    }

    @RequiresApi(value=21)
    @NotNull
    public final String getprop(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return ((Object)StringsKt.trim((CharSequence)Shell.executeScriptCaptureStdout$default(this, "getprop " + propertyName, null, 2, null))).toString();
    }

    @RequiresApi(value=21)
    public final void executeScriptSilent(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Output output = this.executeScriptCaptureStdoutStderr(script, stdin);
        if (!output.isBlank()) {
            boolean bl = false;
            String string = "Expected no stdout/stderr from " + script + ", saw " + output;
            throw new IllegalStateException(string.toString());
        }
    }

    public static /* synthetic */ void executeScriptSilent$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        shell.executeScriptSilent(string, string2);
    }

    @RequiresApi(value=21)
    @CheckResult
    @NotNull
    public final String executeScriptCaptureStdout(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Output output = this.executeScriptCaptureStdoutStderr(script, stdin);
        if (!StringsKt.isBlank((CharSequence)output.getStderr())) {
            boolean bl = false;
            String string = "Expected no stderr from " + script + ", saw " + output.getStderr();
            throw new IllegalStateException(string.toString());
        }
        return output.getStdout();
    }

    public static /* synthetic */ String executeScriptCaptureStdout$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScriptCaptureStdout(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @CheckResult
    @NotNull
    public final List<String> pmPath(@NotNull String packageName) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)Shell.executeScriptCaptureStdout$default(this, "pm path " + packageName, null, 2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String delimiter = "package:";
            int index = StringsKt.indexOf$default((CharSequence)it, (String)delimiter, (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string2 = it.substring(index + delimiter.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=21)
    @CheckResult
    @NotNull
    public final Output executeScriptCaptureStdoutStderr(@NotNull String script, @Nullable String stdin) {
        Output output;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String label$iv = StringsKt.take((String)("executeScript " + script), (int)127);
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            output = ShellImpl.INSTANCE.createShellScript(script, stdin).start().getOutputAndClose();
        }
        finally {
            Trace.endSection();
        }
        return output;
    }

    public static /* synthetic */ Output executeScriptCaptureStdoutStderr$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScriptCaptureStdoutStderr(string, string2);
    }

    @RequiresApi(value=21)
    @CheckResult
    @NotNull
    public final String executeCommandCaptureStdoutOnly(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return ShellImpl.INSTANCE.executeCommandUnsafe(command);
    }

    @RequiresApi(value=21)
    @NotNull
    public final ShellScript createShellScript(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return ShellImpl.INSTANCE.createShellScript(script, stdin);
    }

    public static /* synthetic */ ShellScript createShellScript$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.createShellScript(string, string2);
    }

    @RequiresApi(value=21)
    public final boolean isPackageAlive(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return !((Collection)this.getPidsForProcess(packageName)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @NotNull
    public final List<Integer> getPidsForProcess(@NotNull String processName) {
        Iterable $this$filterTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$mapNotNullTo$iv$iv22;
            Iterable $this$mapNotNull$iv = this.pgrepLF(processName);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl2 = false;
                int pid = ((Number)pair.component1()).intValue();
                String fullProcessName = (String)pair.component2();
                if ((INSTANCE.fullProcessNameMatchesProcess(fullProcessName, processName) ? Integer.valueOf(pid) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        CharSequence $this$mapNotNull$iv = Shell.executeScriptCaptureStdout$default(this, "ps | grep " + processName, null, 2, null);
        Regex $i$f$mapNotNull = new Regex("\r?\n");
        int $this$mapNotNullTo$iv$iv22 = 0;
        Iterable $this$map$iv = $i$f$mapNotNull.split($this$mapNotNull$iv, $this$mapNotNullTo$iv$iv22);
        boolean $i$f$map = false;
        Iterable $this$mapNotNullTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            Regex regex = new Regex("\\s+");
            int n = 0;
            collection.add(Integer.parseInt((String)regex.split(charSequence, n).get(1)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=23)
    private final List<Pair<Integer, String>> pgrepLF(String pattern) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        CharSequence charSequence = ShellImpl.INSTANCE.executeCommandUnsafe("pgrep -l -f " + pattern);
        Regex regex = new Regex("\r?\n");
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            List list = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String pidString = (String)list.get(0);
            String process = (String)list.get(1);
            collection.add(new Pair((Object)Integer.parseInt(pidString), (Object)process));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @NotNull
    public final List<String> getRunningProcessesForPackage(@NotNull String packageName) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!(!StringsKt.contains$default((CharSequence)packageName, (CharSequence)":", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-Shell$getRunningProcessesForPackage$22 = false;
            String $i$a$-require-Shell$getRunningProcessesForPackage$22 = "Package " + packageName + " must not contain ':'";
            throw new IllegalArgumentException($i$a$-require-Shell$getRunningProcessesForPackage$22.toString());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$mapNotNullTo$iv$iv22;
            Iterable $this$mapNotNull$iv = this.pgrepLF(packageName);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl2 = false;
                String process = (String)pair.component2();
                if ((Intrinsics.areEqual((Object)process, (Object)packageName) || StringsKt.startsWith$default((String)process, (String)(packageName + ':'), (boolean)false, (int)2, null) ? process : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        CharSequence $this$mapNotNull$iv = Shell.executeScriptCaptureStdout$default(this, "ps | grep " + packageName, null, 2, null);
        Regex $i$f$mapNotNull = new Regex("\r?\n");
        int $this$mapNotNullTo$iv$iv22 = 0;
        Iterable $this$map$iv = $i$f$mapNotNull.split($this$mapNotNull$iv, $this$mapNotNullTo$iv$iv22);
        boolean $i$f$map = false;
        Iterable $this$mapNotNullTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringAfterLast$default((String)it, (String)" ", null, (int)2, null));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)packageName) || StringsKt.startsWith$default((String)it, (String)(packageName + ':'), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @RequiresApi(value=21)
    public final boolean isProcessAlive(int pid, @NotNull String processName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            CharSequence charSequence = ShellImpl.INSTANCE.executeCommandUnsafe("ps " + pid);
            Regex regex = new Regex("\r?\n");
            int n = 0;
            Iterable $this$any$iv = regex.split(charSequence, n);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    public final void terminateProcessesAndWait(long waitPollPeriodMs, int waitPollMaxCount, @NotNull String processName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Iterable $this$map$iv = this.getPidsForProcess(processName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pid;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProcessPid(processName, (int)pid));
        }
        List processes = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = processes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProcessPid[] processPidArray = thisCollection$iv.toArray(new ProcessPid[0]);
        this.terminateProcessesAndWait(waitPollPeriodMs, waitPollMaxCount, Arrays.copyOf(processPidArray, processPidArray.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    public final void terminateProcessesAndWait(long waitPollPeriodMs, int waitPollMaxCount, ProcessPid ... processes) {
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        ProcessPid[] $this$forEach$iv = processes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ProcessPid processPid;
            ProcessPid it = processPid = $this$forEach$iv[i];
            boolean bl = false;
            Output stopOutput = Shell.executeScriptCaptureStdoutStderr$default(INSTANCE, "kill -TERM " + it.getPid(), null, 2, null);
            Log.d((String)"Benchmark", (String)("kill -TERM command output - " + stopOutput));
        }
        Ref.ObjectRef runningProcesses = new Ref.ObjectRef();
        runningProcesses.element = ArraysKt.toList((Object[])processes);
        for (int i = 0; i < waitPollMaxCount; ++i) {
            void $this$filterTo$iv$iv;
            int it = i;
            boolean bl = false;
            Iterable iterable = (Iterable)runningProcesses.element;
            Ref.ObjectRef objectRef = runningProcesses;
            boolean $i$f$filter = false;
            Iterable stopOutput = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProcessPid it2 = (ProcessPid)element$iv$iv;
                boolean bl2 = false;
                if (!INSTANCE.isProcessAlive(it2.getPid(), it2.getProcessName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            objectRef.element = (List)destination$iv$iv;
            if (((List)runningProcesses.element).isEmpty()) {
                return;
            }
            String string = "wait for " + runningProcesses.element + " to die";
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, string, 0L, 2, null);
            try {
                boolean bl3 = false;
                SystemClock.sleep((long)waitPollPeriodMs);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            Log.d((String)"Benchmark", (String)("Waiting " + waitPollPeriodMs + " ms for " + runningProcesses.element + " to die"));
        }
        throw new IllegalStateException("Failed to stop " + runningProcesses.element);
    }

    @RequiresApi(value=21)
    public final boolean pathExists(@NotNull String absoluteFilePath) {
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)ShellImpl.INSTANCE.executeCommandUnsafe("ls " + absoluteFilePath))).toString(), (Object)absoluteFilePath);
    }

    @RequiresApi(value=21)
    @Nullable
    public final Integer amBroadcast(@NotNull String broadcastArguments) {
        Intrinsics.checkNotNullParameter((Object)broadcastArguments, (String)"broadcastArguments");
        return StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)ShellImpl.INSTANCE.executeCommandUnsafe("am broadcast " + broadcastArguments), (String)"Broadcast completed: result=", null, (int)2, null))).toString());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\rJ\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Landroidx/benchmark/Shell$Output;", "", "stdout", "", "stderr", "(Ljava/lang/String;Ljava/lang/String;)V", "getStderr", "()Ljava/lang/String;", "getStdout", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isBlank", "toString", "benchmark-common_release"})
    public static final class Output {
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        public Output(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        public final boolean isBlank() {
            return StringsKt.isBlank((CharSequence)this.stdout) && StringsKt.isBlank((CharSequence)this.stderr);
        }

        @NotNull
        public final String component1() {
            return this.stdout;
        }

        @NotNull
        public final String component2() {
            return this.stderr;
        }

        @NotNull
        public final Output copy(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            return new Output(stdout, stderr);
        }

        public static /* synthetic */ Output copy$default(Output output, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = output.stdout;
            }
            if ((n & 2) != 0) {
                string2 = output.stderr;
            }
            return output.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Output(stdout=" + this.stdout + ", stderr=" + this.stderr + ')';
        }

        public int hashCode() {
            int result = this.stdout.hashCode();
            result = result * 31 + this.stderr.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.stdout, (Object)output.stdout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stderr, (Object)output.stderr);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u000fJ\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/benchmark/Shell$ProcessPid;", "", "processName", "", "pid", "", "(Ljava/lang/String;I)V", "getPid", "()I", "getProcessName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "isAlive", "toString", "benchmark-common_release"})
    @RequiresApi(value=21)
    public static final class ProcessPid {
        @NotNull
        private final String processName;
        private final int pid;

        public ProcessPid(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            this.processName = processName;
            this.pid = pid;
        }

        @NotNull
        public final String getProcessName() {
            return this.processName;
        }

        public final int getPid() {
            return this.pid;
        }

        public final boolean isAlive() {
            return INSTANCE.isProcessAlive(this.pid, this.processName);
        }

        @NotNull
        public final String component1() {
            return this.processName;
        }

        public final int component2() {
            return this.pid;
        }

        @NotNull
        public final ProcessPid copy(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            return new ProcessPid(processName, pid);
        }

        public static /* synthetic */ ProcessPid copy$default(ProcessPid processPid, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = processPid.processName;
            }
            if ((n2 & 2) != 0) {
                n = processPid.pid;
            }
            return processPid.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ProcessPid(processName=" + this.processName + ", pid=" + this.pid + ')';
        }

        public int hashCode() {
            int result = this.processName.hashCode();
            result = result * 31 + Integer.hashCode(this.pid);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessPid)) {
                return false;
            }
            ProcessPid processPid = (ProcessPid)other;
            if (!Intrinsics.areEqual((Object)this.processName, (Object)processPid.processName)) {
                return false;
            }
            return this.pid == processPid.pid;
        }
    }
}

