/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.PropOverride;
import androidx.benchmark.Shell;
import androidx.benchmark.perfetto.PerfettoCapture;
import androidx.benchmark.perfetto.PerfettoHelper;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J \u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0003J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/perfetto/PerfettoCaptureWrapper;", "", "()V", "TRACE_ENABLE_PROP", "", "capture", "Landroidx/benchmark/perfetto/PerfettoCapture;", "record", "fileLabel", "appTagPackages", "", "userspaceTracingPackage", "traceCallback", "Lkotlin/Function1;", "", "block", "Lkotlin/Function0;", "start", "", "stop", "traceLabel", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PerfettoCaptureWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PerfettoCapture capture;
    @NotNull
    private final String TRACE_ENABLE_PROP;
    @NotNull
    private static final Object inUseLock = new Object();
    private static boolean inUse;

    public PerfettoCaptureWrapper() {
        this.TRACE_ENABLE_PROP = "persist.traced.enable";
        if (Build.VERSION.SDK_INT >= 21) {
            this.capture = new PerfettoCapture(false, 1, null);
        }
    }

    @RequiresApi(value=21)
    private final boolean start(List<String> appTagPackages, String userspaceTracingPackage) {
        block3: {
            PerfettoCapture perfettoCapture;
            PerfettoCapture perfettoCapture2 = this.capture;
            if (perfettoCapture2 == null) break block3;
            PerfettoCapture $this$start_u24lambda_u240 = perfettoCapture = perfettoCapture2;
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 21) {
                Log.d((String)"PerfettoCapture", (String)"Recording perfetto trace");
                if (userspaceTracingPackage != null && Build.VERSION.SDK_INT >= 30) {
                    String string = $this$start_u24lambda_u240.enableAndroidxTracingPerfetto(userspaceTracingPackage, true);
                    if (string == null) {
                        string = "Success";
                    }
                    String result = string;
                    Log.d((String)"PerfettoCapture", (String)("Enable full tracing result=" + result));
                }
                $this$start_u24lambda_u240.start(appTagPackages);
            }
        }
        return true;
    }

    @RequiresApi(value=21)
    private final String stop(String traceLabel) {
        return Outputs.writeFile$default(Outputs.INSTANCE, traceLabel + '_' + Outputs.dateToFileName$default(Outputs.INSTANCE, null, 1, null) + ".perfetto-trace", "perfetto_trace_" + traceLabel, false, (Function1)new Function1<File, Unit>(this){
            final /* synthetic */ PerfettoCaptureWrapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PerfettoCapture perfettoCapture = PerfettoCaptureWrapper.access$getCapture$p(this.this$0);
                Intrinsics.checkNotNull((Object)perfettoCapture);
                String string = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
                perfettoCapture.stop(string);
                if (Outputs.INSTANCE.getForceFilesForShellAccessible()) {
                    Shell.executeScriptSilent$default(Shell.INSTANCE, "chmod 777 " + it.getAbsolutePath(), null, 2, null);
                }
            }
        }, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String record(@NotNull String fileLabel, @NotNull List<String> appTagPackages, @Nullable String userspaceTracingPackage, @Nullable Function1<? super String, Unit> traceCallback, @NotNull Function0<Unit> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileLabel, (String)"fileLabel");
        Intrinsics.checkNotNullParameter(appTagPackages, (String)"appTagPackages");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (Build.VERSION.SDK_INT < 21 || !PerfettoHelper.Companion.isAbiSupported()) {
            block.invoke();
            return null;
        }
        Object object2 = inUseLock;
        synchronized (object2) {
            boolean bl = false;
            if (inUse) {
                throw new IllegalStateException("Reentrant Perfetto Tracing is not supported. This means you cannot use more than one of BenchmarkRule/MacrobenchmarkRule/PerfettoTraceRule/PerfettoTrace.record together.");
            }
            inUse = true;
            object = Unit.INSTANCE;
        }
        PropOverride propOverride = Build.VERSION.SDK_INT == 29 ? new PropOverride(this.TRACE_ENABLE_PROP, "1") : null;
        String path = null;
        try {
            PropOverride propOverride2 = propOverride;
            if (propOverride2 != null) {
                propOverride2.forceValue();
            }
            this.start(appTagPackages, userspaceTracingPackage);
            try {
                block.invoke();
            }
            finally {
                path = this.stop(fileLabel);
                Function1<? super String, Unit> function1 = traceCallback;
                if (function1 != null) {
                    function1.invoke((Object)path);
                }
            }
            object = path;
            return object;
        }
        finally {
            PropOverride propOverride3 = propOverride;
            if (propOverride3 != null) {
                propOverride3.resetIfOverridden();
            }
            Object object3 = inUseLock;
            synchronized (object3) {
                boolean $i$a$-synchronized-PerfettoCaptureWrapper$record$32 = false;
                inUse = false;
                Unit $i$a$-synchronized-PerfettoCaptureWrapper$record$32 = Unit.INSTANCE;
            }
        }
    }

    public static /* synthetic */ String record$default(PerfettoCaptureWrapper perfettoCaptureWrapper, String string, List list, String string2, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        return perfettoCaptureWrapper.record(string, list, string2, (Function1<? super String, Unit>)function1, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ PerfettoCapture access$getCapture$p(PerfettoCaptureWrapper $this) {
        return $this.capture;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/benchmark/perfetto/PerfettoCaptureWrapper$Companion;", "", "()V", "inUse", "", "getInUse", "()Z", "setInUse", "(Z)V", "inUseLock", "Ljava/lang/Object;", "getInUseLock", "()Ljava/lang/Object;", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getInUseLock() {
            return inUseLock;
        }

        public final boolean getInUse() {
            return inUse;
        }

        public final void setInUse(boolean bl) {
            inUse = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

