/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.UiAutomation;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.benchmark.Outputs;
import androidx.benchmark.ShellKt;
import androidx.benchmark.ShellScript;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.Trace;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/ShellImpl;", "", "()V", "isSessionRooted", "", "()Z", "setSessionRooted", "(Z)V", "isSuAvailable", "setSuAvailable", "uiAutomation", "Landroid/app/UiAutomation;", "kotlin.jvm.PlatformType", "createShellScript", "Landroidx/benchmark/ShellScript;", "script", "", "stdin", "executeCommandNonBlockingUnsafe", "Landroid/os/ParcelFileDescriptor;", "cmd", "executeCommandUnsafe", "benchmark-common_release"})
@RequiresApi(value=21)
@SourceDebugExtension(value={"SMAP\nShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shell.kt\nandroidx/benchmark/ShellImpl\n+ 2 Trace.kt\nandroidx/tracing/TraceKt\n*L\n1#1,757:1\n27#2,5:758\n27#2,5:763\n27#2,5:768\n*S KotlinDebug\n*F\n+ 1 Shell.kt\nandroidx/benchmark/ShellImpl\n*L\n577#1:758,5\n582#1:763,5\n595#1:768,5\n*E\n"})
final class ShellImpl {
    @NotNull
    public static final ShellImpl INSTANCE = new ShellImpl();
    private static final UiAutomation uiAutomation;
    private static boolean isSessionRooted;
    private static boolean isSuAvailable;

    private ShellImpl() {
    }

    public final boolean isSessionRooted() {
        return isSessionRooted;
    }

    public final void setSessionRooted(boolean bl) {
        isSessionRooted = bl;
    }

    public final boolean isSuAvailable() {
        return isSuAvailable;
    }

    public final void setSuAvailable(boolean bl) {
        isSuAvailable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String executeCommandUnsafe(@NotNull String cmd) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String label$iv = StringsKt.take((String)("executeCommand " + cmd), (int)127);
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            string = ShellKt.fullyReadInputStream(INSTANCE.executeCommandNonBlockingUnsafe(cmd));
        }
        finally {
            Trace.endSection();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ParcelFileDescriptor executeCommandNonBlockingUnsafe(@NotNull String cmd) {
        ParcelFileDescriptor parcelFileDescriptor;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String label$iv = StringsKt.take((String)("executeCommandNonBlocking " + cmd), (int)127);
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            ParcelFileDescriptor parcelFileDescriptor2 = ShellImpl.uiAutomation.executeShellCommand(!INSTANCE.isSessionRooted() && INSTANCE.isSuAvailable() ? "su root " + cmd : cmd);
            parcelFileDescriptor = parcelFileDescriptor2;
        }
        finally {
            Trace.endSection();
        }
        Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"trace(\"executeCommandNon\u2026}\n            )\n        }");
        return parcelFileDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ShellScript createShellScript(@NotNull String script, @Nullable String stdin) {
        ShellScript shellScript;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String label$iv = "createShellScript";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            ShellScript shellScript2;
            File file;
            boolean bl = false;
            File externalDir = Outputs.INSTANCE.getDirUsableByAppAndShell();
            File scriptContentFile = File.createTempFile("temporaryScript", null, externalDir);
            if (Outputs.INSTANCE.getForceFilesForShellAccessible()) {
                scriptContentFile.setReadable(true, false);
            }
            String string = stdin;
            if (string != null) {
                String $this$createShellScript_u24lambda_u244_u24lambda_u243 = string;
                boolean bl2 = false;
                file = File.createTempFile("temporaryStdin", null, externalDir);
            } else {
                file = null;
            }
            File stdinFile = file;
            String stderrPath = "/data/local/tmp/" + scriptContentFile.getName() + "_stderr";
            try {
                File file2 = stdinFile;
                if (file2 != null) {
                    FilesKt.writeText$default((File)file2, (String)stdin, null, (int)2, null);
                }
                Intrinsics.checkNotNullExpressionValue((Object)scriptContentFile, (String)"scriptContentFile");
                FilesKt.writeText$default((File)scriptContentFile, (String)script, null, (int)2, null);
                shellScript2 = new ShellScript(stdinFile, scriptContentFile, stderrPath);
            }
            catch (Exception e) {
                throw new Exception("Can't create shell script", e);
            }
            shellScript = shellScript2;
        }
        finally {
            Trace.endSection();
        }
        return shellScript;
    }

    static {
        if (!(!Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread()))) {
            boolean bl = false;
            String string = "ShellImpl must not be initialized on the UI thread - UiAutomation must not be connected on the main thread!";
            throw new IllegalArgumentException(string.toString());
        }
        uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        isSessionRooted = StringsKt.contains$default((CharSequence)INSTANCE.executeCommandUnsafe("id"), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
        isSuAvailable = StringsKt.contains$default((CharSequence)INSTANCE.createShellScript("su root id", null).start().getOutputAndClose().getStdout(), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
    }
}

