/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.annotation.RequiresApi;
import androidx.benchmark.Arguments;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import androidx.benchmark.PropOverride;
import androidx.benchmark.Shell;
import androidx.benchmark.StackSamplingSimpleperf;
import androidx.benchmark.simpleperf.ProfileSession;
import androidx.benchmark.simpleperf.RecordOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/StackSamplingSimpleperf;", "Landroidx/benchmark/Profiler;", "()V", "outputRelativePath", "", "getOutputRelativePath", "()Ljava/lang/String;", "setOutputRelativePath", "(Ljava/lang/String;)V", "requiresLibraryOutputDir", "", "getRequiresLibraryOutputDir", "()Z", "securityPerfHarden", "Landroidx/benchmark/PropOverride;", "session", "Landroidx/benchmark/simpleperf/ProfileSession;", "start", "Landroidx/benchmark/Profiler$ResultFile;", "traceUniqueName", "stop", "", "benchmark-common_release"})
public final class StackSamplingSimpleperf
extends Profiler {
    @NotNull
    public static final StackSamplingSimpleperf INSTANCE = new StackSamplingSimpleperf();
    @RequiresApi(value=29)
    @Nullable
    private static ProfileSession session;
    @RequiresApi(value=29)
    @NotNull
    private static final PropOverride securityPerfHarden;
    @Nullable
    private static String outputRelativePath;
    private static final boolean requiresLibraryOutputDir;

    private StackSamplingSimpleperf() {
        super(null);
    }

    @Nullable
    public final String getOutputRelativePath() {
        return outputRelativePath;
    }

    public final void setOutputRelativePath(@Nullable String string) {
        outputRelativePath = string;
    }

    @Override
    @RequiresApi(value=29)
    @Nullable
    public Profiler.ResultFile start(@NotNull String traceUniqueName) {
        ProfileSession profileSession;
        Intrinsics.checkNotNullParameter((Object)traceUniqueName, (String)"traceUniqueName");
        ProfileSession profileSession2 = session;
        if (profileSession2 != null) {
            profileSession2.stopRecording();
        }
        securityPerfHarden.forceValue();
        Shell.executeScriptSilent$default(Shell.INSTANCE, "setprop debug.perf_event_max_sample_rate 10000", null, 2, null);
        Shell.executeScriptSilent$default(Shell.INSTANCE, "setprop debug.perf_cpu_time_max_percent 25", null, 2, null);
        Shell.executeScriptSilent$default(Shell.INSTANCE, "setprop debug.perf_event_mlock_kb 32800", null, 2, null);
        outputRelativePath = Profiler.Companion.traceName(traceUniqueName, "stackSampling");
        ProfileSession it = profileSession = new ProfileSession();
        boolean bl = false;
        Shell.executeScriptSilent$default(Shell.INSTANCE, it.findSimpleperf() + " api-prepare", null, 2, null);
        it.startRecording(new RecordOptions().setSampleFrequency(Arguments.INSTANCE.getProfilerSampleFrequency$benchmark_common_release()).recordDwarfCallGraph().setEvent("cpu-clock").traceOffCpu().setSampleCurrentThread().setOutputFilename("simpleperf.data"));
        session = profileSession;
        String string = outputRelativePath;
        Intrinsics.checkNotNull((Object)string);
        return new Profiler.ResultFile("Stack Sampling Trace", string);
    }

    @Override
    @RequiresApi(value=29)
    public void stop() {
        ProfileSession profileSession = session;
        Intrinsics.checkNotNull((Object)profileSession);
        profileSession.stopRecording();
        String string = outputRelativePath;
        Intrinsics.checkNotNull((Object)string);
        Outputs.writeFile$default(Outputs.INSTANCE, string, "simpleperf_trace", false, stop.1.INSTANCE, 4, null);
        session = null;
        securityPerfHarden.resetIfOverridden();
    }

    @Override
    public boolean getRequiresLibraryOutputDir() {
        return requiresLibraryOutputDir;
    }

    public static final /* synthetic */ ProfileSession access$getSession$p() {
        return session;
    }

    static {
        securityPerfHarden = new PropOverride("security.perf_harden", "0");
    }
}

