/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.perfetto.PerfettoCapture;
import androidx.benchmark.perfetto.PerfettoConfigKt;
import androidx.benchmark.perfetto.PerfettoHelper;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.perfetto.PerfettoHandshake;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0007J\u0006\u0010\u000b\u001a\u00020\u0003J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/perfetto/PerfettoCapture;", "", "unbundled", "", "(Z)V", "helper", "Landroidx/benchmark/perfetto/PerfettoHelper;", "enableAndroidxTracingPerfetto", "", "targetPackage", "provideBinariesIfMissing", "isRunning", "start", "", "packages", "", "stop", "destinationPath", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
@SourceDebugExtension(value={"SMAP\nPerfettoCapture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoCapture.kt\nandroidx/benchmark/perfetto/PerfettoCapture\n+ 2 UserspaceTracing.kt\nandroidx/benchmark/UserspaceTracingKt\n*L\n1#1,175:1\n131#2,3:176\n131#2,6:179\n131#2,6:185\n135#2,2:191\n131#2,6:193\n*S KotlinDebug\n*F\n+ 1 PerfettoCapture.kt\nandroidx/benchmark/perfetto/PerfettoCapture\n*L\n63#1:176,3\n68#1:179,6\n79#1:185,6\n63#1:191,2\n93#1:193,6\n*E\n"})
public final class PerfettoCapture {
    @NotNull
    private final PerfettoHelper helper;

    public PerfettoCapture(boolean unbundled) {
        this.helper = new PerfettoHelper(unbundled);
    }

    public /* synthetic */ PerfettoCapture(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = Build.VERSION.SDK_INT <= 29;
        }
        this(bl);
    }

    public final boolean isRunning() {
        return this.helper.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull List<String> packages) {
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        String label$iv = "start perfetto";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            File configProtoFile = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), "trace_config.pb");
            try {
                String label$iv2 = "write config";
                boolean $i$f$userspaceTrace2 = false;
                UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv2, 0L, 2, null);
                try {
                    boolean bl2 = false;
                    List atraceApps = Build.VERSION.SDK_INT <= 28 || packages.isEmpty() ? packages : CollectionsKt.listOf((Object)"*");
                    FilesKt.writeBytes((File)configProtoFile, (byte[])PerfettoConfigKt.validateAndEncode(PerfettoConfigKt.perfettoConfig(atraceApps)));
                    if (Outputs.INSTANCE.getForceFilesForShellAccessible()) {
                        configProtoFile.setReadable(true, false);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
                }
                label$iv2 = "start perfetto process";
                $i$f$userspaceTrace2 = false;
                UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv2, 0L, 2, null);
                try {
                    boolean bl3 = false;
                    String string = configProtoFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configProtoFile.absolutePath");
                    this.helper.startCollecting(string, false);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
                }
            }
            finally {
                configProtoFile.delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull String destinationPath) {
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        String label$iv = "stop perfetto";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            this.helper.stopCollecting(destinationPath);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
        }
    }

    @RequiresApi(value=30)
    @Nullable
    public final String enableAndroidxTracingPerfetto(@NotNull String targetPackage, boolean provideBinariesIfMissing) {
        String string;
        PerfettoHandshake.EnableTracingResponse enableTracingResponse;
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        if (!PerfettoHelper.Companion.isAbiSupported()) {
            StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
            throw new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])Build.SUPPORTED_ABIS, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
        }
        PerfettoHandshake handshake2 = new PerfettoHandshake(targetPackage, (Function1)enableAndroidxTracingPerfetto.handshake.1.INSTANCE, (Function1)new Function1<String, String>((Object)Shell.INSTANCE){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Shell.executeScriptCaptureStdout$default((Shell)enableAndroidxTracingPerfetto.handshake.2.access$getReceiver$p(this), p0, null, 2, null);
            }

            public static final /* synthetic */ Object access$getReceiver$p(enableAndroidxTracingPerfetto.handshake.2 $this) {
                return $this.receiver;
            }
        });
        PerfettoHandshake.EnableTracingResponse it = handshake2.enableTracing(null);
        boolean bl = false;
        if (it.getExitCode() == 11 && provideBinariesIfMissing) {
            String string2 = InstrumentationRegistry.getInstrumentation().getContext().getApplicationInfo().publicSourceDir;
            Intrinsics.checkNotNull((Object)string2);
            File baseApk = new File(string2);
            PerfettoHandshake.ExternalLibraryProvider libraryProvider2 = new PerfettoHandshake.ExternalLibraryProvider(baseApk, Outputs.INSTANCE.getDirUsableByAppAndShell(), (Function2)enableAndroidxTracingPerfetto.response.1.libraryProvider.1.INSTANCE);
            enableTracingResponse = handshake2.enableTracing(libraryProvider2);
        } else {
            enableTracingResponse = it;
        }
        PerfettoHandshake.EnableTracingResponse response2 = enableTracingResponse;
        switch (response2.getExitCode()) {
            case 0: {
                string = "The broadcast to enable tracing was not received. This most likely means that the app does not contain the `androidx.tracing.tracing-perfetto` library as its dependency.";
                break;
            }
            case 1: {
                string = null;
                break;
            }
            case 2: {
                string = "Perfetto SDK already enabled.";
                break;
            }
            case 11: {
                string = "Perfetto SDK binary dependencies missing. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + ".\nTo fix, declare the following dependency in your *benchmark* project (i.e. not the app under benchmark): \nandroidTestImplementation(\"androidx.tracing:tracing-perfetto-binary:" + response2.getRequiredVersion() + "\")";
                break;
            }
            case 12: {
                string = "Perfetto SDK binary mismatch. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + '.';
                break;
            }
            case 13: {
                string = "Perfetto SDK binary verification failed. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + ". If working with an unreleased snapshot, ensure all modules are built against the same snapshot (e.g. clear caches and rebuild).";
                break;
            }
            case 99: {
                string = "Error: " + response2.getMessage() + '.';
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized exit code: " + response2.getExitCode() + '.');
            }
        }
        return string;
    }

    public PerfettoCapture() {
        this(false, 1, null);
    }
}

