/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.BenchmarkResult;
import androidx.benchmark.Errors;
import androidx.benchmark.ExperimentalBenchmarkStateApi;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.MetricResult;
import androidx.benchmark.MetricsContainer;
import androidx.benchmark.MicrobenchmarkPhase;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import androidx.benchmark.ResultWriter;
import androidx.benchmark.ThreadPriority;
import androidx.benchmark.ThrottleDetector;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.WarmupManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.RequiresOptIn;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 W2\u00020\u0001:\u0001WB\u001f\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0006B)\b\u0010\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0000\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u000206H\u0002J\u001f\u00108\u001a\u0002062\u0006\u00109\u001a\u00020\t2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020*0;H\u0082\bJ\b\u0010<\u001a\u000206H\u0002J'\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020\t2\b\u0010A\u001a\u0004\u0018\u00010*H\u0000\u00a2\u0006\u0002\bBJ\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\"H\u0007J\b\u0010E\u001a\u00020DH\u0007J\r\u0010F\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\u0018\u0010F\u001a\u00020G2\u0006\u0010I\u001a\u00020*2\u0006\u0010J\u001a\u00020*H\u0002J\u0006\u0010K\u001a\u00020\tJ\t\u0010L\u001a\u00020\tH\u0087\bJ\b\u0010M\u001a\u00020\tH\u0001J\b\u0010N\u001a\u00020\tH\u0002J\u0006\u0010O\u001a\u000206J*\u0010P\u001a\u0002062\u0006\u0010Q\u001a\u00020*2\u0006\u0010R\u001a\u00020*2\u0006\u0010S\u001a\u00020*2\b\u0010A\u001a\u0004\u0018\u00010*H\u0007J\u0006\u0010T\u001a\u000206J\b\u0010U\u001a\u00020\tH\u0002J\b\u0010V\u001a\u000206H\u0002R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u0006R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0017\"\u0004\b4\u0010\u0019\u00a8\u0006X"}, d2={"Landroidx/benchmark/BenchmarkState;", "", "warmupCount", "", "repeatCount", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "()V", "measurementCount", "simplifiedTimingOnlyMode", "", "(Ljava/lang/Integer;Ljava/lang/Integer;Z)V", "phaseConfig", "Landroidx/benchmark/MicrobenchmarkPhase$Config;", "(Landroidx/benchmark/MicrobenchmarkPhase$Config;)V", "currentLoopsPerMeasurement", "currentMeasurement", "currentMetrics", "Landroidx/benchmark/MetricsContainer;", "currentPhase", "Landroidx/benchmark/MicrobenchmarkPhase;", "iterationsPerRepeat", "getIterationsPerRepeat$benchmark_common_release$annotations", "getIterationsPerRepeat$benchmark_common_release", "()I", "setIterationsPerRepeat$benchmark_common_release", "(I)V", "iterationsRemaining", "getIterationsRemaining$annotations", "metricResults", "", "Landroidx/benchmark/MetricResult;", "paused", "phaseIndex", "phases", "", "profilerResult", "Landroidx/benchmark/Profiler$ResultFile;", "thermalThrottleSleepSeconds", "", "totalRunTimeNs", "totalRunTimeStartNs", "traceUniqueName", "", "getTraceUniqueName", "()Ljava/lang/String;", "setTraceUniqueName", "(Ljava/lang/String;)V", "warmupEstimatedIterationTimeNs", "warmupManager", "Landroidx/benchmark/WarmupManager;", "warmupRepeats", "getWarmupRepeats$benchmark_common_release", "setWarmupRepeats$benchmark_common_release", "afterBenchmark", "", "beforeBenchmark", "check", "value", "lazyMessage", "Lkotlin/Function0;", "checkFinished", "getFullStatusReport", "Landroid/os/Bundle;", "key", "reportMetrics", "tracePath", "getFullStatusReport$benchmark_common_release", "getMeasurementTimeNs", "", "getMinTimeNanos", "getReport", "Landroidx/benchmark/BenchmarkResult;", "getReport$benchmark_common_release", "testName", "className", "keepRunning", "keepRunningInline", "keepRunningInternal", "onMeasurementComplete", "pauseTiming", "report", "fullClassName", "simpleClassName", "methodName", "resumeTiming", "startNextPhase", "throwIfPaused", "Companion", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nBenchmarkState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,624:1\n382#1,8:627\n382#1,8:635\n382#1,8:643\n382#1,8:651\n382#1,8:659\n223#2,2:625\n223#2,2:667\n1549#2:670\n1620#2,3:671\n1855#2,2:674\n288#2,2:676\n1#3:669\n*S KotlinDebug\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState\n*L\n170#1:627,8\n173#1:635,8\n206#1:643,8\n238#1:651,8\n455#1:659,8\n166#1:625,2\n472#1:667,2\n488#1:670\n488#1:671,3\n492#1:674,2\n495#1:676,2\n*E\n"})
public final class BenchmarkState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean simplifiedTimingOnlyMode;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private String traceUniqueName;
    private int warmupRepeats;
    @JvmField
    public int iterationsRemaining;
    private int iterationsPerRepeat;
    @NotNull
    private final WarmupManager warmupManager;
    private boolean paused;
    private long thermalThrottleSleepSeconds;
    private long totalRunTimeStartNs;
    private long totalRunTimeNs;
    private long warmupEstimatedIterationTimeNs;
    @NotNull
    private final List<MetricResult> metricResults;
    @Nullable
    private Profiler.ResultFile profilerResult;
    @NotNull
    private final List<MicrobenchmarkPhase> phases;
    private int phaseIndex;
    @NotNull
    private MicrobenchmarkPhase currentPhase;
    @NotNull
    private MetricsContainer currentMetrics;
    private int currentMeasurement;
    private int currentLoopsPerMeasurement;
    @NotNull
    public static final String TAG = "Benchmark";
    public static final int REPEAT_COUNT_ALLOCATION = 5;
    private static final long DEFAULT_MEASUREMENT_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long SAMPLED_PROFILER_DURATION_NS = TimeUnit.SECONDS.toNanos(Arguments.INSTANCE.getProfilerSampleDurationSeconds$benchmark_common_release());
    private static boolean firstBenchmark = true;

    public BenchmarkState(@NotNull MicrobenchmarkPhase.Config phaseConfig) {
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        this.simplifiedTimingOnlyMode = phaseConfig.getSimplifiedTimingOnlyMode();
        this.traceUniqueName = "benchmark";
        this.iterationsRemaining = -1;
        this.iterationsPerRepeat = 1;
        this.warmupManager = phaseConfig.getWarmupManager();
        this.warmupEstimatedIterationTimeNs = -1L;
        this.metricResults = new ArrayList();
        this.phases = phaseConfig.generatePhases();
        this.phaseIndex = -1;
        this.currentPhase = this.phases.get(0);
        this.currentMetrics = this.phases.get(0).getMetricsContainer();
    }

    @ExperimentalBenchmarkStateApi
    public BenchmarkState(@Nullable Integer warmupCount, @Nullable Integer repeatCount) {
        this(warmupCount, repeatCount, false);
    }

    public /* synthetic */ BenchmarkState(Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        this(n, n2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BenchmarkState() {
        this(null, null, false, 2, null);
    }

    public BenchmarkState(@Nullable Integer warmupCount, @Nullable Integer measurementCount, boolean simplifiedTimingOnlyMode) {
        boolean bl = Arguments.INSTANCE.getDryRunMode();
        boolean bl2 = Arguments.INSTANCE.getStartupMode$benchmark_common_release();
        Profiler profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release();
        Integer n = Arguments.INSTANCE.getIterations$benchmark_common_release();
        if (n == null) {
            n = measurementCount;
        }
        Integer n2 = n;
        this(new MicrobenchmarkPhase.Config(bl, bl2, simplifiedTimingOnlyMode, profiler, warmupCount, n2));
    }

    public /* synthetic */ BenchmarkState(Integer n, Integer n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        this(n, n2, bl);
    }

    @NotNull
    public final String getTraceUniqueName() {
        return this.traceUniqueName;
    }

    public final void setTraceUniqueName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.traceUniqueName = string;
    }

    public final int getWarmupRepeats$benchmark_common_release() {
        return this.warmupRepeats;
    }

    public final void setWarmupRepeats$benchmark_common_release(int n) {
        this.warmupRepeats = n;
    }

    @PublishedApi
    public static /* synthetic */ void getIterationsRemaining$annotations() {
    }

    public final int getIterationsPerRepeat$benchmark_common_release() {
        return this.iterationsPerRepeat;
    }

    public final void setIterationsPerRepeat$benchmark_common_release(int n) {
        this.iterationsPerRepeat = n;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIterationsPerRepeat$benchmark_common_release$annotations() {
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final double getMinTimeNanos() {
        Object element$iv2;
        block1: {
            this.checkFinished();
            Iterable $this$first$iv = this.metricResults;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((MetricResult)element$iv2).getMin();
    }

    private final void checkFinished() {
        BenchmarkState this_$iv;
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.phaseIndex >= 0;
        boolean $i$f$check = false;
        if (!value$iv) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            if (this_$iv.phaseIndex >= 0 && this_$iv.phaseIndex <= this_$iv.phases.size()) {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            boolean bl = false;
            String string = "Attempting to interact with a benchmark that wasn't started!";
            throw new IllegalStateException(string);
        }
        this_$iv = this;
        value$iv = this.phaseIndex >= this.phases.size();
        $i$f$check = false;
        if (!value$iv) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            if (this_$iv.phaseIndex >= 0 && this_$iv.phaseIndex <= this_$iv.phases.size()) {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            boolean bl = false;
            String string = "The benchmark hasn't finished! In Java, use while(BenchmarkState.keepRunning()) to ensure keepRunning() returns false before ending your test. In Kotlin, just use benchmarkRule.measureRepeated {} to avoid the problem.";
            throw new IllegalStateException(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void pauseTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            void this_$iv;
            ThreadPriority.INSTANCE.resetBumpedThread();
            if (this_$iv.phaseIndex >= 0 && this_$iv.phaseIndex <= this_$iv.phases.size()) {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            boolean bl = false;
            String string = "Unable to pause the benchmark. The benchmark has already paused.";
            throw new IllegalStateException(string);
        }
        if (!this.currentPhase.getIgnorePauseEvent()) {
            this.currentMetrics.capturePaused();
        }
        this.paused = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void resumeTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            void this_$iv;
            ThreadPriority.INSTANCE.resetBumpedThread();
            if (this_$iv.phaseIndex >= 0 && this_$iv.phaseIndex <= this_$iv.phases.size()) {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            boolean bl = false;
            String string = "Unable to resume the benchmark. The benchmark is already running.";
            throw new IllegalStateException(string);
        }
        if (!this.currentPhase.getIgnorePauseEvent()) {
            this.currentMetrics.captureResumed();
        }
        this.paused = false;
    }

    private final boolean startNextPhase() {
        Profiler.ResultFile phaseProfilerResult;
        if (!(this.phaseIndex < this.phases.size())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (this.phaseIndex >= 0) {
            Profiler profiler = this.currentPhase.getProfiler();
            if (profiler != null) {
                profiler.stop();
            }
            UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            this.thermalThrottleSleepSeconds += this.currentPhase.getThermalThrottleSleepSeconds();
            if (this.currentPhase.getLoopMode().getWarmupManager() == null && this.currentPhase.getProfiler() == null) {
                this.metricResults.addAll((Collection<MetricResult>)this.currentMetrics.captureFinished(this.currentLoopsPerMeasurement));
            }
        }
        int n = this.phaseIndex;
        this.phaseIndex = n + 1;
        if (this.phaseIndex == this.phases.size()) {
            this.afterBenchmark();
            return false;
        }
        this.currentPhase = this.phases.get(this.phaseIndex);
        this.currentMetrics = this.currentPhase.getMetricsContainer();
        this.currentMeasurement = 0;
        this.currentMetrics.captureInit();
        if (this.currentPhase.getGcBeforePhase()) {
            Runtime.getRuntime().gc();
        }
        this.currentLoopsPerMeasurement = this.currentPhase.getLoopMode().getIterations(this.warmupEstimatedIterationTimeNs);
        this.iterationsPerRepeat = RangesKt.coerceAtLeast((int)this.iterationsPerRepeat, (int)this.currentLoopsPerMeasurement);
        UserspaceTracing.beginSection$default(UserspaceTracing.INSTANCE, this.currentPhase.getLabel(), 0L, 2, null);
        Profiler profiler = this.currentPhase.getProfiler();
        Profiler.ResultFile resultFile = phaseProfilerResult = profiler != null ? profiler.start(this.traceUniqueName) : null;
        if (phaseProfilerResult != null) {
            if (!(this.profilerResult == null)) {
                boolean bl = false;
                String string = "ProfileResult already set, only support one profiling phase";
                throw new IllegalArgumentException(string.toString());
            }
            this.profilerResult = phaseProfilerResult;
        }
        this.currentMetrics.captureStart();
        return true;
    }

    private final boolean onMeasurementComplete() {
        boolean bl;
        boolean tryStartNextPhase;
        boolean bl2;
        this.currentMetrics.captureStop();
        this.throwIfPaused();
        int n = this.currentMeasurement;
        this.currentMeasurement = n + 1;
        MicrobenchmarkPhase.LoopMode it = this.currentPhase.getLoopMode();
        boolean bl3 = false;
        if (it.getWarmupManager() != null) {
            this.currentMetrics.captureInit();
            long lastMeasuredWarmupValue = ((long[])CollectionsKt.last(this.currentMetrics.getData$benchmark_common_release()))[0];
            if (it.getWarmupManager().onNextIteration(lastMeasuredWarmupValue)) {
                this.warmupEstimatedIterationTimeNs = lastMeasuredWarmupValue;
                this.warmupRepeats = this.currentMeasurement;
                bl2 = true;
            } else {
                bl2 = false;
            }
        } else {
            bl2 = this.currentMeasurement == this.currentPhase.getMeasurementCount();
        }
        if (tryStartNextPhase = bl2) {
            if (this.currentPhase.tryEnd()) {
                bl = this.startNextPhase();
            } else {
                Profiler profiler = this.currentPhase.getProfiler();
                if (profiler != null) {
                    Profiler profiler2;
                    Profiler $this$onMeasurementComplete_u24lambda_u247 = profiler2 = profiler;
                    boolean bl4 = false;
                    $this$onMeasurementComplete_u24lambda_u247.stop();
                    this.profilerResult = $this$onMeasurementComplete_u24lambda_u247.start(this.traceUniqueName);
                }
                this.currentMetrics.captureInit();
                this.currentMeasurement = 0;
                bl = true;
            }
        } else {
            this.currentMetrics.captureStart();
            bl = true;
        }
        return bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean keepRunningInline() {
        boolean $i$f$keepRunningInline = false;
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    public final boolean keepRunning() {
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    private final void check(boolean value, Function0<String> lazyMessage) {
        boolean $i$f$check = false;
        if (!value) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            if (this.phaseIndex >= 0 && this.phaseIndex <= this.phases.size()) {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            throw new IllegalStateException((String)lazyMessage.invoke());
        }
    }

    @PublishedApi
    public final boolean keepRunningInternal() {
        boolean bl;
        if (this.phaseIndex == -1) {
            this.beforeBenchmark();
            bl = this.startNextPhase();
        } else {
            bl = this.onMeasurementComplete();
        }
        boolean shouldKeepRunning = bl;
        this.iterationsRemaining = this.currentLoopsPerMeasurement;
        return shouldKeepRunning;
    }

    private final void beforeBenchmark() {
        Errors.INSTANCE.throwIfError();
        if (!firstBenchmark && Arguments.INSTANCE.getStartupMode$benchmark_common_release()) {
            throw new AssertionError((Object)"Error - multiple benchmarks in startup mode. Only one benchmark may be run per 'am instrument' call, to ensure result isolation.");
        }
        firstBenchmark = false;
        this.thermalThrottleSleepSeconds = 0L;
        if (!this.simplifiedTimingOnlyMode) {
            ThrottleDetector.INSTANCE.computeThrottleBaselineIfNeeded();
            ThreadPriority.INSTANCE.bumpCurrentThreadPriority();
        }
        this.totalRunTimeStartNs = System.nanoTime();
    }

    private final void afterBenchmark() {
        this.totalRunTimeNs = System.nanoTime() - this.totalRunTimeStartNs;
        if (!this.simplifiedTimingOnlyMode) {
            ThreadPriority.INSTANCE.resetBumpedThread();
        }
        this.warmupManager.logInfo();
    }

    /*
     * WARNING - void declaration
     */
    private final void throwIfPaused() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            void this_$iv;
            ThreadPriority.INSTANCE.resetBumpedThread();
            if (this_$iv.phaseIndex >= 0 && this_$iv.phaseIndex <= this_$iv.phases.size()) {
                UserspaceTracing.endSection$default(UserspaceTracing.INSTANCE, 0L, 1, null);
            }
            boolean bl = false;
            String string = "Benchmark loop finished in paused state. Call BenchmarkState.resumeTiming() before BenchmarkState.keepRunning().";
            throw new IllegalStateException(string);
        }
    }

    private final BenchmarkResult getReport(String testName, String className) {
        return new BenchmarkResult(className, testName, this.totalRunTimeNs, this.metricResults, this.iterationsPerRepeat, this.thermalThrottleSleepSeconds, this.warmupRepeats);
    }

    @ExperimentalBenchmarkStateApi
    @NotNull
    public final List<Double> getMeasurementTimeNs() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.metricResults;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((MetricResult)element$iv2).getData();
    }

    @NotNull
    public final BenchmarkResult getReport$benchmark_common_release() {
        this.checkFinished();
        Unit $this$getReport_u24lambda_u2410 = Unit.INSTANCE;
        boolean bl = false;
        return this.getReport("", "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bundle getFullStatusReport$benchmark_common_release(@NotNull String key, boolean reportMetrics, @Nullable String tracePath) {
        String string;
        Object v0;
        Object $this$firstOrNull$iv;
        double nanos;
        MetricResult it;
        Bundle status;
        Object object;
        Object object2;
        CharSequence charSequence;
        block6: {
            Object object3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable iterable = this.metricResults;
            charSequence = new StringBuilder().append(key);
            object2 = TAG;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                object3 = (MetricResult)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it2.getSummary$benchmark_common_release());
            }
            object = (List)destination$iv$iv;
            Log.i((String)object2, (String)charSequence.append(object).append("count=").append(this.iterationsPerRepeat).toString());
            status = new Bundle();
            if (reportMetrics) {
                Iterable $this$forEach$iv = this.metricResults;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (MetricResult)element$iv;
                    boolean bl = false;
                    it.putInBundle(status, Errors.INSTANCE.getPREFIX());
                }
            }
            nanos = this.getMinTimeNanos();
            $this$firstOrNull$iv = this.metricResults;
            boolean $i$f$firstOrNull = false;
            object3 = $this$firstOrNull$iv.iterator();
            while (object3.hasNext()) {
                Object element$iv = object3.next();
                MetricResult it3 = (MetricResult)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it3.getName(), (Object)"allocationCount")) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        MetricResult metricResult = v0;
        Double allocations = metricResult != null ? Double.valueOf(metricResult.getMedian()) : null;
        Object object4 = new InstrumentationResultScope(status);
        CharSequence charSequence2 = InstrumentationResults.INSTANCE.ideSummaryLineWrapped$benchmark_common_release(key, nanos, allocations, null, null);
        Object object5 = InstrumentationResults.INSTANCE;
        String string2 = key;
        double d = nanos;
        Double d2 = allocations;
        String string3 = tracePath;
        if (string3 != null) {
            $this$firstOrNull$iv = string3;
            Double d3 = d2;
            double d4 = d;
            String string4 = string2;
            object = object5;
            charSequence = charSequence2;
            object2 = object4;
            boolean bl = false;
            String string5 = Outputs.INSTANCE.relativePathFor((String)((Object)it));
            object4 = object2;
            charSequence2 = charSequence;
            object5 = object;
            string2 = string4;
            d = d4;
            d2 = d3;
            string = string5;
        } else {
            string = null;
        }
        ((InstrumentationResultScope)object4).ideSummaryRecord((String)charSequence2, ((InstrumentationResults)object5).ideSummaryLineWrapped$benchmark_common_release(string2, d, d2, string, this.profilerResult));
        return status;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void report(@NotNull String fullClassName, @NotNull String simpleClassName, @NotNull String methodName, @Nullable String tracePath) {
        Intrinsics.checkNotNullParameter((Object)fullClassName, (String)"fullClassName");
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        if (this.phaseIndex == -1) {
            return;
        }
        if (tracePath != null) {
            Profiler.ResultFile resultFile = this.profilerResult;
            if (resultFile != null) {
                resultFile.embedInPerfettoTrace(tracePath);
            }
        }
        this.checkFinished();
        String fullTestName = Errors.INSTANCE.getPREFIX() + simpleClassName + '.' + methodName;
        Bundle bundle = this.getFullStatusReport$benchmark_common_release(fullTestName, !Arguments.INSTANCE.getDryRunMode(), tracePath);
        InstrumentationResults.INSTANCE.reportBundle$benchmark_common_release(bundle);
        ResultWriter.INSTANCE.appendReport(this.getReport(Errors.INSTANCE.getPREFIX() + methodName, fullClassName));
    }

    @JvmStatic
    @Companion.ExperimentalExternalReport
    public static final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
        Companion.reportData(className, testName, totalRunTimeNs, dataNs, warmupIterations, thermalThrottleSleepSeconds, repeatIterations);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\b\b\u0001\u0010\u0016\u001a\u00020\b2\b\b\u0001\u0010\u0017\u001a\u00020\u00042\b\b\u0001\u0010\u0018\u001a\u00020\bH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/BenchmarkState$Companion;", "", "()V", "DEFAULT_MEASUREMENT_DURATION_NS", "", "getDEFAULT_MEASUREMENT_DURATION_NS$benchmark_common_release", "()J", "REPEAT_COUNT_ALLOCATION", "", "SAMPLED_PROFILER_DURATION_NS", "getSAMPLED_PROFILER_DURATION_NS$benchmark_common_release", "TAG", "", "firstBenchmark", "", "reportData", "", "className", "testName", "totalRunTimeNs", "dataNs", "", "warmupIterations", "thermalThrottleSleepSeconds", "repeatIterations", "ExperimentalExternalReport", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nBenchmarkState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,624:1\n1864#2,3:625\n*S KotlinDebug\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState$Companion\n*L\n591#1:625,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_MEASUREMENT_DURATION_NS$benchmark_common_release() {
            return DEFAULT_MEASUREMENT_DURATION_NS;
        }

        public final long getSAMPLED_PROFILER_DURATION_NS$benchmark_common_release() {
            return SAMPLED_PROFILER_DURATION_NS;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @ExperimentalExternalReport
        public final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter(dataNs, (String)"dataNs");
            MetricsContainer metricsContainer = new MetricsContainer(null, dataNs.size(), 1, null);
            Iterable $this$forEachIndexed$iv = dataNs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                long l = ((Number)item$iv).longValue();
                int index = n;
                boolean bl = false;
                metricsContainer.getData$benchmark_common_release().get((int)index)[0] = value;
            }
            BenchmarkResult report = new BenchmarkResult(className, testName, totalRunTimeNs, metricsContainer.captureFinished(1), repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
            String fullTestName = Errors.INSTANCE.getPREFIX() + (((CharSequence)className).length() > 0 ? className + '.' + testName : testName);
            InstrumentationResults.INSTANCE.instrumentationReport((Function1<? super InstrumentationResultScope, Unit>)((Function1)new Function1<InstrumentationResultScope, Unit>(fullTestName, report){
                final /* synthetic */ String $fullTestName;
                final /* synthetic */ BenchmarkResult $report;
                {
                    this.$fullTestName = $fullTestName;
                    this.$report = $report;
                    super(1);
                }

                public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    InstrumentationResultScope.ideSummaryRecord$default($this$instrumentationReport, InstrumentationResults.INSTANCE.ideSummaryLineWrapped$benchmark_common_release(this.$fullTestName, this.$report.getMetricResult("timeNs").getMin(), null, null, null), null, 2, null);
                }
            }));
            ResultWriter.INSTANCE.appendReport(report);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.BINARY)
        @kotlin.annotation.Target(allowedTargets={AnnotationTarget.FUNCTION})
        @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
        @Target(value={ElementType.METHOD})
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/benchmark/BenchmarkState$Companion$ExperimentalExternalReport;", "", "benchmark-common_release"})
        @RequiresOptIn
        public static @interface ExperimentalExternalReport {
        }
    }
}

