/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.content.IntentFilter;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.benchmark.ConfigurationError;
import androidx.benchmark.ConfigurationErrorKt;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/DeviceInfo;", "", "()V", "MINIMUM_BATTERY_PERCENT", "", "deviceSummaryString", "", "getDeviceSummaryString", "()Ljava/lang/String;", "errors", "", "Landroidx/benchmark/ConfigurationError;", "getErrors", "()Ljava/util/List;", "initialBatteryPercent", "getInitialBatteryPercent", "()I", "isEmulator", "", "()Z", "isEngBuild", "isRooted", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDeviceInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceInfo.kt\nandroidx/benchmark/DeviceInfo\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,137:1\n12744#2,2:138\n*S KotlinDebug\n*F\n+ 1 DeviceInfo.kt\nandroidx/benchmark/DeviceInfo\n*L\n54#1:138,2\n*E\n"})
public final class DeviceInfo {
    @NotNull
    public static final DeviceInfo INSTANCE;
    private static final boolean isEmulator;
    private static final boolean isEngBuild;
    private static final boolean isRooted;
    public static final int MINIMUM_BATTERY_PERCENT = 25;
    private static final int initialBatteryPercent;
    @NotNull
    private static final String deviceSummaryString;
    @NotNull
    private static final List<ConfigurationError> errors;

    private DeviceInfo() {
    }

    public final boolean isEmulator() {
        return isEmulator;
    }

    public final boolean isEngBuild() {
        return isEngBuild;
    }

    public final boolean isRooted() {
        return isRooted;
    }

    public final int getInitialBatteryPercent() {
        return initialBatteryPercent;
    }

    @NotNull
    public final String getDeviceSummaryString() {
        return deviceSummaryString;
    }

    @NotNull
    public final List<ConfigurationError> getErrors() {
        return errors;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block7: {
            block8: {
                DeviceInfo.INSTANCE = new DeviceInfo();
                v0 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)v0, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v1 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)v1, (String)"unknown", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v2 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"FINGERPRINT");
                if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v3 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v4 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v4, (CharSequence)"sdk_gphone64", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v5 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v5, (CharSequence)"Emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v6 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v6, (CharSequence)"Android SDK built for", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v7 = Build.MANUFACTURER;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"MANUFACTURER");
                if (StringsKt.contains$default((CharSequence)v7, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v8 = Build.BRAND;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"BRAND");
                if (!StringsKt.startsWith$default((String)v8, (String)"generic", (boolean)false, (int)2, null)) break block8;
                v9 = Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"DEVICE");
                if (StringsKt.startsWith$default((String)v9, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            }
            if (Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) lbl-1000:
            // 10 sources

            {
                v10 = true;
            } else {
                v10 = false;
            }
            DeviceInfo.isEmulator = v10;
            v11 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"FINGERPRINT");
            DeviceInfo.isEngBuild = StringsKt.contains$default((CharSequence)v11, (CharSequence)":eng/", (boolean)false, (int)2, null);
            v12 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"FINGERPRINT");
            if (StringsKt.contains$default((CharSequence)v12, (CharSequence)":userdebug/", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var0 = new String[]{"/system/app/Superuser.apk", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su", "/su/bin/su"};
            $this$any$iv = var0;
            $i$f$any = false;
            var3_5 = $this$any$iv.length;
            for (var2_3 = 0; var2_3 < var3_5; ++var2_3) {
                it = element$iv = $this$any$iv[var2_3];
                $i$a$-any-DeviceInfo$isRooted$1 = false;
                if (!new File(it).exists()) continue;
                v13 = true;
                break block7;
            }
            v13 = false;
        }
        if (v13) lbl-1000:
        // 2 sources

        {
            v14 = true;
        } else {
            v14 = false;
        }
        DeviceInfo.isRooted = v14;
        context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        v15 = context.registerReceiver(null, filter);
        if (v15 != null) {
            $this$_init__u24lambda_u241 = v15;
            $i$a$-run-DeviceInfo$1 = false;
            level = $this$_init__u24lambda_u241.getBooleanExtra("present", true) != false ? $this$_init__u24lambda_u241.getIntExtra("level", 100) : 100;
            scale = $this$_init__u24lambda_u241.getIntExtra("scale", 100);
            v16 = level * 100 / scale;
        } else {
            v16 = 100;
        }
        DeviceInfo.initialBatteryPercent = v16;
        DeviceInfo.deviceSummaryString = "DeviceInfo(Brand=" + Build.BRAND + ", Model=" + Build.MODEL + ", SDK=" + Build.VERSION.SDK_INT + ", BuildFp=" + Build.FINGERPRINT + ')';
        var2_4 = new ConfigurationError[3];
        var2_4[0] = ConfigurationErrorKt.conditionalError(DeviceInfo.isEngBuild, "ENG-BUILD", "Running on Eng Build", "Benchmark is running on device flashed with a '-eng' build. Eng builds\nof the platform drastically reduce performance to enable testing\nchanges quickly. For this reason they should not be used for\nbenchmarking. Use a '-user' or '-userdebug' system image.");
        var2_4[1] = ConfigurationErrorKt.conditionalError(DeviceInfo.isEmulator, "EMULATOR", "Running on Emulator", "Benchmark is running on an emulator, which is not representative of\nreal user devices. Use a physical device to benchmark. Emulator\nbenchmark improvements might not carry over to a real user's\nexperience (or even regress real device performance).");
        var2_4[2] = ConfigurationErrorKt.conditionalError(DeviceInfo.initialBatteryPercent < 25, "LOW-BATTERY", "Device has low battery (" + DeviceInfo.initialBatteryPercent + ')', StringsKt.trimIndent((String)("\n                    When battery is low, devices will often reduce performance (e.g. disabling big\n                    cores) to save remaining battery. This occurs even when they are plugged in.\n                    Wait for your battery to charge to at least 25%.\n                    Currently at " + DeviceInfo.initialBatteryPercent + "%.\n                ")));
        DeviceInfo.errors = CollectionsKt.listOfNotNull((Object[])var2_4);
    }
}

