/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.benchmark.MetricNameUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\r\u0010*\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020\u0010H\u0016J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0003J\u0016\u00102\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000eR\u0011\u0010\u001f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000eR\u0011\u0010!\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u0011\u0010#\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u0011\u0010%\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000e\u00a8\u00064"}, d2={"Landroidx/benchmark/MetricResult;", "", "name", "", "data", "", "", "iterationData", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getData", "()Ljava/util/List;", "getIterationData", "max", "getMax", "()D", "maxIndex", "", "getMaxIndex", "()I", "median", "getMedian", "medianIndex", "getMedianIndex", "min", "getMin", "minIndex", "getMinIndex", "getName", "()Ljava/lang/String;", "p50", "getP50", "p90", "getP90", "p95", "getP95", "p99", "getP99", "standardDeviation", "getStandardDeviation", "equals", "", "other", "getSummary", "getSummary$benchmark_common_release", "hashCode", "putInBundle", "", "status", "Landroid/os/Bundle;", "prefix", "putPercentilesInBundle", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nMetricResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricResult.kt\nandroidx/benchmark/MetricResult\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1#2:148\n350#3,7:149\n350#3,7:156\n1549#3:163\n1620#3,3:164\n*S KotlinDebug\n*F\n+ 1 MetricResult.kt\nandroidx/benchmark/MetricResult\n*L\n64#1:149,7\n65#1:156,7\n71#1:163\n71#1:164,3\n*E\n"})
public final class MetricResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Double> data;
    @Nullable
    private final List<List<Double>> iterationData;
    private final double median;
    private final int medianIndex;
    private final double min;
    private final int minIndex;
    private final double max;
    private final int maxIndex;
    private final double standardDeviation;
    private final double p50;
    private final double p90;
    private final double p95;
    private final double p99;

    /*
     * WARNING - void declaration
     */
    public MetricResult(@NotNull String name, @NotNull List<Double> data, @Nullable List<? extends List<Double>> iterationData) {
        double d;
        int n;
        int n2;
        MetricResult metricResult;
        double mean;
        int size;
        List values;
        block9: {
            int n3;
            boolean bl;
            double it;
            List<Double> $this$indexOfFirst$iv;
            int index$iv;
            boolean $i$f$indexOfFirst;
            block8: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                this.name = name;
                this.data = data;
                this.iterationData = iterationData;
                values = CollectionsKt.sorted((Iterable)this.data);
                size = values.size();
                if (!(size >= 1)) {
                    boolean bl2 = false;
                    String string = "At least one result is necessary.";
                    throw new IllegalArgumentException(string.toString());
                }
                mean = CollectionsKt.averageOfDouble((Iterable)this.data);
                this.min = ((Number)CollectionsKt.first((List)values)).doubleValue();
                this.max = ((Number)CollectionsKt.last((List)values)).doubleValue();
                this.median = Companion.getPercentile(values, 50);
                this.p50 = Companion.getPercentile(values, 50);
                this.p90 = Companion.getPercentile(values, 90);
                this.p95 = Companion.getPercentile(values, 95);
                this.p99 = Companion.getPercentile(values, 99);
                List<Double> list = this.data;
                metricResult = this;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object e : $this$indexOfFirst$iv) {
                    it = ((Number)e).doubleValue();
                    bl = false;
                    if (it == this.min) {
                        n3 = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            metricResult.minIndex = n2 = n3;
            $this$indexOfFirst$iv = this.data;
            metricResult = this;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            for (Object object : $this$indexOfFirst$iv) {
                it = ((Number)object).doubleValue();
                bl = false;
                if (it == this.max) {
                    n = index$iv;
                    break block9;
                }
                ++index$iv;
            }
            n = -1;
        }
        metricResult.maxIndex = n2 = n;
        this.medianIndex = this.data.size() / 2;
        MetricResult metricResult2 = this;
        if (this.data.size() == 1) {
            d = 0.0;
        } else {
            void $this$map$iv;
            Iterable index$iv = values;
            metricResult = metricResult2;
            boolean $i$f$map = false;
            void var12_20 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : var12_20) {
                void it;
                double d2 = ((Number)item$iv$iv).doubleValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Math.pow((double)(it - mean), 2));
            }
            metricResult2 = metricResult;
            double sum = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
            d = Math.sqrt(sum / (double)(size - 1));
        }
        metricResult2.standardDeviation = d;
    }

    public /* synthetic */ MetricResult(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = null;
        }
        this(string, list, list2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Double> getData() {
        return this.data;
    }

    @Nullable
    public final List<List<Double>> getIterationData() {
        return this.iterationData;
    }

    public final double getMedian() {
        return this.median;
    }

    public final int getMedianIndex() {
        return this.medianIndex;
    }

    public final double getMin() {
        return this.min;
    }

    public final int getMinIndex() {
        return this.minIndex;
    }

    public final double getMax() {
        return this.max;
    }

    public final int getMaxIndex() {
        return this.maxIndex;
    }

    public final double getStandardDeviation() {
        return this.standardDeviation;
    }

    public final double getP50() {
        return this.p50;
    }

    public final double getP90() {
        return this.p90;
    }

    public final double getP95() {
        return this.p95;
    }

    public final double getP99() {
        return this.p99;
    }

    @NotNull
    public final String getSummary$benchmark_common_release() {
        return "Metric (" + this.name + ") results: median " + this.median + ", min " + this.min + ", max " + this.max + ", standardDeviation: " + this.standardDeviation;
    }

    public final void putInBundle(@NotNull Bundle status, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String bundleName = MetricNameUtilsKt.toOutputMetricName(this.name);
        status.putDouble(prefix2 + bundleName + "_min", this.min);
        status.putDouble(prefix2 + bundleName + "_median", this.median);
        status.putDouble(prefix2 + bundleName + "_stddev", this.standardDeviation);
    }

    public final void putPercentilesInBundle(@NotNull Bundle status, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String bundleName = MetricNameUtilsKt.toOutputMetricName(this.name);
        status.putDouble(prefix2 + bundleName + "_p50", this.p50);
        status.putDouble(prefix2 + bundleName + "_p90", this.p90);
        status.putDouble(prefix2 + bundleName + "_p95", this.p95);
        status.putDouble(prefix2 + bundleName + "_p99", this.p99);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.benchmark.MetricResult");
        MetricResult cfr_ignored_0 = (MetricResult)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((MetricResult)other).name)) {
            return false;
        }
        if (!(this.median == ((MetricResult)other).median)) {
            return false;
        }
        if (this.medianIndex != ((MetricResult)other).medianIndex) {
            return false;
        }
        if (!(this.min == ((MetricResult)other).min)) {
            return false;
        }
        if (this.minIndex != ((MetricResult)other).minIndex) {
            return false;
        }
        if (!(this.max == ((MetricResult)other).max)) {
            return false;
        }
        if (this.maxIndex != ((MetricResult)other).maxIndex) {
            return false;
        }
        return this.standardDeviation == ((MetricResult)other).standardDeviation;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Double.hashCode(this.median);
        result = 31 * result + this.medianIndex;
        result = 31 * result + Double.hashCode(this.min);
        result = 31 * result + this.minIndex;
        result = 31 * result + Double.hashCode(this.max);
        result = 31 * result + this.maxIndex;
        result = 31 * result + Double.hashCode(this.standardDeviation);
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bJ%\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Landroidx/benchmark/MetricResult$Companion;", "", "()V", "getPercentile", "", "sortedData", "", "percentile", "", "lerp", "a", "b", "ratio", "lerp$benchmark_common_release", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nMetricResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricResult.kt\nandroidx/benchmark/MetricResult$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final double lerp$benchmark_common_release(double a, double b, double ratio) {
            return a * (1.0 - ratio) + b * ratio;
        }

        public final double getPercentile(@NotNull List<Double> sortedData, int percentile) {
            Double d;
            Intrinsics.checkNotNullParameter(sortedData, (String)"sortedData");
            double idealIndex = (double)RangesKt.coerceIn((int)percentile, (int)0, (int)100) / 100.0 * (double)(sortedData.size() - 1);
            int firstIndex = (int)idealIndex;
            int secondIndex = firstIndex + 1;
            double firstValue = ((Number)sortedData.get(firstIndex)).doubleValue();
            List<Double> list = sortedData;
            if (secondIndex >= 0 && secondIndex <= CollectionsKt.getLastIndex(list)) {
                d = list.get(secondIndex);
            } else {
                int it = secondIndex;
                boolean bl = false;
                d = firstValue;
            }
            double secondValue = ((Number)d).doubleValue();
            return this.lerp$benchmark_common_release(firstValue, secondValue, idealIndex - (double)firstIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

