/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.os.Debug;
import android.util.Log;
import androidx.benchmark.Api21Kt;
import androidx.benchmark.Arguments;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\b\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"startRuntimeMethodTracing", "Landroidx/benchmark/Profiler$ResultFile;", "traceFileName", "", "sampled", "", "profiler", "Landroidx/benchmark/Profiler;", "stopRuntimeMethodTracing", "", "benchmark-common_release"})
public final class ProfilerKt {
    @NotNull
    public static final Profiler.ResultFile startRuntimeMethodTracing(@NotNull String traceFileName, boolean sampled, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)traceFileName, (String)"traceFileName");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        String path = Outputs.INSTANCE.testOutputFile(traceFileName).getAbsolutePath();
        Log.d((String)"Benchmark", (String)("Profiling output file: " + path));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        InstrumentationResults.reportAdditionalFileToCopy$default(InstrumentationResults.INSTANCE, "profiling_trace", path, false, 4, null);
        int bufferSize = 0x1000000;
        if (sampled && Build.VERSION.SDK_INT >= 21) {
            Api21Kt.startMethodTracingSampling(path, bufferSize, Arguments.INSTANCE.getProfilerSampleFrequency$benchmark_common_release());
        } else {
            Debug.startMethodTracing((String)path, (int)bufferSize, (int)0);
        }
        String string = sampled ? "Stack Sampling (legacy) Trace" : "Method Trace";
        return new Profiler.ResultFile(string, traceFileName, profiler);
    }

    public static final void stopRuntimeMethodTracing() {
        Debug.stopMethodTracing();
    }
}

