/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.BenchmarkResult;
import androidx.benchmark.CpuEventCounterCapture;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.Errors;
import androidx.benchmark.ExperimentalBenchmarkStateApi;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.MethodTracing;
import androidx.benchmark.MetricCapture;
import androidx.benchmark.MetricResult;
import androidx.benchmark.MetricsContainer;
import androidx.benchmark.MicrobenchmarkConfig;
import androidx.benchmark.MicrobenchmarkPhase;
import androidx.benchmark.Profiler;
import androidx.benchmark.ResultWriter;
import androidx.benchmark.ThreadPriority;
import androidx.benchmark.ThrottleDetector;
import androidx.benchmark.TimeCapture;
import androidx.benchmark.WarmupManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.RequiresOptIn;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 ]2\u00020\u0001:\u0001]B\u001f\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0013\b\u0017\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB5\b\u0010\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\fB\u000f\b\u0000\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020:H\u0002J\u001f\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020\u000b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020-0?H\u0082\bJ\b\u0010@\u001a\u00020:H\u0002J\b\u0010A\u001a\u00020:H\u0007J'\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020\u000b2\b\u0010F\u001a\u0004\u0018\u00010-H\u0000\u00a2\u0006\u0002\bGJ\t\u0010H\u001a\u00020\u0003H\u0087\bJ\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020J0%H\u0007J\b\u0010K\u001a\u00020JH\u0007J\r\u0010L\u001a\u00020MH\u0000\u00a2\u0006\u0002\bNJ\u0018\u0010L\u001a\u00020M2\u0006\u0010O\u001a\u00020-2\u0006\u0010P\u001a\u00020-H\u0002J\u0006\u0010Q\u001a\u00020\u000bJ\t\u0010R\u001a\u00020\u000bH\u0087\bJ\b\u0010S\u001a\u00020\u000bH\u0001J\b\u0010T\u001a\u00020\u000bH\u0002J\u0006\u0010U\u001a\u00020:J*\u0010V\u001a\u00020:2\u0006\u0010W\u001a\u00020-2\u0006\u0010X\u001a\u00020-2\u0006\u0010Y\u001a\u00020-2\b\u0010F\u001a\u0004\u0018\u00010-H\u0007J\u0006\u0010Z\u001a\u00020:J\b\u0010[\u001a\u00020\u000bH\u0002J\b\u0010\\\u001a\u00020:H\u0002R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\u0018R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001a\"\u0004\b8\u0010\u001c\u00a8\u0006^"}, d2={"Landroidx/benchmark/BenchmarkState;", "", "warmupCount", "", "repeatCount", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "config", "Landroidx/benchmark/MicrobenchmarkConfig;", "(Landroidx/benchmark/MicrobenchmarkConfig;)V", "measurementCount", "simplifiedTimingOnlyMode", "", "(Ljava/lang/Integer;Ljava/lang/Integer;ZLandroidx/benchmark/MicrobenchmarkConfig;)V", "phaseConfig", "Landroidx/benchmark/MicrobenchmarkPhase$Config;", "(Landroidx/benchmark/MicrobenchmarkPhase$Config;)V", "currentLoopsPerMeasurement", "currentMeasurement", "currentMetrics", "Landroidx/benchmark/MetricsContainer;", "currentPhase", "Landroidx/benchmark/MicrobenchmarkPhase;", "iterationsPerRepeat", "getIterationsPerRepeat$benchmark_common_release$annotations", "()V", "getIterationsPerRepeat$benchmark_common_release", "()I", "setIterationsPerRepeat$benchmark_common_release", "(I)V", "iterationsRemaining", "getIterationsRemaining$annotations", "metricResults", "", "Landroidx/benchmark/MetricResult;", "paused", "phaseIndex", "phases", "", "profilerResult", "Landroidx/benchmark/Profiler$ResultFile;", "thermalThrottleSleepSeconds", "", "totalRunTimeNs", "totalRunTimeStartNs", "<set-?>", "", "traceUniqueName", "getTraceUniqueName", "()Ljava/lang/String;", "setTraceUniqueName", "(Ljava/lang/String;)V", "warmupEstimatedIterationTimeNs", "warmupManager", "Landroidx/benchmark/WarmupManager;", "warmupRepeats", "getWarmupRepeats$benchmark_common_release", "setWarmupRepeats$benchmark_common_release", "afterBenchmark", "", "beforeBenchmark", "check", "value", "lazyMessage", "Lkotlin/Function0;", "checkFinished", "cleanupBeforeThrow", "getFullStatusReport", "Landroid/os/Bundle;", "key", "reportMetrics", "tracePath", "getFullStatusReport$benchmark_common_release", "getIterationsRemaining", "getMeasurementTimeNs", "", "getMinTimeNanos", "getReport", "Landroidx/benchmark/BenchmarkResult;", "getReport$benchmark_common_release", "testName", "className", "keepRunning", "keepRunningInline", "keepRunningInternal", "onMeasurementComplete", "pauseTiming", "report", "fullClassName", "simpleClassName", "methodName", "resumeTiming", "startNextPhase", "throwIfPaused", "Companion", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nBenchmarkState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,702:1\n404#1,5:707\n404#1,5:712\n404#1,5:717\n404#1,5:722\n404#1,5:727\n404#1,5:732\n404#1,5:737\n37#2,2:703\n223#3,2:705\n223#3,2:742\n1549#3:745\n1620#3,3:746\n1855#3,2:749\n1#4:744\n*S KotlinDebug\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState\n*L\n182#1:707,5\n185#1:712,5\n218#1:717,5\n248#1:722,5\n469#1:727,5\n475#1:732,5\n505#1:737,5\n102#1:703,2\n178#1:705,2\n522#1:742,2\n538#1:745\n538#1:746,3\n542#1:749,2\n*E\n"})
public final class BenchmarkState {
    @NotNull
    public static final Companion Companion;
    private final boolean simplifiedTimingOnlyMode;
    @NotNull
    private String traceUniqueName;
    private int warmupRepeats;
    @JvmField
    public int iterationsRemaining;
    private int iterationsPerRepeat;
    @NotNull
    private final WarmupManager warmupManager;
    private boolean paused;
    private long thermalThrottleSleepSeconds;
    private long totalRunTimeStartNs;
    private long totalRunTimeNs;
    private long warmupEstimatedIterationTimeNs;
    @NotNull
    private final List<MetricResult> metricResults;
    @Nullable
    private Profiler.ResultFile profilerResult;
    @NotNull
    private final List<MicrobenchmarkPhase> phases;
    private int phaseIndex;
    @NotNull
    private MicrobenchmarkPhase currentPhase;
    @NotNull
    private MetricsContainer currentMetrics;
    private int currentMeasurement;
    private int currentLoopsPerMeasurement;
    @NotNull
    public static final String TAG = "Benchmark";
    public static final int REPEAT_COUNT_ALLOCATION = 5;
    public static final int METHOD_TRACING_ESTIMATED_SLOWDOWN_FACTOR = 1000;
    public static final long METHOD_TRACING_MAX_DURATION_NS = 4000000000L;
    private static final long DEFAULT_MEASUREMENT_DURATION_NS;
    private static final long SAMPLED_PROFILER_DURATION_NS;
    private static boolean firstBenchmark;
    private static boolean enableMethodTracingAffectsMeasurementError;
    @NotNull
    private static final MetricCapture[] DEFAULT_METRICS;

    public BenchmarkState(@NotNull MicrobenchmarkPhase.Config phaseConfig) {
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        this.simplifiedTimingOnlyMode = phaseConfig.getSimplifiedTimingOnlyMode();
        this.traceUniqueName = "benchmark";
        this.iterationsRemaining = -1;
        this.iterationsPerRepeat = 1;
        this.warmupManager = phaseConfig.getWarmupManager();
        this.warmupEstimatedIterationTimeNs = -1L;
        this.metricResults = new ArrayList();
        this.phases = phaseConfig.generatePhases();
        this.phaseIndex = -1;
        this.currentPhase = this.phases.get(0);
        this.currentMetrics = this.phases.get(0).getMetricsContainer();
    }

    @ExperimentalBenchmarkStateApi
    public BenchmarkState(@Nullable Integer warmupCount, @Nullable Integer repeatCount) {
        this(warmupCount, repeatCount, false, null, 8, null);
    }

    public /* synthetic */ BenchmarkState(Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        this(n, n2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BenchmarkState(@Nullable MicrobenchmarkConfig config) {
        this(null, null, false, config, 2, null);
    }

    public /* synthetic */ BenchmarkState(MicrobenchmarkConfig microbenchmarkConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            microbenchmarkConfig = null;
        }
        this(microbenchmarkConfig);
    }

    public BenchmarkState(@Nullable Integer warmupCount, @Nullable Integer measurementCount, boolean simplifiedTimingOnlyMode, @Nullable MicrobenchmarkConfig config) {
        MetricCapture[] metricCaptureArray;
        Integer n;
        MetricCapture[] metricCaptureArray2;
        boolean bl;
        boolean bl2;
        block6: {
            block5: {
                Integer n2;
                bl2 = Arguments.INSTANCE.getDryRunMode();
                bl = Arguments.INSTANCE.getStartupMode$benchmark_common_release();
                MetricCapture[] metricCaptureArray3 = config;
                if (metricCaptureArray3 == null || (metricCaptureArray3 = metricCaptureArray3.getProfiler()) == null || (metricCaptureArray3 = metricCaptureArray3.getProfiler$benchmark_common_release()) == null) {
                    metricCaptureArray3 = metricCaptureArray2 = Arguments.INSTANCE.getProfiler$benchmark_common_release();
                }
                if ((n2 = Arguments.INSTANCE.getIterations$benchmark_common_release()) == null) {
                    n2 = n = measurementCount;
                }
                if ((metricCaptureArray = config) == null || (metricCaptureArray = metricCaptureArray.getMetrics()) == null) break block5;
                Collection $this$toTypedArray$iv = (Collection)metricCaptureArray;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                metricCaptureArray = thisCollection$iv.toArray(new MetricCapture[0]);
                if (metricCaptureArray != null) break block6;
            }
            metricCaptureArray = DEFAULT_METRICS;
        }
        MetricCapture[] metricCaptureArray4 = metricCaptureArray;
        this(new MicrobenchmarkPhase.Config(bl2, bl, simplifiedTimingOnlyMode, (Profiler)metricCaptureArray2, warmupCount, n, metricCaptureArray4));
    }

    public /* synthetic */ BenchmarkState(Integer n, Integer n2, boolean bl, MicrobenchmarkConfig microbenchmarkConfig, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            microbenchmarkConfig = null;
        }
        this(n, n2, bl, microbenchmarkConfig);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final String getTraceUniqueName() {
        return this.traceUniqueName;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void setTraceUniqueName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.traceUniqueName = string;
    }

    public final int getWarmupRepeats$benchmark_common_release() {
        return this.warmupRepeats;
    }

    public final void setWarmupRepeats$benchmark_common_release(int n) {
        this.warmupRepeats = n;
    }

    @PublishedApi
    public static /* synthetic */ void getIterationsRemaining$annotations() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getIterationsRemaining() {
        boolean $i$f$getIterationsRemaining = false;
        return this.iterationsRemaining;
    }

    public final int getIterationsPerRepeat$benchmark_common_release() {
        return this.iterationsPerRepeat;
    }

    public final void setIterationsPerRepeat$benchmark_common_release(int n) {
        this.iterationsPerRepeat = n;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIterationsPerRepeat$benchmark_common_release$annotations() {
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final double getMinTimeNanos() {
        Object element$iv2;
        block1: {
            this.checkFinished();
            Iterable $this$first$iv = this.metricResults;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((MetricResult)element$iv2).getMin();
    }

    private final void checkFinished() {
        BenchmarkState this_$iv;
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.phaseIndex >= 0;
        boolean $i$f$check = false;
        if (!value$iv) {
            this_$iv.cleanupBeforeThrow();
            boolean bl = false;
            String string = "Attempting to interact with a benchmark that wasn't started!";
            throw new IllegalStateException(string);
        }
        this_$iv = this;
        value$iv = this.phaseIndex >= this.phases.size();
        $i$f$check = false;
        if (!value$iv) {
            this_$iv.cleanupBeforeThrow();
            boolean bl = false;
            String string = "The benchmark hasn't finished! In Java, use while(BenchmarkState.keepRunning()) to ensure keepRunning() returns false before ending your test. In Kotlin, just use benchmarkRule.measureRepeated {} to avoid the problem.";
            throw new IllegalStateException(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void pauseTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            void this_$iv;
            this_$iv.cleanupBeforeThrow();
            boolean bl = false;
            String string = "Unable to pause the benchmark. The benchmark has already paused.";
            throw new IllegalStateException(string);
        }
        this.currentMetrics.capturePaused();
        this.paused = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void resumeTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            void this_$iv;
            this_$iv.cleanupBeforeThrow();
            boolean bl = false;
            String string = "Unable to resume the benchmark. The benchmark is already running.";
            throw new IllegalStateException(string);
        }
        this.currentMetrics.captureResumed();
        this.paused = false;
    }

    private final boolean startNextPhase() {
        Profiler.ResultFile phaseProfilerResult;
        Profiler.ResultFile resultFile;
        if (!(this.phaseIndex < this.phases.size())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (this.phaseIndex >= 0) {
            Profiler profiler = this.currentPhase.getProfiler();
            if (profiler != null) {
                profiler.stop();
            }
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
            this.thermalThrottleSleepSeconds += this.currentPhase.getThermalThrottleSleepSeconds();
            if (this.currentPhase.getLoopMode().getWarmupManager() == null && this.currentPhase.getProfiler() == null) {
                this.metricResults.addAll((Collection<MetricResult>)this.currentMetrics.captureFinished(this.currentLoopsPerMeasurement));
            }
        }
        int n = this.phaseIndex;
        this.phaseIndex = n + 1;
        if (this.phaseIndex == this.phases.size()) {
            this.afterBenchmark();
            return false;
        }
        this.currentPhase = this.phases.get(this.phaseIndex);
        this.currentMetrics = this.currentPhase.getMetricsContainer();
        this.currentMeasurement = 0;
        this.currentMetrics.captureInit();
        if (this.currentPhase.getGcBeforePhase()) {
            Runtime.getRuntime().gc();
        }
        this.currentLoopsPerMeasurement = this.currentPhase.getLoopMode().getIterations(this.warmupEstimatedIterationTimeNs);
        this.iterationsPerRepeat = RangesKt.coerceAtLeast((int)this.iterationsPerRepeat, (int)this.currentLoopsPerMeasurement);
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, this.currentPhase.getLabel(), 0L, 2, null);
        Profiler profiler = this.currentPhase.getProfiler();
        if (profiler != null) {
            Profiler $this$startNextPhase_u24lambda_u245 = profiler;
            boolean bl = false;
            long estimatedMethodTraceDurNs = this.warmupEstimatedIterationTimeNs * (long)1000;
            if (Intrinsics.areEqual((Object)$this$startNextPhase_u24lambda_u245, (Object)MethodTracing.INSTANCE) && Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper()) && estimatedMethodTraceDurNs > 4000000000L) {
                InstrumentationResults.INSTANCE.scheduleIdeWarningOnNextReport("Skipping method trace of estimated duration " + (double)estimatedMethodTraceDurNs / 1.0E9 + " sec to avoid ANR");
                resultFile = null;
            } else {
                resultFile = $this$startNextPhase_u24lambda_u245.start(this.traceUniqueName);
            }
        } else {
            resultFile = phaseProfilerResult = null;
        }
        if (phaseProfilerResult != null) {
            if (!(this.profilerResult == null)) {
                boolean bl = false;
                String string = "ProfileResult already set, only support one profiling phase";
                throw new IllegalArgumentException(string.toString());
            }
            this.profilerResult = phaseProfilerResult;
        }
        this.currentMetrics.captureStart();
        return true;
    }

    private final boolean onMeasurementComplete() {
        boolean bl;
        boolean tryStartNextPhase;
        boolean bl2;
        this.currentMetrics.captureStop();
        this.throwIfPaused();
        int n = this.currentMeasurement;
        this.currentMeasurement = n + 1;
        MicrobenchmarkPhase.LoopMode it = this.currentPhase.getLoopMode();
        boolean bl3 = false;
        if (it.getWarmupManager() != null) {
            this.currentMetrics.captureInit();
            long lastMeasuredWarmupValue = this.currentMetrics.peekSingleRepeatTime();
            if (it.getWarmupManager().onNextIteration(lastMeasuredWarmupValue)) {
                this.warmupEstimatedIterationTimeNs = lastMeasuredWarmupValue;
                this.warmupRepeats = this.currentMeasurement;
                bl2 = true;
            } else {
                bl2 = false;
            }
        } else {
            bl2 = this.currentMeasurement == this.currentPhase.getMeasurementCount();
        }
        if (tryStartNextPhase = bl2) {
            if (this.currentPhase.tryEnd()) {
                bl = this.startNextPhase();
            } else {
                Profiler profiler = this.currentPhase.getProfiler();
                if (profiler != null) {
                    Profiler profiler2;
                    Profiler $this$onMeasurementComplete_u24lambda_u248 = profiler2 = profiler;
                    boolean bl4 = false;
                    $this$onMeasurementComplete_u24lambda_u248.stop();
                    this.profilerResult = $this$onMeasurementComplete_u24lambda_u248.start(this.traceUniqueName);
                }
                this.currentMetrics.captureInit();
                this.currentMeasurement = 0;
                bl = true;
            }
        } else {
            this.currentMetrics.captureStart();
            bl = true;
        }
        return bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean keepRunningInline() {
        boolean $i$f$keepRunningInline = false;
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    public final boolean keepRunning() {
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    private final void check(boolean value, Function0<String> lazyMessage) {
        boolean $i$f$check = false;
        if (!value) {
            this.cleanupBeforeThrow();
            throw new IllegalStateException((String)lazyMessage.invoke());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void cleanupBeforeThrow() {
        if (this.phaseIndex >= 0 && this.phaseIndex <= this.phases.size()) {
            Log.d((String)TAG, (String)"aborting and cancelling benchmark");
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
            Profiler profiler = this.currentPhase.getProfiler();
            if (profiler != null) {
                profiler.stop();
            }
            this.phaseIndex = this.phases.size();
            this.afterBenchmark();
        }
    }

    @PublishedApi
    public final boolean keepRunningInternal() {
        boolean bl;
        if (this.phaseIndex == -1) {
            this.beforeBenchmark();
            bl = this.startNextPhase();
        } else {
            bl = this.onMeasurementComplete();
        }
        boolean shouldKeepRunning = bl;
        this.iterationsRemaining = this.currentLoopsPerMeasurement;
        return shouldKeepRunning;
    }

    private final void beforeBenchmark() {
        BenchmarkState this_$iv;
        Errors.INSTANCE.throwIfError();
        if (!firstBenchmark && Arguments.INSTANCE.getStartupMode$benchmark_common_release()) {
            throw new AssertionError((Object)"Error - multiple benchmarks in startup mode. Only one benchmark may be run per 'am instrument' call, to ensure result isolation.");
        }
        BenchmarkState benchmarkState = this;
        boolean value$iv = DeviceInfo.INSTANCE.getArtMainlineVersion() != -100L;
        boolean $i$f$check = false;
        if (!value$iv) {
            this_$iv.cleanupBeforeThrow();
            boolean bl = false;
            String string = "Unable to detect ART mainline module version to check for interference from method tracing, please see logcat for details, and/or file a bug with logcat.";
            throw new IllegalStateException(string);
        }
        this_$iv = this;
        value$iv = !enableMethodTracingAffectsMeasurementError || !DeviceInfo.INSTANCE.getMethodTracingAffectsMeasurements() || !MethodTracing.INSTANCE.getHasBeenUsed();
        $i$f$check = false;
        if (!value$iv) {
            this_$iv.cleanupBeforeThrow();
            boolean bl = false;
            String string = "Measurement prevented by method trace - Running on a device/configuration where method tracing affects measurements, and a method trace has been captured - no additional benchmarks can be run without restarting the test suite.";
            throw new IllegalStateException(string);
        }
        this.thermalThrottleSleepSeconds = 0L;
        if (!this.simplifiedTimingOnlyMode) {
            ThrottleDetector.INSTANCE.computeThrottleBaselineIfNeeded();
            ThreadPriority.INSTANCE.bumpCurrentThreadPriority();
        }
        this.totalRunTimeStartNs = System.nanoTime();
    }

    private final void afterBenchmark() {
        this.totalRunTimeNs = System.nanoTime() - this.totalRunTimeStartNs;
        if (!this.simplifiedTimingOnlyMode) {
            ThreadPriority.INSTANCE.resetBumpedThread();
        }
        this.warmupManager.logInfo();
    }

    /*
     * WARNING - void declaration
     */
    private final void throwIfPaused() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            void this_$iv;
            this_$iv.cleanupBeforeThrow();
            boolean bl = false;
            String string = "Benchmark loop finished in paused state. Call BenchmarkState.resumeTiming() before BenchmarkState.keepRunning().";
            throw new IllegalStateException(string);
        }
    }

    private final BenchmarkResult getReport(String testName, String className) {
        return new BenchmarkResult(className, testName, this.totalRunTimeNs, this.metricResults, this.iterationsPerRepeat, this.thermalThrottleSleepSeconds, this.warmupRepeats);
    }

    @ExperimentalBenchmarkStateApi
    @NotNull
    public final List<Double> getMeasurementTimeNs() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.metricResults;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((MetricResult)element$iv2).getData();
    }

    @NotNull
    public final BenchmarkResult getReport$benchmark_common_release() {
        this.checkFinished();
        Unit $this$getReport_u24lambda_u2413 = Unit.INSTANCE;
        boolean bl = false;
        return this.getReport("", "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bundle getFullStatusReport$benchmark_common_release(@NotNull String key, boolean reportMetrics, @Nullable String tracePath) {
        Profiler.ResultFile resultFile;
        Object[] objectArray;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Iterable iterable = this.metricResults;
        StringBuilder stringBuilder = new StringBuilder().append(key);
        Object object2 = TAG;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MetricResult metricResult = (MetricResult)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getSummary$benchmark_common_release());
        }
        object = (List)destination$iv$iv;
        Log.i((String)object2, (String)stringBuilder.append(object).append("count=").append(this.iterationsPerRepeat).toString());
        Bundle status = new Bundle();
        if (reportMetrics) {
            Iterable $this$forEach$iv = this.metricResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetricResult it = (MetricResult)element$iv;
                boolean bl = false;
                it.putInBundle(status, Errors.INSTANCE.getPREFIX());
            }
        }
        Object object3 = new InstrumentationResultScope(status);
        StringBuilder stringBuilder2 = null;
        Object object4 = key;
        String string = null;
        BenchmarkResult.Measurements measurements = new BenchmarkResult.Measurements(this.metricResults, CollectionsKt.emptyList());
        List list = null;
        Object[] objectArray2 = objectArray = new Profiler.ResultFile[2];
        int n = 0;
        String string2 = tracePath;
        if (string2 != null) {
            destination$iv$iv = string2;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            List list2 = list;
            BenchmarkResult.Measurements measurements2 = measurements;
            String string3 = string;
            object = object4;
            stringBuilder = stringBuilder2;
            object2 = object3;
            boolean bl = false;
            Profiler.ResultFile resultFile2 = new Profiler.ResultFile("Trace", tracePath);
            object3 = object2;
            stringBuilder2 = stringBuilder;
            object4 = object;
            string = string3;
            measurements = measurements2;
            list = list2;
            objectArray2 = objectArray3;
            n = n2;
            resultFile = resultFile2;
        } else {
            resultFile = null;
        }
        objectArray2[n] = resultFile;
        objectArray[1] = this.profilerResult;
        InstrumentationResultScope.reportSummaryToIde$default((InstrumentationResultScope)object3, stringBuilder2, (String)object4, string, measurements, list, CollectionsKt.listOfNotNull((Object[])objectArray), 21, null);
        return status;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void report(@NotNull String fullClassName, @NotNull String simpleClassName, @NotNull String methodName, @Nullable String tracePath) {
        Intrinsics.checkNotNullParameter((Object)fullClassName, (String)"fullClassName");
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        if (this.phaseIndex == -1) {
            return;
        }
        if (tracePath != null) {
            Profiler.ResultFile resultFile = this.profilerResult;
            if (resultFile != null) {
                resultFile.embedInPerfettoTrace(tracePath);
            }
        }
        this.checkFinished();
        String fullTestName = Errors.INSTANCE.getPREFIX() + simpleClassName + '.' + methodName;
        Bundle bundle = this.getFullStatusReport$benchmark_common_release(fullTestName, !Arguments.INSTANCE.getDryRunMode(), tracePath);
        InstrumentationResults.INSTANCE.reportBundle$benchmark_common_release(bundle);
        ResultWriter.INSTANCE.appendReport(this.getReport(Errors.INSTANCE.getPREFIX() + methodName, fullClassName));
    }

    @JvmStatic
    @Companion.ExperimentalExternalReport
    public static final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
        Companion.reportData(className, testName, totalRunTimeNs, dataNs, warmupIterations, thermalThrottleSleepSeconds, repeatIterations);
    }

    static {
        MetricCapture[] metricCaptureArray;
        Companion = new Companion(null);
        DEFAULT_MEASUREMENT_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(100L);
        SAMPLED_PROFILER_DURATION_NS = TimeUnit.SECONDS.toNanos(Arguments.INSTANCE.getProfilerSampleDurationSeconds$benchmark_common_release());
        firstBenchmark = true;
        if (Arguments.INSTANCE.getCpuEventCounterMask$benchmark_common_release() != 0) {
            MetricCapture[] metricCaptureArray2 = new MetricCapture[]{new TimeCapture(), new CpuEventCounterCapture(MicrobenchmarkPhase.Companion.getCpuEventCounter$benchmark_common_release(), Arguments.INSTANCE.getCpuEventCounterMask$benchmark_common_release())};
            metricCaptureArray = metricCaptureArray2;
        } else {
            MetricCapture[] metricCaptureArray3 = new MetricCapture[]{new TimeCapture()};
            metricCaptureArray = metricCaptureArray3;
        }
        DEFAULT_METRICS = metricCaptureArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\b\b\u0001\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 2\b\b\u0001\u0010!\u001a\u00020\f2\b\b\u0001\u0010\"\u001a\u00020\u00042\b\b\u0001\u0010#\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\u0012X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/benchmark/BenchmarkState$Companion;", "", "()V", "DEFAULT_MEASUREMENT_DURATION_NS", "", "getDEFAULT_MEASUREMENT_DURATION_NS$benchmark_common_release", "()J", "DEFAULT_METRICS", "", "Landroidx/benchmark/MetricCapture;", "[Landroidx/benchmark/MetricCapture;", "METHOD_TRACING_ESTIMATED_SLOWDOWN_FACTOR", "", "METHOD_TRACING_MAX_DURATION_NS", "REPEAT_COUNT_ALLOCATION", "SAMPLED_PROFILER_DURATION_NS", "getSAMPLED_PROFILER_DURATION_NS$benchmark_common_release", "TAG", "", "enableMethodTracingAffectsMeasurementError", "", "getEnableMethodTracingAffectsMeasurementError$benchmark_common_release", "()Z", "setEnableMethodTracingAffectsMeasurementError$benchmark_common_release", "(Z)V", "firstBenchmark", "reportData", "", "className", "testName", "totalRunTimeNs", "dataNs", "", "warmupIterations", "thermalThrottleSleepSeconds", "repeatIterations", "ExperimentalExternalReport", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nBenchmarkState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,702:1\n1864#2,3:703\n*S KotlinDebug\n*F\n+ 1 BenchmarkState.kt\nandroidx/benchmark/BenchmarkState$Companion\n*L\n674#1:703,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_MEASUREMENT_DURATION_NS$benchmark_common_release() {
            return DEFAULT_MEASUREMENT_DURATION_NS;
        }

        public final long getSAMPLED_PROFILER_DURATION_NS$benchmark_common_release() {
            return SAMPLED_PROFILER_DURATION_NS;
        }

        public final boolean getEnableMethodTracingAffectsMeasurementError$benchmark_common_release() {
            return enableMethodTracingAffectsMeasurementError;
        }

        public final void setEnableMethodTracingAffectsMeasurementError$benchmark_common_release(boolean bl) {
            enableMethodTracingAffectsMeasurementError = bl;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @ExperimentalExternalReport
        public final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter(dataNs, (String)"dataNs");
            MetricsContainer metricsContainer = new MetricsContainer(null, dataNs.size(), 1, null);
            Iterable $this$forEachIndexed$iv = dataNs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                long l = ((Number)item$iv).longValue();
                int index = n;
                boolean bl = false;
                metricsContainer.getData$benchmark_common_release().get((int)index)[0] = value;
            }
            BenchmarkResult report = new BenchmarkResult(className, testName, totalRunTimeNs, metricsContainer.captureFinished(1), repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
            String fullTestName = Errors.INSTANCE.getPREFIX() + (((CharSequence)className).length() > 0 ? className + '.' + testName : testName);
            InstrumentationResults.INSTANCE.instrumentationReport((Function1<? super InstrumentationResultScope, Unit>)((Function1)new Function1<InstrumentationResultScope, Unit>(fullTestName, report){
                final /* synthetic */ String $fullTestName;
                final /* synthetic */ BenchmarkResult $report;
                {
                    this.$fullTestName = $fullTestName;
                    this.$report = $report;
                    super(1);
                }

                public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    InstrumentationResultScope.reportSummaryToIde$default($this$instrumentationReport, null, this.$fullTestName, null, this.$report.getMetrics(), null, null, 53, null);
                }
            }));
            ResultWriter.INSTANCE.appendReport(report);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.BINARY)
        @kotlin.annotation.Target(allowedTargets={AnnotationTarget.FUNCTION})
        @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
        @Target(value={ElementType.METHOD})
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/benchmark/BenchmarkState$Companion$ExperimentalExternalReport;", "", "benchmark-common_release"})
        @RequiresOptIn
        public static @interface ExperimentalExternalReport {
        }
    }
}

