/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Api21Kt;
import androidx.benchmark.Arguments;
import androidx.benchmark.FileMover;
import androidx.benchmark.InstrumentationResults;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0012J;\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\b2!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\"0\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/benchmark/Outputs;", "", "()V", "dirUsableByAppAndShell", "Ljava/io/File;", "getDirUsableByAppAndShell", "()Ljava/io/File;", "forceFilesForShellAccessible", "", "getForceFilesForShellAccessible", "()Z", "formatter", "Ljava/text/SimpleDateFormat;", "outputDirectory", "getOutputDirectory", "sanitizerRegex", "Lkotlin/text/Regex;", "dateToFileName", "", "date", "Ljava/util/Date;", "relativePathFor", "path", "sanitizeFilename", "filename", "testOutputFile", "writeFile", "fileName", "reportOnRunEndOnly", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nOutputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Outputs.kt\nandroidx/benchmark/Outputs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,191:1\n1#2:192\n1855#3:193\n1856#3:196\n13579#4,2:194\n*S KotlinDebug\n*F\n+ 1 Outputs.kt\nandroidx/benchmark/Outputs\n*L\n107#1:193\n107#1:196\n108#1:194,2\n*E\n"})
public final class Outputs {
    @NotNull
    public static final Outputs INSTANCE;
    @NotNull
    private static final SimpleDateFormat formatter;
    @NotNull
    private static final Regex sanitizerRegex;
    @NotNull
    private static final File outputDirectory;
    @NotNull
    private static final File dirUsableByAppAndShell;
    private static final boolean forceFilesForShellAccessible;

    private Outputs() {
    }

    @NotNull
    public final File getOutputDirectory() {
        return outputDirectory;
    }

    @NotNull
    public final File getDirUsableByAppAndShell() {
        return dirUsableByAppAndShell;
    }

    public final boolean getForceFilesForShellAccessible() {
        return forceFilesForShellAccessible;
    }

    @NotNull
    public final String writeFile(@NotNull String fileName, boolean reportOnRunEndOnly, @NotNull Function1<? super File, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String sanitizedName = this.sanitizeFilename(fileName);
        File destination = new File(outputDirectory, sanitizedName);
        File file = new File(dirUsableByAppAndShell, sanitizedName);
        block.invoke((Object)file);
        if (!file.exists()) {
            boolean bl = false;
            String string = "File doesn't exist!";
            throw new IllegalStateException(string.toString());
        }
        if (!Intrinsics.areEqual((Object)dirUsableByAppAndShell, (Object)outputDirectory)) {
            Log.d((String)"Benchmark", (String)("Moving " + file + " to " + destination));
            if (Build.VERSION.SDK_INT >= 27) {
                FileMover.INSTANCE.moveTo(file, destination, true);
            } else {
                FilesKt.copyTo$default((File)file, (File)destination, (boolean)true, (int)0, (int)4, null);
                file.delete();
            }
        }
        String string = destination.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destination.absolutePath");
        InstrumentationResults.INSTANCE.reportAdditionalFileToCopy(sanitizedName, string, reportOnRunEndOnly);
        String string2 = destination.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"destination.absolutePath");
        return string2;
    }

    public static /* synthetic */ String writeFile$default(Outputs outputs, String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return outputs.writeFile(string, bl, (Function1<? super File, Unit>)function1);
    }

    @NotNull
    public final String sanitizeFilename(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (!(filename.length() < 200)) {
            boolean bl = false;
            String string = "Filename too long (" + filename.length() + " > 200) " + filename + " - trim your test name, or parameterization string to avoid filename too long exceptions";
            throw new IllegalArgumentException(string.toString());
        }
        CharSequence charSequence = filename;
        Regex regex = sanitizerRegex;
        String string = "_";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public final File testOutputFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new File(outputDirectory, filename);
    }

    @NotNull
    public final String dateToFileName(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = formatter.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(date)");
        return string;
    }

    public static /* synthetic */ String dateToFileName$default(Outputs outputs, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date();
        }
        return outputs.dateToFileName(date);
    }

    @NotNull
    public final String relativePathFor(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = outputDirectory.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputDirectory.absolutePath");
        boolean hasOutputDirectoryPrefix = StringsKt.startsWith$default((String)path, (String)string, (boolean)false, (int)2, null);
        String relativePath = hasOutputDirectoryPrefix ? StringsKt.removePrefix((String)path, (CharSequence)(outputDirectory.getAbsolutePath() + '/')) : StringsKt.removePrefix((String)path, (CharSequence)(dirUsableByAppAndShell.getAbsolutePath() + '/'));
        if (!(!Intrinsics.areEqual((Object)relativePath, (Object)path))) {
            boolean bl = false;
            String string2 = relativePath + " == " + path;
            throw new IllegalStateException(string2.toString());
        }
        return relativePath;
    }

    static {
        File file;
        File file2;
        INSTANCE = new Outputs();
        formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        sanitizerRegex = new Regex("([^0-9a-zA-Z._-]+)");
        int n = Build.VERSION.SDK_INT;
        forceFilesForShellAccessible = 21 <= n ? n < 23 : false;
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Context context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        if (Build.VERSION.SDK_INT >= 29) {
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            file2 = Api21Kt.getFirstMountedMediaDir(context);
        } else {
            file2 = Build.VERSION.SDK_INT <= 22 ? context.getCacheDir() : context.getExternalCacheDir();
        }
        if (file2 == null) {
            throw new IllegalStateException("Unable to select a directory for writing files, additionalTestOutputDir argument required to declare output dir.");
        }
        dirUsableByAppAndShell = file2;
        if (forceFilesForShellAccessible) {
            dirUsableByAppAndShell.setReadable(true, false);
            dirUsableByAppAndShell.setWritable(true, false);
            dirUsableByAppAndShell.setExecutable(true, false);
        }
        Log.d((String)"Benchmark", (String)("Usable output directory: " + dirUsableByAppAndShell));
        String string = Arguments.INSTANCE.getAdditionalTestOutputDir$benchmark_common_release();
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = dirUsableByAppAndShell;
        }
        outputDirectory = file;
        Log.d((String)"Benchmark", (String)("Output Directory: " + outputDirectory));
        Object[] objectArray = new File[2];
        objectArray[0] = outputDirectory;
        objectArray[1] = dirUsableByAppAndShell;
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File[] fileArray;
            File it = (File)element$iv;
            boolean bl = false;
            if (fileArray == null) continue;
            fileArray = it.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles()");
            File[] $this$forEach$iv2 = fileArray;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (int i = 0; i < n2; ++i) {
                File element$iv2;
                File file3 = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (!file3.isFile()) continue;
                file3.delete();
            }
        }
        outputDirectory.mkdirs();
    }
}

