/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.os.Process;
import android.util.Log;
import androidx.annotation.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0013J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/ThreadPriority;", "", "()V", "BENCH_THREAD_PRIORITY", "", "HIGH_PRIORITY", "JIT_INITIAL_PRIORITY", "getJIT_INITIAL_PRIORITY", "()I", "JIT_THREAD_NAME", "", "JIT_THREAD_PRIORITY", "JIT_TID", "Ljava/lang/Integer;", "TASK_PATH", "initialPriority", "initialTid", "lock", "bumpCurrentThreadPriority", "", "get", "getJit", "resetBumpedThread", "setThreadPriority", "", "label", "tid", "priority", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nThreadPriority.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadPriority.kt\nandroidx/benchmark/ThreadPriority\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,170:1\n1#2:171\n8945#3,2:172\n9215#3,4:174\n515#4:178\n500#4,6:179\n215#5,2:185\n*S KotlinDebug\n*F\n+ 1 ThreadPriority.kt\nandroidx/benchmark/ThreadPriority\n*L\n50#1:172,2\n50#1:174,4\n72#1:178\n72#1:179,6\n75#1:185,2\n*E\n"})
public final class ThreadPriority {
    @NotNull
    public static final ThreadPriority INSTANCE = new ThreadPriority();
    public static final int HIGH_PRIORITY = -20;
    private static final int BENCH_THREAD_PRIORITY = -20;
    private static final int JIT_THREAD_PRIORITY = -15;
    @NotNull
    private static final String TASK_PATH = "/proc/self/task";
    @NotNull
    private static final String JIT_THREAD_NAME = "Jit thread pool";
    @Nullable
    private static final Integer JIT_TID;
    private static final int JIT_INITIAL_PRIORITY;
    @NotNull
    private static final Object lock;
    @GuardedBy(value="lock")
    private static int initialTid;
    @GuardedBy(value="lock")
    private static int initialPriority;

    private ThreadPriority() {
    }

    public final int getJIT_INITIAL_PRIORITY() {
        return JIT_INITIAL_PRIORITY;
    }

    private final boolean setThreadPriority(String label, int tid, int priority) {
        int n;
        try {
            n = Process.getThreadPriority((int)tid);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        int previousPriority = n;
        try {
            Process.setThreadPriority((int)tid, (int)priority);
        }
        catch (SecurityException e) {
            return false;
        }
        int newPriority = Process.getThreadPriority((int)tid);
        if (newPriority != previousPriority) {
            Log.d((String)"Benchmark", (String)("Set " + tid + " (" + label + ") to priority " + priority + ". Was " + previousPriority + ", now " + newPriority));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bumpCurrentThreadPriority() {
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            int myTid = Process.myTid();
            if (initialTid == myTid) {
                return;
            }
            INSTANCE.resetBumpedThread();
            initialTid = myTid;
            initialPriority = Process.getThreadPriority((int)initialTid);
            INSTANCE.setThreadPriority("Bench thread", initialTid, -20);
            if (JIT_TID != null) {
                INSTANCE.setThreadPriority("Jit", JIT_TID, -15);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetBumpedThread() {
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            if (initialTid > 0) {
                INSTANCE.setThreadPriority("Bench thread", initialTid, initialPriority);
                if (JIT_TID != null) {
                    INSTANCE.setThreadPriority("Jit", JIT_TID, JIT_INITIAL_PRIORITY);
                }
                initialTid = -1;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final int getJit() {
        if (JIT_TID == null) {
            boolean bl = false;
            String string = "Jit thread not found!";
            throw new IllegalStateException(string.toString());
        }
        return Process.getThreadPriority((int)JIT_TID);
    }

    public final int get() {
        return Process.getThreadPriority((int)Process.myTid());
    }

    /*
     * WARNING - void declaration
     */
    static {
        if (Build.VERSION.SDK_INT >= 24) {
            Map tidsToNames;
            Object object;
            Object destination$iv$iv;
            File[] fileArray = new File(TASK_PATH).listFiles();
            if (fileArray != null) {
                void $this$associateByTo$iv$iv;
                File[] $this$associateBy$iv = fileArray;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
                File[] fileArray2 = $this$associateBy$iv;
                destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                int n = ((void)$this$associateByTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    String string;
                    void it;
                    void element$iv$iv;
                    void var11_17 = element$iv$iv = $this$associateByTo$iv$iv[i];
                    Object object2 = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                    it = element$iv$iv;
                    Integer n2 = Integer.parseInt(string2);
                    boolean bl2 = false;
                    try {
                        String string3 = (String)CollectionsKt.firstOrNull((List)FilesKt.readLines$default((File)new File((File)it, "comm"), null, (int)1, null));
                        if (string3 == null) {
                            string3 = "";
                        }
                        string = string3;
                    }
                    catch (IOException e) {
                        string = "ERROR READING THREAD NAME";
                    }
                    String string4 = string;
                    object2.put(n2, string4);
                }
                object = destination$iv$iv;
            } else {
                object = null;
            }
            Map map = tidsToNames = object;
            if (map == null || map.isEmpty()) {
                Log.d((String)"Benchmark", (String)"NOTE: Couldn't find threads in this process for priority pinning.");
                JIT_TID = null;
            } else {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv = tidsToNames;
                boolean $i$f$filter = false;
                Map $i$f$associateBy = $this$filter$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                destination$iv$iv = $this$filterTo$iv$iv.entrySet().iterator();
                while (destination$iv$iv.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = (Map.Entry)destination$iv$iv.next();
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)((String)it.getValue()), (String)JIT_THREAD_NAME, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                JIT_TID = (Integer)CollectionsKt.firstOrNull((Iterable)destination$iv$iv2.keySet());
                if (JIT_TID == null) {
                    Log.d((String)"Benchmark", (String)"NOTE: Couldn't JIT thread, threads found:");
                    Map $this$forEach$iv = tidsToNames;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator.next();
                        boolean bl = false;
                        Log.d((String)"Benchmark", (String)("    tid: " + ((Number)it.getKey()).intValue() + ", name:'" + (String)it.getValue() + '\''));
                    }
                }
            }
        } else {
            JIT_TID = null;
        }
        JIT_INITIAL_PRIORITY = JIT_TID != null ? Process.getThreadPriority((int)JIT_TID) : 0;
        lock = new Object();
        initialTid = -1;
        initialPriority = Integer.MAX_VALUE;
    }
}

