/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.benchmark.ExperimentalBenchmarkConfigApi;
import androidx.benchmark.MetricCapture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J \u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/benchmark/TimeCapture;", "Landroidx/benchmark/MetricCapture;", "()V", "currentPausedStarted", "", "currentStarted", "currentTotalPaused", "capturePaused", "", "captureResumed", "captureStart", "timeNs", "captureStop", "output", "", "offset", "", "benchmark-common_release"})
@ExperimentalBenchmarkConfigApi
public final class TimeCapture
extends MetricCapture {
    private long currentStarted;
    private long currentPausedStarted;
    private long currentTotalPaused;

    public TimeCapture() {
        super(CollectionsKt.listOf((Object)"timeNs"));
    }

    @Override
    public void captureStart(long timeNs) {
        this.currentTotalPaused = 0L;
        this.currentStarted = timeNs;
    }

    @Override
    public void captureStop(long timeNs, @NotNull long[] output, int offset) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output[offset] = timeNs - this.currentStarted - this.currentTotalPaused;
    }

    @Override
    public void capturePaused() {
        this.currentPausedStarted = System.nanoTime();
    }

    @Override
    public void captureResumed() {
        this.currentTotalPaused += System.nanoTime() - this.currentPausedStarted;
    }
}

