/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Landroidx/benchmark/WarmupManager;", "", "overrideCount", "", "(Ljava/lang/Integer;)V", "estimatedIterationTimeNs", "", "getEstimatedIterationTimeNs", "()F", "fastMovingAvg", "<set-?>", "iteration", "getIteration", "()I", "getOverrideCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "similarIterationCount", "slowMovingAvg", "", "totalDurationNs", "getTotalDurationNs", "()J", "logInfo", "", "onNextIteration", "", "durationNs", "Companion", "benchmark-common_release"})
public final class WarmupManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer overrideCount;
    private float fastMovingAvg;
    private float slowMovingAvg;
    private int similarIterationCount;
    private int iteration;
    private long totalDurationNs;
    private static final long MIN_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(250L);
    private static final long MAX_DURATION_NS = TimeUnit.SECONDS.toNanos(8L);
    public static final int MIN_ITERATIONS = 30;
    private static final int MIN_SIMILAR_ITERATIONS = 40;
    private static final float FAST_RATIO = 0.1f;
    private static final float SLOW_RATIO = 0.005f;
    private static final float THRESHOLD = 0.04f;

    public WarmupManager(@Nullable Integer overrideCount) {
        this.overrideCount = overrideCount;
    }

    public /* synthetic */ WarmupManager(Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        this(n);
    }

    @Nullable
    public final Integer getOverrideCount() {
        return this.overrideCount;
    }

    public final float getEstimatedIterationTimeNs() {
        return this.fastMovingAvg;
    }

    public final int getIteration() {
        return this.iteration;
    }

    public final long getTotalDurationNs() {
        return this.totalDurationNs;
    }

    public final boolean onNextIteration(long durationNs) {
        int n = this.iteration;
        this.iteration = n + 1;
        this.totalDurationNs += durationNs;
        if (this.iteration == 1) {
            this.fastMovingAvg = durationNs;
            this.slowMovingAvg = durationNs;
            Integer n2 = this.overrideCount;
            return n2 != null && this.iteration == n2;
        }
        this.fastMovingAvg = 0.1f * (float)durationNs + 0.9f * this.fastMovingAvg;
        this.slowMovingAvg = 0.005f * (float)durationNs + 0.995f * this.slowMovingAvg;
        float ratio = this.fastMovingAvg / this.slowMovingAvg;
        if (ratio < 1.04f && ratio > 0.96f) {
            int n3 = this.similarIterationCount;
            this.similarIterationCount = n3 + 1;
        } else {
            this.similarIterationCount = 0;
        }
        if (this.overrideCount != null) {
            if (!(this.iteration <= this.overrideCount)) {
                boolean bl = false;
                String string = "Too many warmups, iter " + this.iteration + ", target " + this.overrideCount;
                throw new IllegalStateException(string.toString());
            }
            Integer n4 = this.overrideCount;
            return n4 != null && this.iteration == n4;
        }
        return this.iteration >= 30 && this.totalDurationNs >= MIN_DURATION_NS && (this.similarIterationCount > 40 || this.totalDurationNs >= MAX_DURATION_NS);
    }

    public final void logInfo() {
        if (this.iteration > 0) {
            String string = "Warmup: t=%.3f, iter=%d, fastAvg=%3.0f, slowAvg=%3.0f";
            Object[] objectArray = new Object[]{(double)this.totalDurationNs / 1.0E9, this.iteration, Float.valueOf(this.fastMovingAvg), Float.valueOf(this.slowMovingAvg)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            Log.d((String)"Benchmark", (String)string2);
        }
    }

    public WarmupManager() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/WarmupManager$Companion;", "", "()V", "FAST_RATIO", "", "MAX_DURATION_NS", "", "getMAX_DURATION_NS", "()J", "MIN_DURATION_NS", "getMIN_DURATION_NS", "MIN_ITERATIONS", "", "MIN_SIMILAR_ITERATIONS", "SLOW_RATIO", "THRESHOLD", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getMIN_DURATION_NS() {
            return MIN_DURATION_NS;
        }

        public final long getMAX_DURATION_NS() {
            return MAX_DURATION_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

