/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Shell;
import androidx.benchmark.perfetto.AtraceTag;
import androidx.benchmark.perfetto.StackSamplingConfig;
import com.squareup.wire.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.AndroidLogConfig;
import perfetto.protos.AndroidPolledStateConfig;
import perfetto.protos.AndroidPowerConfig;
import perfetto.protos.ChromeConfig;
import perfetto.protos.DataSourceConfig;
import perfetto.protos.FtraceConfig;
import perfetto.protos.GpuCounterConfig;
import perfetto.protos.HeapprofdConfig;
import perfetto.protos.InodeFileConfig;
import perfetto.protos.InterceptorConfig;
import perfetto.protos.JavaHprofConfig;
import perfetto.protos.MeminfoCounters;
import perfetto.protos.PackagesListConfig;
import perfetto.protos.PerfEventConfig;
import perfetto.protos.PerfEvents;
import perfetto.protos.ProcessStatsConfig;
import perfetto.protos.SysStatsConfig;
import perfetto.protos.TestConfig;
import perfetto.protos.TraceConfig;
import perfetto.protos.TrackEventConfig;
import perfetto.protos.VulkanMemoryConfig;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a \u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0001\u001a\u0012\u0010\f\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\tH\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"ANDROID_POWER_DATASOURCE", "Lperfetto/protos/TraceConfig$DataSource;", "LINUX_SYS_STATS_DATASOURCE", "PACKAGE_LIST_DATASOURCE", "ftraceDataSource", "atraceApps", "", "", "perfettoConfig", "Lperfetto/protos/TraceConfig;", "stackSamplingConfig", "Landroidx/benchmark/perfetto/StackSamplingConfig;", "processStatsDataSource", "stackSamplingSource", "config", "validateAndEncode", "", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nPerfettoConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoConfig.kt\nandroidx/benchmark/perfetto/PerfettoConfigKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,392:1\n766#2:393\n857#2,2:394\n1549#2:396\n1620#2,3:397\n1549#2:401\n1620#2,3:402\n1#3:400\n*S KotlinDebug\n*F\n+ 1 PerfettoConfig.kt\nandroidx/benchmark/perfetto/PerfettoConfigKt\n*L\n162#1:393\n162#1:394,2\n166#1:396\n166#1:397,3\n370#1:401\n370#1:402,3\n*E\n"})
public final class PerfettoConfigKt {
    @NotNull
    private static final TraceConfig.DataSource PACKAGE_LIST_DATASOURCE = new TraceConfig.DataSource(new DataSourceConfig("android.packages_list", 1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFFC, null), null, null, null, 14, null);
    @NotNull
    private static final TraceConfig.DataSource LINUX_SYS_STATS_DATASOURCE;
    @NotNull
    private static final TraceConfig.DataSource ANDROID_POWER_DATASOURCE;

    /*
     * WARNING - void declaration
     */
    private static final TraceConfig.DataSource ftraceDataSource(List<String> atraceApps) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        AtraceTag it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object = new String[]{"task/task_newtask", "task/task_rename", "sched/sched_process_exit", "sched/sched_process_free", "mm_event/mm_event_record", "kmem/rss_stat", "kmem/ion_heap_shrink", "kmem/ion_heap_grow", "ion/ion_stat", "oom/oom_score_adj_update", "disk", "ufs/ufshcd_clk_gating", "lowmemorykiller/lowmemory_kill"};
        List list = CollectionsKt.listOf((Object[])object);
        object = new AtraceTag[]{AtraceTag.ActivityManager, AtraceTag.Audio, AtraceTag.BinderDriver, AtraceTag.Camera, AtraceTag.Dalvik, AtraceTag.Frequency, AtraceTag.Graphics, AtraceTag.HardwareModules, AtraceTag.Idle, AtraceTag.Input, AtraceTag.MemReclaim, AtraceTag.Resources, AtraceTag.Scheduling, AtraceTag.Synchronization, AtraceTag.View, AtraceTag.WindowManager};
        object = CollectionsKt.listOf((Object[])object);
        List list2 = list;
        Long l = null;
        DataSourceConfig.SessionInitiator sessionInitiator = null;
        Boolean bl = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = 0;
        String string = "linux.ftrace";
        boolean $i$f$filter = false;
        void var3_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AtraceTag)((Object)element$iv$iv);
            boolean bl2 = false;
            if (!it.supported(Build.VERSION.SDK_INT, false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AtraceTag)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getTag());
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n4 = 472;
        ByteString byteString = null;
        Boolean bl4 = null;
        Boolean bl5 = null;
        FtraceConfig.CompactSchedConfig compactSchedConfig = new FtraceConfig.CompactSchedConfig(true, null, 2, null);
        Integer n5 = null;
        Integer n6 = null;
        List<String> list3 = atraceApps;
        Collection<String> collection2 = collection;
        List list4 = list2;
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n7 = 67108732;
        ByteString byteString2 = null;
        TestConfig testConfig = null;
        String string2 = null;
        InterceptorConfig interceptorConfig = null;
        ChromeConfig chromeConfig = null;
        AndroidPolledStateConfig androidPolledStateConfig = null;
        TrackEventConfig trackEventConfig = null;
        VulkanMemoryConfig vulkanMemoryConfig = null;
        PerfEventConfig perfEventConfig = null;
        PackagesListConfig packagesListConfig = null;
        GpuCounterConfig gpuCounterConfig = null;
        AndroidLogConfig androidLogConfig = null;
        AndroidPowerConfig androidPowerConfig = null;
        JavaHprofConfig javaHprofConfig = null;
        HeapprofdConfig heapprofdConfig = null;
        SysStatsConfig sysStatsConfig = null;
        ProcessStatsConfig processStatsConfig = null;
        InodeFileConfig inodeFileConfig = null;
        FtraceConfig ftraceConfig = new FtraceConfig(list4, (List)collection2, list3, n6, n5, compactSchedConfig, bl5, bl4, byteString, n4, defaultConstructorMarker);
        Long l2 = l;
        DataSourceConfig.SessionInitiator sessionInitiator2 = sessionInitiator;
        Boolean bl6 = bl;
        Integer n8 = n;
        Integer n9 = n2;
        Integer n10 = n3;
        String string3 = string;
        DefaultConstructorMarker defaultConstructorMarker3 = null;
        int n11 = 14;
        ByteString byteString3 = null;
        List list5 = null;
        List list6 = null;
        DataSourceConfig dataSourceConfig = new DataSourceConfig(string3, n10, n9, n8, bl6, sessionInitiator2, l2, ftraceConfig, inodeFileConfig, processStatsConfig, sysStatsConfig, heapprofdConfig, javaHprofConfig, androidPowerConfig, androidLogConfig, gpuCounterConfig, packagesListConfig, perfEventConfig, vulkanMemoryConfig, trackEventConfig, androidPolledStateConfig, chromeConfig, interceptorConfig, string2, testConfig, byteString2, n7, defaultConstructorMarker2);
        return new TraceConfig.DataSource(dataSourceConfig, list6, list5, byteString3, n11, defaultConstructorMarker3);
    }

    private static final TraceConfig.DataSource processStatsDataSource(StackSamplingConfig stackSamplingConfig) {
        StackSamplingConfig stackSamplingConfig2 = stackSamplingConfig;
        int n = stackSamplingConfig2 != null ? (int)stackSamplingConfig2.getFrequency() : 10000;
        return new TraceConfig.DataSource(new DataSourceConfig("linux.process_stats", 1, null, null, null, null, null, null, null, new ProcessStatsConfig(true, null, n, null, null, null, null, 122, null), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 67108348, null), null, null, null, 14, null);
    }

    private static final List<TraceConfig.DataSource> stackSamplingSource(StackSamplingConfig config) {
        List sources = new ArrayList();
        Collection collection = sources;
        Object object = PerfEvents.Counter.SW_CPU_CLOCK;
        long l = config.getFrequency();
        PerfEvents.PerfClock perfClock = PerfEvents.PerfClock.PERF_CLOCK_MONOTONIC;
        collection.add(new TraceConfig.DataSource(new DataSourceConfig("linux.perf", 1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new PerfEventConfig(new PerfEvents.Timebase(l, null, (PerfEvents.Counter)((Object)object), null, null, perfClock, null, null, 218, null), new PerfEventConfig.CallstackSampling(new PerfEventConfig.Scope(null, config.getPackageNames(), null, null, null, null, 61, null), null, null, 6, null), null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, 260092, null), null, null, null, null, null, null, null, null, 66977788, null), null, null, null, 14, null));
        collection = sources;
        object = new PerfEvents.Tracepoint("sched_switch", null, null, 6, null);
        collection.add(new TraceConfig.DataSource(new DataSourceConfig("linux.perf", 1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new PerfEventConfig(new PerfEvents.Timebase(null, 1L, null, (PerfEvents.Tracepoint)((Object)object), null, null, null, null, 245, null), new PerfEventConfig.CallstackSampling(new PerfEventConfig.Scope(null, config.getPackageNames(), null, null, null, null, 61, null), null, null, 6, null), null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, 260092, null), null, null, null, null, null, null, null, null, 66977788, null), null, null, null, 14, null));
        if (Build.VERSION.SDK_INT >= 29) {
            collection = sources;
            object = config.getPackageNames();
            List list = CollectionsKt.listOf((Object)"com.android.art");
            HeapprofdConfig.ContinuousDumpConfig continuousDumpConfig = new HeapprofdConfig.ContinuousDumpConfig(0, 500, null, 4, null);
            collection.add(new TraceConfig.DataSource(new DataSourceConfig("android.heapprofd", null, null, null, null, null, null, null, null, null, null, new HeapprofdConfig(2048L, null, null, (List)object, null, null, list, null, null, null, null, null, null, null, null, null, continuousDumpConfig, 0x800000L, true, null, null, null, null, null, null, null, 66650038, null), null, null, null, null, null, null, null, null, null, null, null, null, null, null, 67106814, null), null, null, null, 14, null));
        }
        return sources;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final TraceConfig perfettoConfig(@NotNull List<String> atraceApps, @Nullable StackSamplingConfig stackSamplingConfig) {
        Intrinsics.checkNotNullParameter(atraceApps, (String)"atraceApps");
        Message[] messageArray = new TraceConfig.DataSource[]{PerfettoConfigKt.ftraceDataSource(atraceApps), PerfettoConfigKt.processStatsDataSource(stackSamplingConfig), PACKAGE_LIST_DATASOURCE, LINUX_SYS_STATS_DATASOURCE, ANDROID_POWER_DATASOURCE, new TraceConfig.DataSource(new DataSourceConfig("android.gpu.memory", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFFE, null), null, null, null, 14, null), new TraceConfig.DataSource(new DataSourceConfig("android.surfaceflinger.frame", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFFE, null), null, null, null, 14, null), new TraceConfig.DataSource(new DataSourceConfig("android.surfaceflinger.frametimeline", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFFE, null), null, null, null, 14, null), new TraceConfig.DataSource(new DataSourceConfig("track_event", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFFE, null), null, null, null, 14, null)};
        List dataSources = CollectionsKt.mutableListOf((Object[])messageArray);
        if (stackSamplingConfig != null) {
            CollectionsKt.addAll((Collection)dataSources, (Iterable)PerfettoConfigKt.stackSamplingSource(stackSamplingConfig));
        }
        messageArray = new TraceConfig.BufferConfig[]{new TraceConfig.BufferConfig(32768, TraceConfig.BufferConfig.FillPolicy.RING_BUFFER, null, 4, null), new TraceConfig.BufferConfig(4096, TraceConfig.BufferConfig.FillPolicy.RING_BUFFER, null, 4, null)};
        return new TraceConfig(CollectionsKt.listOf((Object[])messageArray), dataSources, null, null, null, null, null, null, true, null, 2500, null, null, null, 5000, null, 2500, null, null, null, null, null, null, null, null, null, null, null, null, null, 1073658620, null);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=21)
    @NotNull
    public static final byte[] validateAndEncode(@NotNull TraceConfig $this$validateAndEncode) {
        String packageList;
        void $this$mapTo$iv$iv;
        FtraceConfig ftraceConfig;
        block7: {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$validateAndEncode), (String)"<this>");
            for (TraceConfig.DataSource it : (Iterable)$this$validateAndEncode.getData_sources()) {
                boolean bl = false;
                DataSourceConfig dataSourceConfig = it.getConfig();
                ftraceConfig = dataSourceConfig != null ? dataSourceConfig.getFtrace_config() : null;
                if (ftraceConfig == null) {
                    continue;
                }
                break block7;
            }
            ftraceConfig = null;
        }
        if (ftraceConfig == null) {
            throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
        }
        FtraceConfig ftraceConfig2 = ftraceConfig;
        Iterable $this$map$iv = AtraceTag.Companion.supported(Build.VERSION.SDK_INT, Shell.INSTANCE.isSessionRooted());
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AtraceTag atraceTag = (AtraceTag)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getTag());
        }
        Set supportedTags = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List unsupportedTags = CollectionsKt.minus((Iterable)ftraceConfig2.getAtrace_categories(), (Iterable)supportedTags);
        if (!unsupportedTags.isEmpty()) {
            boolean $i$a$-check-PerfettoConfigKt$validateAndEncode$42 = false;
            String $i$a$-check-PerfettoConfigKt$validateAndEncode$42 = "Error - attempted to use unsupported atrace tags: " + unsupportedTags;
            throw new IllegalStateException($i$a$-check-PerfettoConfigKt$validateAndEncode$42.toString());
        }
        if (Build.VERSION.SDK_INT < 28 && !(!ftraceConfig2.getAtrace_apps().contains("*"))) {
            boolean bl3 = false;
            String string = "Support for wildcard (*) app matching in atrace added in API 28";
            throw new IllegalStateException(string.toString());
        }
        if (Build.VERSION.SDK_INT < 24 && !((packageList = CollectionsKt.joinToString$default((Iterable)ftraceConfig2.getAtrace_apps(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).length() <= 91)) {
            boolean bl4 = false;
            String string = "Unable to trace package list (\"" + packageList + "\").length = " + packageList.length() + " > 91 chars, which is the limit before API 24";
            throw new IllegalStateException(string.toString());
        }
        return $this$validateAndEncode.encode();
    }

    static {
        Enum[] enumArray = new MeminfoCounters[]{MeminfoCounters.MEMINFO_MEM_TOTAL, MeminfoCounters.MEMINFO_MEM_FREE, MeminfoCounters.MEMINFO_MEM_AVAILABLE, MeminfoCounters.MEMINFO_BUFFERS, MeminfoCounters.MEMINFO_CACHED, MeminfoCounters.MEMINFO_SWAP_CACHED, MeminfoCounters.MEMINFO_ACTIVE, MeminfoCounters.MEMINFO_INACTIVE, MeminfoCounters.MEMINFO_ACTIVE_ANON, MeminfoCounters.MEMINFO_INACTIVE_ANON, MeminfoCounters.MEMINFO_ACTIVE_FILE, MeminfoCounters.MEMINFO_INACTIVE_FILE, MeminfoCounters.MEMINFO_UNEVICTABLE, MeminfoCounters.MEMINFO_SWAP_TOTAL, MeminfoCounters.MEMINFO_SWAP_FREE, MeminfoCounters.MEMINFO_DIRTY, MeminfoCounters.MEMINFO_WRITEBACK, MeminfoCounters.MEMINFO_ANON_PAGES, MeminfoCounters.MEMINFO_MAPPED, MeminfoCounters.MEMINFO_SHMEM};
        LINUX_SYS_STATS_DATASOURCE = new TraceConfig.DataSource(new DataSourceConfig("linux.sys_stats", 1, null, null, null, null, null, null, null, null, new SysStatsConfig(1000, CollectionsKt.listOf((Object[])enumArray), null, null, null, null, null, null, 252, null), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 67107836, null), null, null, null, 14, null);
        enumArray = new AndroidPowerConfig.BatteryCounters[]{AndroidPowerConfig.BatteryCounters.BATTERY_COUNTER_CAPACITY_PERCENT, AndroidPowerConfig.BatteryCounters.BATTERY_COUNTER_CHARGE, AndroidPowerConfig.BatteryCounters.BATTERY_COUNTER_CURRENT};
        ANDROID_POWER_DATASOURCE = new TraceConfig.DataSource(new DataSourceConfig("android.power", null, null, null, null, null, null, null, null, null, null, null, null, new AndroidPowerConfig(250, CollectionsKt.listOf((Object[])enumArray), true, null, null, 24, null), null, null, null, null, null, null, null, null, null, null, null, null, 67100670, null), null, null, null, 14, null);
    }
}

