/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Shell;
import androidx.benchmark.SideEffect;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/DisablePackages;", "Landroidx/benchmark/SideEffect;", "packages", "", "", "(Ljava/util/List;)V", "name", "setup", "", "tearDown", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DisablePackages
implements SideEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> packages;
    @NotNull
    private static final List<String> DEFAULT_PACKAGES_TO_DISABLE;

    public DisablePackages(@NotNull List<String> packages) {
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        this.packages = packages;
    }

    public /* synthetic */ DisablePackages(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = DEFAULT_PACKAGES_TO_DISABLE;
        }
        this(list);
    }

    @Override
    @NotNull
    public String name() {
        return "DisablePackages";
    }

    @Override
    public void setup() {
        if (Build.VERSION.SDK_INT >= 21) {
            Log.d((String)"Benchmark", (String)("Disabling packages " + this.packages));
            Shell.INSTANCE.disablePackages(this.packages);
        }
    }

    @Override
    public void tearDown() {
        if (Build.VERSION.SDK_INT >= 21) {
            Log.d((String)"Benchmark", (String)("Re-enabling packages " + this.packages));
            Shell.INSTANCE.enablePackages(this.packages);
        }
    }

    public DisablePackages() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"com.android.chrome", "com.android.ramdump", "com.android.vending", "com.google.android.GoogleCamera", "com.google.android.apps.docs", "com.google.android.apps.gcs", "com.google.android.apps.internal.betterbug", "com.google.android.apps.maps", "com.google.android.apps.messaging", "com.google.android.apps.nbu.files", "com.google.android.apps.photos", "com.google.android.apps.pixelmigrate", "com.google.android.apps.scone", "com.google.android.apps.speechservices", "com.google.android.apps.tachyon", "com.google.android.apps.tips", "com.google.android.apps.turbo", "com.google.android.apps.tycho", "com.google.android.apps.wellbeing", "com.google.android.apps.work.clouddpc", "com.google.android.apps.youtube.music", "com.google.android.as", "com.google.android.calculator", "com.google.android.calendar", "com.google.android.carrier", "com.google.android.configupdater", "com.google.android.contacts", "com.google.android.deskclock", "com.google.android.dialer", "com.google.android.gm", "com.google.android.gms", "com.google.android.googlequicksearchbox", "com.google.android.ims", "com.google.android.inputmethod.latin", "com.google.android.marvin.talkback", "com.google.android.partnersetup", "com.google.android.settings.intelligence", "com.google.android.tts", "com.google.android.videos", "com.google.android.volta", "com.google.android.youtube"};
        DEFAULT_PACKAGES_TO_DISABLE = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/benchmark/DisablePackages$Companion;", "", "()V", "DEFAULT_PACKAGES_TO_DISABLE", "", "", "getDEFAULT_PACKAGES_TO_DISABLE$benchmark_common_release", "()Ljava/util/List;", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDEFAULT_PACKAGES_TO_DISABLE$benchmark_common_release() {
            return DEFAULT_PACKAGES_TO_DISABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

