/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.benchmark.BenchmarkResult;
import androidx.benchmark.IdeSummaryPair;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.MetricResult;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJS\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012H\u0000\u00a2\u0006\u0002\b\u0015J7\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\n2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\n0\u001f\u00a2\u0006\u0002\b!J \u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020&J\u0015\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b)J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006,"}, d2={"Landroidx/benchmark/InstrumentationResults;", "", "()V", "ideWarningPrefix", "", "runEndResultBundle", "Landroid/os/Bundle;", "getRunEndResultBundle", "()Landroid/os/Bundle;", "clearIdeWarningPrefix", "", "ideSummary", "Landroidx/benchmark/IdeSummaryPair;", "testName", "message", "measurements", "Landroidx/benchmark/BenchmarkResult$Measurements;", "iterationTracePaths", "", "profilerResults", "Landroidx/benchmark/Profiler$ResultFile;", "ideSummary$benchmark_common_release", "ideSummaryBasicMicro", "benchmarkName", "nanos", "", "allocations", "ideSummaryBasicMicro$benchmark_common_release", "(Ljava/lang/String;DLjava/lang/Double;Ljava/util/List;)Ljava/lang/String;", "instrumentationReport", "block", "Lkotlin/Function1;", "Landroidx/benchmark/InstrumentationResultScope;", "Lkotlin/ExtensionFunctionType;", "reportAdditionalFileToCopy", "key", "absoluteFilePath", "reportOnRunEndOnly", "", "reportBundle", "bundle", "reportBundle$benchmark_common_release", "scheduleIdeWarningOnNextReport", "string", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nInstrumentationResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstrumentationResults.kt\nandroidx/benchmark/InstrumentationResults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,363:1\n1855#2,2:364\n1549#2:366\n1620#2,3:367\n1549#2:371\n1620#2,3:372\n1549#2:375\n1620#2,3:376\n618#2,12:379\n661#2,11:391\n1559#2:402\n1590#2,4:403\n1549#2:407\n1620#2,3:408\n1549#2:411\n1620#2,3:412\n1549#2:415\n1620#2,3:416\n1#3:370\n*S KotlinDebug\n*F\n+ 1 InstrumentationResults.kt\nandroidx/benchmark/InstrumentationResults\n*L\n151#1:364,2\n180#1:366\n180#1:367,3\n195#1:371\n195#1:372,3\n203#1:375\n203#1:376,3\n214#1:379,12\n216#1:391,11\n293#1:402\n293#1:403,4\n299#1:407\n299#1:408,3\n252#1:411\n252#1:412,3\n260#1:415\n260#1:416,3\n*E\n"})
public final class InstrumentationResults {
    @NotNull
    public static final InstrumentationResults INSTANCE = new InstrumentationResults();
    @NotNull
    private static final Bundle runEndResultBundle = new Bundle();
    @NotNull
    private static String ideWarningPrefix = "";

    private InstrumentationResults() {
    }

    @NotNull
    public final Bundle getRunEndResultBundle() {
        return runEndResultBundle;
    }

    public final void instrumentationReport(@NotNull Function1<? super InstrumentationResultScope, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        InstrumentationResultScope scope = new InstrumentationResultScope(null, 1, null);
        block.invoke((Object)scope);
        this.reportBundle$benchmark_common_release(scope.getBundle());
    }

    @NotNull
    public final String ideSummaryBasicMicro$benchmark_common_release(@NotNull String benchmarkName, double nanos, @Nullable Double allocations, @NotNull List<Profiler.ResultFile> profilerResults) {
        String string;
        Object[] objectArray;
        String string2;
        Intrinsics.checkNotNullParameter((Object)benchmarkName, (String)"benchmarkName");
        Intrinsics.checkNotNullParameter(profilerResults, (String)"profilerResults");
        String output = null;
        if (nanos >= 100.0) {
            string2 = "%,13d   ns";
            objectArray = new Object[]{(long)nanos};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string2 = "%,15.1f ns";
            objectArray = new Object[]{nanos};
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        }
        output = string;
        if (allocations != null) {
            StringBuilder stringBuilder = new StringBuilder().append(output);
            string2 = "    %8d allocs";
            objectArray = new Object[]{(int)allocations.doubleValue()};
            String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            output = stringBuilder.append(string5).toString();
        }
        Iterable $this$forEach$iv = profilerResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Profiler.ResultFile it = (Profiler.ResultFile)element$iv;
            boolean bl = false;
            output = output + "    [" + it.getLabel() + "](file://" + it.getSanitizedOutputRelativePath() + ')';
        }
        output = output + "    " + benchmarkName;
        return output;
    }

    public final void clearIdeWarningPrefix() {
        System.out.println((Object)"clear ide warning");
        ideWarningPrefix = "";
    }

    /*
     * WARNING - void declaration
     */
    public final void scheduleIdeWarningOnNextReport(@NotNull String string) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        ideWarningPrefix = ((CharSequence)ideWarningPrefix).length() == 0 ? string : ideWarningPrefix + '\n' + string;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Log.w((String)"Benchmark", (String)it));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdeSummaryPair ideSummary$benchmark_common_release(@Nullable String testName, @Nullable String message, @Nullable BenchmarkResult.Measurements measurements, @Nullable List<String> iterationTracePaths, @NotNull List<Profiler.ResultFile> profilerResults) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Collection collection;
        int n;
        Object it;
        List linkableIterTraces;
        List list2;
        Object object;
        Object destination$iv$iv;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(profilerResults, (String)"profilerResults");
        CharSequence charSequence2 = ideWarningPrefix;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String warningMessage = (String)charSequence;
        ideWarningPrefix = "";
        List<String> v1metricLines = null;
        List<String> v2metricLines = null;
        List<String> list3 = iterationTracePaths;
        if (list3 != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void absolutePath;
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(StringsKt.replace$default((String)StringsKt.replace$default((String)Outputs.INSTANCE.relativePathFor((String)absolutePath), (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = linkableIterTraces = null;
        }
        if (measurements != null) {
            void $this$mapTo$iv$iv3;
            if (!measurements.isNotEmpty()) {
                boolean $i$a$-require-InstrumentationResults$ideSummary$22 = false;
                String $i$a$-require-InstrumentationResults$ideSummary$22 = "Require non-empty list of metric results.";
                throw new IllegalArgumentException($i$a$-require-InstrumentationResults$ideSummary$22.toString());
            }
            Object[] $this$map$iv3 = (Object[])measurements.getSingleMetrics();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it2;
                MetricResult bl = (MetricResult)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(it2.getName());
            }
            Set setOfMetrics = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            if (iterationTracePaths == null && testName != null && message == null && measurements.getSampledMetrics().isEmpty() && (Intrinsics.areEqual((Object)setOfMetrics, (Object)SetsKt.setOf((Object[])($this$map$iv3 = new String[]{"timeNs", "allocationCount"}))) || Intrinsics.areEqual((Object)setOfMetrics, (Object)SetsKt.setOf((Object)"timeNs")))) {
                Object v3;
                double nanos;
                block24: {
                    Iterable $this$single$iv = measurements.getSingleMetrics();
                    boolean $i$f$single = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$single$iv) {
                        MetricResult it3 = (MetricResult)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it3.getName(), (Object)"timeNs")) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    nanos = ((MetricResult)single$iv).getMin();
                    Iterable $this$singleOrNull$iv = measurements.getSingleMetrics();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv2 = null;
                    boolean found$iv2 = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        MetricResult it4 = (MetricResult)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it4.getName(), (Object)"allocationCount")) continue;
                        if (found$iv2) {
                            v3 = null;
                            break block24;
                        }
                        single$iv2 = element$iv;
                        found$iv2 = true;
                    }
                    v3 = !found$iv2 ? null : single$iv2;
                }
                MetricResult metricResult = v3;
                Double allocs = metricResult != null ? Double.valueOf(metricResult.getMin()) : null;
                String warningPrefix = warningMessage == null ? "" : warningMessage + '\n';
                return new IdeSummaryPair(warningPrefix + this.ideSummaryBasicMicro$benchmark_common_release(testName, nanos, allocs, CollectionsKt.emptyList()), warningPrefix + this.ideSummaryBasicMicro$benchmark_common_release(testName, nanos, allocs, profilerResults));
            }
            List allMetrics = CollectionsKt.plus((Collection)measurements.getSingleMetrics(), (Iterable)measurements.getSampledMetrics());
            Iterator warningPrefix = ((Iterable)allMetrics).iterator();
            if (!warningPrefix.hasNext()) {
                throw new NoSuchElementException();
            }
            MetricResult it422 = (MetricResult)warningPrefix.next();
            boolean bl = false;
            int it422 = it422.getName().length();
            while (warningPrefix.hasNext()) {
                MetricResult it32 = (MetricResult)warningPrefix.next();
                $i$a$-maxOf-InstrumentationResults$ideSummary$maxLabelLength$1 = false;
                int it32 = it32.getName().length();
                if (it422 >= it32) continue;
                it422 = it32;
            }
            int maxLabelLength = it422;
            Iterator it422 = ((Iterable)allMetrics).iterator();
            if (!it422.hasNext()) {
                throw new NoSuchElementException();
            }
            MetricResult it5 = (MetricResult)it422.next();
            boolean bl3 = false;
            double found$iv2 = it5.getMax();
            while (it422.hasNext()) {
                it = (MetricResult)it422.next();
                n = 0;
                double bl4 = ((MetricResult)it).getMax();
                found$iv2 = Math.max(found$iv2, bl4);
            }
            int maxValueLength = InstrumentationResults.ideSummary$toDisplayString(found$iv2).length();
            v1metricLines = InstrumentationResults.ideSummary$metricLines(measurements, maxLabelLength, maxValueLength, (Function5<? super String, ? super String, ? super String, ? super String, ? super MetricResult, String>)((Function5)ideSummary.2.INSTANCE));
            v2metricLines = linkableIterTraces != null ? InstrumentationResults.ideSummary$metricLines(measurements, maxLabelLength, maxValueLength, (Function5<? super String, ? super String, ? super String, ? super String, ? super MetricResult, String>)((Function5)new Function5<String, String, String, String, MetricResult, String>((List<String>)linkableIterTraces){
                final /* synthetic */ List<String> $linkableIterTraces;
                {
                    this.$linkableIterTraces = $linkableIterTraces;
                    super(5);
                }

                @NotNull
                public final String invoke(@NotNull String name, @NotNull String min, @NotNull String median, @NotNull String max, @NotNull MetricResult result) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)min, (String)"min");
                    Intrinsics.checkNotNullParameter((Object)median, (String)"median");
                    Intrinsics.checkNotNullParameter((Object)max, (String)"max");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    return "  " + name + "   [min " + min + "](file://" + this.$linkableIterTraces.get(result.getMinIndex()) + "),   [median " + median + "](file://" + this.$linkableIterTraces.get(result.getMedianIndex()) + "),   [max " + max + "](file://" + this.$linkableIterTraces.get(result.getMaxIndex()) + ')';
                }
            })) : v1metricLines;
        } else {
            v1metricLines = CollectionsKt.emptyList();
            v2metricLines = CollectionsKt.emptyList();
        }
        if (linkableIterTraces != null) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable allMetrics = linkableIterTraces;
            object = new StringBuilder().append("    Traces: Iteration ");
            boolean $i$f$mapIndexed = false;
            void maxValueLength = $this$mapIndexed$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void path;
                void index;
                int it3;
                if ((it3 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                it = (String)item$iv$iv2;
                n = it3;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add("" + '[' + (int)index + "](file://" + (String)path + ')');
            }
            list = CollectionsKt.listOf((Object)((StringBuilder)object).append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).toString());
        } else {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$mapIndexed$iv = profilerResults;
        object = list;
        boolean $i$f$map = false;
        void $this$mapIndexedTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it6;
            Profiler.ResultFile item$iv$iv2 = (Profiler.ResultFile)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add("    [" + it6.getLabel() + "](file://" + it6.getSanitizedOutputRelativePath() + ')');
        }
        List v2traceLinks = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv4));
        Object[] objectArray = new String[]{warningMessage, testName, message};
        List list4 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)v1metricLines), (Object)"");
        objectArray = new String[]{warningMessage, testName, message};
        return new IdeSummaryPair(list4, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)v2metricLines), (Iterable)v2traceLinks), (Object)""));
    }

    public static /* synthetic */ IdeSummaryPair ideSummary$benchmark_common_release$default(InstrumentationResults instrumentationResults, String string, String string2, BenchmarkResult.Measurements measurements, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            measurements = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return instrumentationResults.ideSummary$benchmark_common_release(string, string2, measurements, list, list2);
    }

    public final void reportAdditionalFileToCopy(@NotNull String key, @NotNull String absoluteFilePath, boolean reportOnRunEndOnly) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        if (!(!StringsKt.contains$default((CharSequence)key, (char)'=', (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Key must not contain '=', which breaks instrumentation result string parsing";
            throw new IllegalArgumentException(string.toString());
        }
        if (reportOnRunEndOnly) {
            new InstrumentationResultScope(runEndResultBundle).fileRecord(key, absoluteFilePath);
        } else {
            this.instrumentationReport((Function1<? super InstrumentationResultScope, Unit>)((Function1)new Function1<InstrumentationResultScope, Unit>(key, absoluteFilePath){
                final /* synthetic */ String $key;
                final /* synthetic */ String $absoluteFilePath;
                {
                    this.$key = $key;
                    this.$absoluteFilePath = $absoluteFilePath;
                    super(1);
                }

                public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    $this$instrumentationReport.fileRecord(this.$key, this.$absoluteFilePath);
                }
            }));
        }
    }

    public static /* synthetic */ void reportAdditionalFileToCopy$default(InstrumentationResults instrumentationResults, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        instrumentationResults.reportAdditionalFileToCopy(string, string2, bl);
    }

    public final void reportBundle$benchmark_common_release(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        InstrumentationRegistry.getInstrumentation().sendStatus(2, bundle);
    }

    private static final String ideSummary$toDisplayString(double $this$ideSummary_u24toDisplayString) {
        String string = "%,.1f";
        Object[] objectArray = new Object[]{$this$ideSummary_u24toDisplayString};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final List<String> ideSummary$metricLines(BenchmarkResult.Measurements $measurements, int maxLabelLength, int maxValueLength, Function5<? super String, ? super String, ? super String, ? super String, ? super MetricResult, String> singleTransform) {
        MetricResult it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $measurements.getSingleMetrics();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MetricResult metricResult = (MetricResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)singleTransform.invoke((Object)StringsKt.padEnd$default((String)it.getName(), (int)maxLabelLength, (char)'\u0000', (int)2, null), (Object)StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getMin()), (int)maxValueLength, (char)'\u0000', (int)2, null), (Object)StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getMedian()), (int)maxValueLength, (char)'\u0000', (int)2, null), (Object)StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getMax()), (int)maxValueLength, (char)'\u0000', (int)2, null), (Object)it));
        }
        $this$map$iv = $measurements.getSampledMetrics();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MetricResult)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String name = StringsKt.padEnd$default((String)it.getName(), (int)maxLabelLength, (char)'\u0000', (int)2, null);
            String p50 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP50()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            String p90 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP90()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            String p95 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP95()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            String p99 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP99()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            collection2.add("  " + name + "   P50  " + p50 + ",   P90  " + p90 + ",   P95  " + p95 + ",   P99  " + p99);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }
}

