/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.ParcelFileDescriptor;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Shell;
import androidx.benchmark.ShellImpl;
import androidx.benchmark.StartedShellScript;
import androidx.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB!\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/ShellScript;", "", "stdinFile", "Ljava/io/File;", "scriptContentFile", "stderrPath", "", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;)V", "cleanedUp", "", "cleanUp", "", "start", "Landroidx/benchmark/StartedShellScript;", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
@SourceDebugExtension(value={"SMAP\nShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shell.kt\nandroidx/benchmark/ShellScript\n+ 2 Trace.kt\nandroidx/tracing/TraceKt\n*L\n1#1,877:1\n27#2,6:878\n27#2,6:884\n*S KotlinDebug\n*F\n+ 1 Shell.kt\nandroidx/benchmark/ShellScript\n*L\n764#1:878,6\n788#1:884,6\n*E\n"})
public final class ShellScript {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File stdinFile;
    @NotNull
    private final File scriptContentFile;
    @NotNull
    private final String stderrPath;
    private boolean cleanedUp;
    @NotNull
    private static final String scriptWrapperPath;

    public ShellScript(@Nullable File stdinFile, @NotNull File scriptContentFile, @NotNull String stderrPath) {
        Intrinsics.checkNotNullParameter((Object)scriptContentFile, (String)"scriptContentFile");
        Intrinsics.checkNotNullParameter((Object)stderrPath, (String)"stderrPath");
        this.stdinFile = stdinFile;
        this.scriptContentFile = scriptContentFile;
        this.stderrPath = stderrPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StartedShellScript start() {
        StartedShellScript startedShellScript;
        String label$iv = "ShellScript#start";
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            String string = this.scriptContentFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scriptContentFile.absolutePath");
            File file = this.stdinFile;
            ParcelFileDescriptor stdoutDescriptor = ShellImpl.INSTANCE.executeCommandNonBlockingUnsafe(Companion.scriptWrapperCommand(string, this.stderrPath, file != null ? file.getAbsolutePath() : null));
            String $this$start_u24lambda_u241_u24lambda_u240 = this.stderrPath;
            boolean bl2 = false;
            Function0 stderrDescriptorFn2 = (Function0)new Function0<String>(this){
                final /* synthetic */ ShellScript this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return ShellImpl.INSTANCE.executeCommandUnsafe("cat " + ShellScript.access$getStderrPath$p(this.this$0));
                }
            };
            startedShellScript = new StartedShellScript(stdoutDescriptor, (Function0<String>)stderrDescriptorFn2, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((ShellScript)this.receiver).cleanUp();
                }
            }));
        }
        finally {
            Trace.endSection();
        }
        return startedShellScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanUp() {
        String label$iv = "ShellScript#cleanUp";
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            if (!this.cleanedUp) {
                Object[] objectArray = new String[3];
                objectArray[0] = this.stderrPath;
                objectArray[1] = this.scriptContentFile.getAbsolutePath();
                File file = this.stdinFile;
                objectArray[2] = file != null ? file.getAbsolutePath() : null;
                ShellImpl.INSTANCE.executeCommandUnsafe("rm -f " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                this.cleanedUp = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Trace.endSection();
        }
    }

    static {
        String string = ShellImpl.INSTANCE.isSessionRooted() ? "shellWrapper_root.sh" : "shellWrapper.sh";
        String string2 = "### shell script which passes in stdin as needed, and captures stderr in a file\n# $1 == script content (not executable)\n# $2 == stderr\n# $3 == stdin (optional)\nif [[ $3 -eq \"0\" ]]; then\n    /system/bin/sh $1 2> $2\nelse\n    cat $3 | /system/bin/sh $1 2> $2\nfi";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        scriptWrapperPath = Shell.INSTANCE.createRunnableExecutable(string, new ByteArrayInputStream(byArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/benchmark/ShellScript$Companion;", "", "()V", "scriptWrapperPath", "", "scriptWrapperCommand", "scriptContentPath", "stderrPath", "stdinPath", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String scriptWrapperCommand(@NotNull String scriptContentPath, @NotNull String stderrPath, @Nullable String stdinPath) {
            Intrinsics.checkNotNullParameter((Object)scriptContentPath, (String)"scriptContentPath");
            Intrinsics.checkNotNullParameter((Object)stderrPath, (String)"stderrPath");
            Object[] objectArray = new String[]{scriptWrapperPath, scriptContentPath, stderrPath, stdinPath};
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

