/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.app.Instrumentation;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.Shell;
import androidx.benchmark.perfetto.PerfettoHelper;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.Trace;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0006\u0010\u0014\u001a\u00020\u0003J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J$\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u000e\u0010\u001c\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\rJ\b\u0010!\u001a\u00020\u0010H\u0002R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/benchmark/perfetto/PerfettoHelper;", "", "unbundled", "", "(Z)V", "perfettoPid", "", "getPerfettoPid", "()Ljava/lang/Integer;", "setPerfettoPid", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "perfettoProcessName", "", "useBackgroundWait", "checkTracingOn", "", "copyFileOutput", "destinationFile", "getPerfettoTmpOutputFilePath", "isRunning", "perfettoCommand", "configFilePath", "isTextProtoConfig", "perfettoStartupException", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "label", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "startCollecting", "stopCollecting", "stopPerfetto", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
@SourceDebugExtension(value={"SMAP\nPerfettoHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoHelper.kt\nandroidx/benchmark/perfetto/PerfettoHelper\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n+ 3 Trace.kt\nandroidx/tracing/TraceKt\n*L\n1#1,470:1\n141#2,3:471\n141#2,6:474\n145#2,2:486\n141#2,6:488\n141#2,6:494\n27#3,6:480\n27#3,6:500\n*S KotlinDebug\n*F\n+ 1 PerfettoHelper.kt\nandroidx/benchmark/perfetto/PerfettoHelper\n*L\n168#1:471,3\n190#1:474,6\n168#1:486,2\n235#1:488,6\n240#1:494,6\n197#1:480,6\n255#1:500,6\n*E\n"})
public final class PerfettoHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean unbundled;
    @Nullable
    private Integer perfettoPid;
    private final boolean useBackgroundWait;
    @NotNull
    private final String perfettoProcessName;
    @NotNull
    public static final String LOG_TAG = "PerfettoCapture";
    public static final int MIN_SDK_VERSION = 23;
    public static final int MIN_BUNDLED_SDK_VERSION = 29;
    @NotNull
    private static final String PERFETTO_TMP_OUTPUT_FILE = "/data/misc/perfetto-traces/trace_output.pb";
    @NotNull
    private static final String PERFETTO_TXT_PROTO_ARG = " --txt";
    private static final int PERFETTO_KILL_WAIT_COUNT = 50;
    private static final long PERFETTO_KILL_WAIT_TIME_MS = 100L;
    @NotNull
    private static final String UNBUNDLED_PERFETTO_ROOT_DIR = "/data/local/tmp";
    @NotNull
    private static final String UNBUNDLED_TEMP_OUTPUT_FILE = "/data/local/tmp/trace_output.pb";
    @NotNull
    private static final Set<String> SUPPORTED_64_ABIS;
    @NotNull
    private static final Set<String> SUPPORTED_32_ABIS;
    @NotNull
    private static final String TRACING_ON_PATH = "/sys/kernel/tracing/tracing_on";
    @NotNull
    private static final String TRACING_ON_FALLBACK_PATH = "/sys/kernel/debug/tracing/tracing_on";
    @NotNull
    private static final Lazy<String> unbundledPerfettoShellPath$delegate;

    public PerfettoHelper(boolean unbundled) {
        this.unbundled = unbundled;
        if (!(this.unbundled || Build.VERSION.SDK_INT >= 29)) {
            boolean bl = false;
            String string = "Perfetto capture using the os version of perfetto requires API 29 or greater.";
            throw new IllegalArgumentException(string.toString());
        }
        this.useBackgroundWait = this.unbundled;
        this.perfettoProcessName = this.unbundled ? "tracebox" : "perfetto";
    }

    public /* synthetic */ PerfettoHelper(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = Build.VERSION.SDK_INT < 29;
        }
        this(bl);
    }

    @Nullable
    public final Integer getPerfettoPid() {
        return this.perfettoPid;
    }

    public final void setPerfettoPid(@Nullable Integer n) {
        this.perfettoPid = n;
    }

    private final IllegalStateException perfettoStartupException(String label, Exception cause) {
        return new IllegalStateException(StringsKt.trimIndent((String)("\n            " + label + "\n            Please report a bug, and include a logcat capture of the test run and failure.\n            " + DeviceInfo.INSTANCE.getDeviceSummaryString() + "\n            ")), cause);
    }

    public final void startCollecting(@NotNull String configFilePath, boolean isTextProtoConfig) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        if (!(((CharSequence)configFilePath).length() > 0)) {
            boolean $i$a$-require-PerfettoHelper$startCollecting$32 = false;
            String $i$a$-require-PerfettoHelper$startCollecting$32 = "Perfetto config cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-PerfettoHelper$startCollecting$32.toString());
        }
        if (!(this.perfettoPid == null)) {
            boolean $i$a$-require-PerfettoHelper$startCollecting$42 = false;
            String $i$a$-require-PerfettoHelper$startCollecting$42 = "Perfetto instance is already running";
            throw new IllegalArgumentException($i$a$-require-PerfettoHelper$startCollecting$42.toString());
        }
        try {
            String string;
            Log.i((String)LOG_TAG, (String)"Cleanup perfetto before starting.");
            Companion.stopAllPerfettoProcesses();
            if (this.unbundled) {
                String path = "/data/local/tmp/config.pb";
                Shell.executeScriptSilent$default(Shell.INSTANCE, "rm -f " + path, null, 2, null);
                if (Build.VERSION.SDK_INT == 23) {
                    Shell.Output output;
                    Shell.Output it = output = Shell.executeScriptCaptureStdoutStderr$default(Shell.INSTANCE, "cp " + configFilePath + ' ' + path, null, 2, null);
                    boolean bl = false;
                    if (!(StringsKt.isBlank((CharSequence)it.getStdout()) && (StringsKt.isBlank((CharSequence)it.getStderr()) || StringsKt.startsWith$default((String)it.getStderr(), (String)"mv: chown", (boolean)false, (int)2, null)))) {
                        boolean bl2 = false;
                        String string2 = "Observed unexpected output: it";
                        throw new IllegalStateException(string2.toString());
                    }
                } else {
                    Shell.executeScriptSilent$default(Shell.INSTANCE, "cp " + configFilePath + ' ' + path, null, 2, null);
                }
                string = path;
            } else {
                string = configFilePath;
            }
            String actualConfigPath = string;
            String outputPath = this.getPerfettoTmpOutputFilePath();
            if (!this.unbundled && Build.VERSION.SDK_INT == 29) {
                Shell.Output output = Shell.executeScriptCaptureStdoutStderr$default(Shell.INSTANCE, "rm -f " + outputPath, null, 2, null);
                Log.d((String)LOG_TAG, (String)("Attempted to remove " + outputPath + ", result = " + output));
            } else {
                Shell.executeScriptSilent$default(Shell.INSTANCE, "rm -f " + outputPath, null, 2, null);
            }
            String perfettoCmd = this.perfettoCommand(actualConfigPath, isTextProtoConfig);
            Log.i((String)LOG_TAG, (String)("Starting perfetto tracing with cmd: " + perfettoCmd));
            String perfettoCmdOutput = ((Object)StringsKt.trim((CharSequence)Shell.executeScriptCaptureStdoutStderr$default(Shell.INSTANCE, perfettoCmd + "; echo EXITCODE=$?", null, 2, null).getStdout())).toString();
            String expectedSuffix = "\nEXITCODE=0";
            if (!StringsKt.endsWith$default((String)perfettoCmdOutput, (String)expectedSuffix, (boolean)false, (int)2, null)) {
                throw this.perfettoStartupException("Perfetto unexpected exit code, output = " + perfettoCmdOutput, null);
            }
            Log.i((String)LOG_TAG, (String)("Perfetto output - " + perfettoCmdOutput));
            this.perfettoPid = Integer.parseInt(StringsKt.removeSuffix((String)perfettoCmdOutput, (CharSequence)expectedSuffix));
        }
        catch (IOException ioe) {
            throw this.perfettoStartupException("Unable to start perfetto tracing", ioe);
        }
        if (!this.isRunning()) {
            throw this.perfettoStartupException("Perfetto tracing failed to start.", null);
        }
        Log.i((String)LOG_TAG, (String)("Perfetto tracing started successfully with pid " + this.perfettoPid + '.'));
        if (!this.useBackgroundWait) {
            this.checkTracingOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkTracingOn() {
        String label$iv = "poll tracing_on";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            String string;
            boolean bl = false;
            if (Shell.INSTANCE.pathExists(TRACING_ON_PATH)) {
                string = TRACING_ON_PATH;
            } else if (Shell.INSTANCE.pathExists(TRACING_ON_FALLBACK_PATH)) {
                string = TRACING_ON_FALLBACK_PATH;
            } else {
                throw this.perfettoStartupException("Unable to find path to tracing_on (e.g. /sys/kernel/tracing/tracing_on)", null);
            }
            String path = string;
            int pollTracingOnMaxCount = 50;
            long pollTracingOnMs = 100L;
            int n = 0;
            while (n < pollTracingOnMaxCount) {
                String label$iv2;
                int it = n++;
                boolean bl2 = false;
                String output = ((Object)StringsKt.trim((CharSequence)Shell.executeScriptCaptureStdout$default(Shell.INSTANCE, "cat " + path, null, 2, null))).toString();
                if (Intrinsics.areEqual((Object)output, (Object)"0")) {
                    label$iv2 = "wait for trace to start (tracing_on == 1)";
                    boolean $i$f$inMemoryTrace2 = false;
                    InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv2, 0L, 2, null);
                    try {
                        boolean bl3 = false;
                        SystemClock.sleep((long)pollTracingOnMs);
                        Unit unit = Unit.INSTANCE;
                        continue;
                    }
                    finally {
                        InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
                    }
                }
                if (Intrinsics.areEqual((Object)output, (Object)"1")) {
                    Log.i((String)LOG_TAG, (String)(path + " = 1, polled " + it + " times, capture fully started"));
                    label$iv2 = "Perfetto - capture started successfully";
                    boolean $i$f$trace = false;
                    try {
                        Trace.beginSection((String)label$iv2);
                        boolean bl4 = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        Trace.endSection();
                    }
                    return;
                }
                throw this.perfettoStartupException("Saw unexpected tracing_on contents: " + output, null);
            }
            long duration = pollTracingOnMs * (long)pollTracingOnMaxCount;
            throw this.perfettoStartupException("Error: did not detect tracing on after " + duration + " ms", null);
        }
        finally {
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
        }
    }

    public final boolean isRunning() {
        boolean bl;
        Integer n = this.perfettoPid;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = Shell.INSTANCE.isProcessAlive(it, this.perfettoProcessName);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopCollecting(@NotNull String destinationFile) {
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        Log.i((String)LOG_TAG, (String)"Stopping perfetto.");
        String label$iv = "stop perfetto process";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            this.stopPerfetto();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
        }
        Log.i((String)LOG_TAG, (String)("Writing to " + destinationFile + '.'));
        label$iv = "copy trace to output dir";
        $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            boolean bl2 = this.copyFileOutput(destinationFile);
        }
        finally {
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopPerfetto() {
        Integer pid = this.perfettoPid;
        String label$iv = "Perfetto - preparing to stop";
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Trace.endSection();
        }
        if (!(pid != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Shell.ProcessPid[] processPidArray = new Shell.ProcessPid[1];
        String string = this.perfettoProcessName;
        processPidArray[0] = new Shell.ProcessPid(string, pid);
        Shell.INSTANCE.terminateProcessesAndWait(100L, 50, processPidArray);
        this.perfettoPid = null;
    }

    private final String perfettoCommand(String configFilePath, boolean isTextProtoConfig) {
        String command2;
        String outputPath = this.getPerfettoTmpOutputFilePath();
        String backgroundArg = this.useBackgroundWait ? "--background-wait" : "--background";
        String string = command2 = !this.unbundled ? "cat " + configFilePath + " | perfetto " + backgroundArg + " -c - -o " + outputPath : Companion.getUnbundledPerfettoShellPath() + ' ' + backgroundArg + " -c " + configFilePath + " -o " + outputPath;
        if (isTextProtoConfig) {
            command2 = command2 + PERFETTO_TXT_PROTO_ARG;
        }
        return command2;
    }

    private final String getPerfettoTmpOutputFilePath() {
        return this.unbundled ? UNBUNDLED_TEMP_OUTPUT_FILE : PERFETTO_TMP_OUTPUT_FILE;
    }

    private final boolean copyFileOutput(String destinationFile) {
        boolean success;
        File directory;
        String sourceFile = this.getPerfettoTmpOutputFilePath();
        File filePath = new File(destinationFile);
        filePath.setWritable(true, false);
        String destDirectory = filePath.getParent();
        if (destDirectory != null && !(directory = new File(destDirectory)).exists() && !(success = directory.mkdirs())) {
            Log.e((String)LOG_TAG, (String)("Result output directory " + destDirectory + " not created successfully."));
            return false;
        }
        try {
            Shell.Output copyResult = Shell.executeScriptCaptureStdoutStderr$default(Shell.INSTANCE, "cp " + sourceFile + ' ' + destinationFile, null, 2, null);
            if (!copyResult.isBlank()) {
                Log.e((String)LOG_TAG, (String)StringsKt.trimIndent((String)("\n                        Unable to copy perfetto output file from " + sourceFile + "\n                        to " + destinationFile + " due to " + copyResult + ".\n                    ")));
                return false;
            }
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)"Unable to move the perfetto trace file to destination file.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    public PerfettoHelper() {
        this(false, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"arm64-v8a", "x86_64"};
        SUPPORTED_64_ABIS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"armeabi", "x86"};
        SUPPORTED_32_ABIS = SetsKt.setOf((Object[])objectArray);
        unbundledPerfettoShellPath$delegate = LazyKt.lazy((Function0)Companion.unbundledPerfettoShellPath.2.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/perfetto/PerfettoHelper$Companion;", "", "()V", "LOG_TAG", "", "MIN_BUNDLED_SDK_VERSION", "", "MIN_SDK_VERSION", "PERFETTO_KILL_WAIT_COUNT", "PERFETTO_KILL_WAIT_TIME_MS", "", "PERFETTO_TMP_OUTPUT_FILE", "PERFETTO_TXT_PROTO_ARG", "SUPPORTED_32_ABIS", "", "SUPPORTED_64_ABIS", "TRACING_ON_FALLBACK_PATH", "TRACING_ON_PATH", "UNBUNDLED_PERFETTO_ROOT_DIR", "UNBUNDLED_TEMP_OUTPUT_FILE", "unbundledPerfettoShellPath", "getUnbundledPerfettoShellPath", "()Ljava/lang/String;", "unbundledPerfettoShellPath$delegate", "Lkotlin/Lazy;", "createExecutable", "tool", "isAbiSupported", "", "stopAllPerfettoProcesses", "", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nPerfettoHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoHelper.kt\nandroidx/benchmark/perfetto/PerfettoHelper$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,470:1\n12474#2,2:471\n12474#2,2:473\n12474#2,2:478\n12474#2,2:480\n12474#2,2:482\n12474#2,2:484\n141#3,3:475\n145#3,2:486\n1855#4,2:488\n*S KotlinDebug\n*F\n+ 1 PerfettoHelper.kt\nandroidx/benchmark/perfetto/PerfettoHelper$Companion\n*L\n405#1:471,2\n406#1:473,2\n426#1:478,2\n427#1:480,2\n428#1:482,2\n429#1:484,2\n415#1:475,3\n415#1:486,2\n442#1:488,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAbiSupported() {
            String it;
            StringBuilder stringBuilder = new StringBuilder().append("Supported ABIs: ");
            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
            Log.d((String)PerfettoHelper.LOG_TAG, (String)stringBuilder.append(ArraysKt.joinToString$default((Object[])Build.SUPPORTED_ABIS, null, null, null, (int)0, null, null, (int)63, null)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_64_BIT_ABIS, (String)"SUPPORTED_64_BIT_ABIS");
            Object[] $this$any$iv = Build.SUPPORTED_64_BIT_ABIS;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                it = (String)element$iv;
                boolean bl = false;
                if (!SUPPORTED_64_ABIS.contains(it)) continue;
                return true;
            }
            boolean bl = false;
            if (bl) return true;
            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_32_BIT_ABIS, (String)"SUPPORTED_32_BIT_ABIS");
            $this$any$iv = Build.SUPPORTED_32_BIT_ABIS;
            $i$f$any = false;
            int n = 0;
            int n2 = $this$any$iv.length;
            while (n < n2) {
                Object element$iv;
                element$iv = $this$any$iv[n];
                it = (String)element$iv;
                boolean bl2 = false;
                if (SUPPORTED_32_ABIS.contains(it)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        @NotNull
        public final String getUnbundledPerfettoShellPath() {
            Lazy lazy = unbundledPerfettoShellPath$delegate;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String createExecutable(@NotNull String tool) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            String label$iv = "create executable: " + tool;
            boolean $i$f$inMemoryTrace = false;
            InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, 2, null);
            try {
                Serializable serializable;
                boolean bl;
                String it;
                boolean $i$f$any;
                Object[] $this$any$iv;
                block16: {
                    boolean bl2 = false;
                    if (!Companion.isAbiSupported()) {
                        StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
                        Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
                        throw new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])Build.SUPPORTED_ABIS, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_64_BIT_ABIS, (String)"SUPPORTED_64_BIT_ABIS");
                    $this$any$iv = Build.SUPPORTED_64_BIT_ABIS;
                    $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.startsWith$default((String)it, (String)"x86_64", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
                if (bl) {
                    serializable = (Serializable)((Object)"x86_64");
                } else {
                    boolean bl4;
                    block17: {
                        Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_32_BIT_ABIS, (String)"SUPPORTED_32_BIT_ABIS");
                        $this$any$iv = Build.SUPPORTED_32_BIT_ABIS;
                        $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl5 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!StringsKt.startsWith$default((String)it, (String)"x86", (boolean)false, (int)2, null)) continue;
                            bl4 = true;
                            break block17;
                        }
                        bl4 = false;
                    }
                    if (bl4) {
                        serializable = (Serializable)((Object)"x86");
                    } else {
                        boolean bl6;
                        block18: {
                            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_64_BIT_ABIS, (String)"SUPPORTED_64_BIT_ABIS");
                            $this$any$iv = Build.SUPPORTED_64_BIT_ABIS;
                            $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl7 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                if (!StringsKt.startsWith$default((String)it, (String)"arm64", (boolean)false, (int)2, null)) continue;
                                bl6 = true;
                                break block18;
                            }
                            bl6 = false;
                        }
                        if (bl6) {
                            serializable = (Serializable)((Object)"aarch64");
                        } else {
                            boolean bl8;
                            block19: {
                                Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_32_BIT_ABIS, (String)"SUPPORTED_32_BIT_ABIS");
                                $this$any$iv = Build.SUPPORTED_32_BIT_ABIS;
                                $i$f$any = false;
                                for (Object element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    boolean bl9 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                    if (!StringsKt.startsWith$default((String)it, (String)"armeabi", (boolean)false, (int)2, null)) continue;
                                    bl8 = true;
                                    break block19;
                                }
                                bl8 = false;
                            }
                            if (bl8) {
                                serializable = (Serializable)((Object)"arm");
                            } else {
                                StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
                                Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
                                serializable = new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])Build.SUPPORTED_ABIS, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
                            }
                        }
                    }
                }
                Serializable suffix = serializable;
                Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
                InputStream inputStream = instrumentation.getContext().getAssets().open(tool + '_' + suffix);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"instrumentation.context.\u2026s.open(\"${tool}_$suffix\")");
                InputStream inputStream2 = inputStream;
                String string = Shell.INSTANCE.createRunnableExecutable(tool, inputStream2);
                return string;
            }
            finally {
                InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
            }
        }

        public final void stopAllPerfettoProcesses() {
            Shell.Output output;
            Object[] objectArray = new String[]{"perfetto", "tracebox"};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String processName = (String)element$iv;
                boolean bl = false;
                Shell.INSTANCE.terminateProcessesAndWait(100L, 50, processName);
            }
            if (Build.VERSION.SDK_INT < 29 && !(StringsKt.isBlank((CharSequence)(output = Shell.executeScriptCaptureStdoutStderr$default(Shell.INSTANCE, this.getUnbundledPerfettoShellPath() + " traced_probes --cleanup-after-crash", null, 2, null)).getStderr()) || StringsKt.contains$default((CharSequence)output.getStderr(), (CharSequence)"Hard resetting ftrace state", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string = "Unexpected output from --cleanup-after-crash: " + output;
                throw new IllegalStateException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

