/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.Profiler;
import androidx.benchmark.ProfilerKt;
import androidx.benchmark.vmtrace.ArtTrace;
import java.io.File;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Landroidx/benchmark/MethodTracing;", "Landroidx/benchmark/Profiler;", "()V", "<set-?>", "", "hasBeenUsed", "getHasBeenUsed", "()Z", "requiresSingleMeasurementIteration", "getRequiresSingleMeasurementIteration", "embedInPerfettoTrace", "", "profilerTrace", "Ljava/io/File;", "perfettoTrace", "start", "Landroidx/benchmark/Profiler$ResultFile;", "traceUniqueName", "", "stop", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Profiler.kt\nandroidx/benchmark/MethodTracing\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n*L\n1#1,365:1\n141#2,6:366\n141#2,6:372\n*S KotlinDebug\n*F\n+ 1 Profiler.kt\nandroidx/benchmark/MethodTracing\n*L\n234#1:366,6\n244#1:372,6\n*E\n"})
public final class MethodTracing
extends Profiler {
    @NotNull
    public static final MethodTracing INSTANCE = new MethodTracing();
    private static final boolean requiresSingleMeasurementIteration = true;
    private static boolean hasBeenUsed;

    private MethodTracing() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Profiler.ResultFile start(@NotNull String traceUniqueName) {
        Intrinsics.checkNotNullParameter((Object)traceUniqueName, (String)"traceUniqueName");
        hasBeenUsed = true;
        String label$iv = "startMethodTrace";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            Profiler.ResultFile resultFile = ProfilerKt.startRuntimeMethodTracing(Profiler.Companion.traceName(traceUniqueName, "methodTracing"), false, this);
            return resultFile;
        }
        finally {
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        String label$iv = "stopMethodTrace";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, 2, null);
        try {
            boolean bl = false;
            ProfilerKt.stopRuntimeMethodTracing();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
        }
    }

    @Override
    public boolean getRequiresSingleMeasurementIteration() {
        return requiresSingleMeasurementIteration;
    }

    @Override
    public void embedInPerfettoTrace(@NotNull File profilerTrace, @NotNull File perfettoTrace) {
        Intrinsics.checkNotNullParameter((Object)profilerTrace, (String)"profilerTrace");
        Intrinsics.checkNotNullParameter((Object)perfettoTrace, (String)"perfettoTrace");
        new ArtTrace(profilerTrace, null, 0, 6, null).writeAsPerfettoTrace(new FileOutputStream(perfettoTrace, true));
    }

    public final boolean getHasBeenUsed() {
        return hasBeenUsed;
    }
}

