/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.simpleperf;

import android.system.Os;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=28)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RecordOptions {
    @Nullable
    private String mOutputFilename;
    @NonNull
    private String mEvent = "cpu-cycles";
    private int mFreq = 4000;
    private double mDurationInSeconds = 0.0;
    @NonNull
    private final ArrayList<Integer> mThreads = new ArrayList();
    private boolean mDwarfCallGraph = false;
    private boolean mFpCallGraph = false;
    private boolean mTraceOffCpu = false;

    @NonNull
    public RecordOptions setOutputFilename(@NonNull String filename) {
        this.mOutputFilename = filename;
        return this;
    }

    @NonNull
    public RecordOptions setEvent(@NonNull String event) {
        this.mEvent = event;
        return this;
    }

    @NonNull
    public RecordOptions setSampleFrequency(int freq) {
        this.mFreq = freq;
        return this;
    }

    @NonNull
    public RecordOptions setDuration(double durationInSecond) {
        this.mDurationInSeconds = durationInSecond;
        return this;
    }

    @NonNull
    public RecordOptions setSampleThreads(@NonNull List<Integer> threads) {
        this.mThreads.addAll(threads);
        return this;
    }

    @NonNull
    public RecordOptions setSampleCurrentThread() {
        return this.setSampleThreads(Collections.singletonList(Os.gettid()));
    }

    @NonNull
    public RecordOptions recordDwarfCallGraph() {
        this.mDwarfCallGraph = true;
        this.mFpCallGraph = false;
        return this;
    }

    @NonNull
    public RecordOptions recordFramePointerCallGraph() {
        this.mFpCallGraph = true;
        this.mDwarfCallGraph = false;
        return this;
    }

    @NonNull
    public RecordOptions traceOffCpu() {
        this.mTraceOffCpu = true;
        return this;
    }

    @NonNull
    public List<String> toRecordArgs() {
        ArrayList<String> args = new ArrayList<String>();
        String filename = this.mOutputFilename;
        if (filename == null) {
            filename = this.getDefaultOutputFilename();
        }
        args.add("-o");
        args.add(filename);
        args.add("-e");
        args.add(this.mEvent);
        args.add("-f");
        args.add(String.valueOf(this.mFreq));
        if (this.mDurationInSeconds != 0.0) {
            args.add("--duration");
            args.add(String.valueOf(this.mDurationInSeconds));
        }
        if (this.mThreads.isEmpty()) {
            args.add("-p");
            args.add(String.valueOf(Os.getpid()));
        } else {
            String s = "";
            for (int i = 0; i < this.mThreads.size(); ++i) {
                if (i > 0) {
                    s = s + ",";
                }
                s = s + this.mThreads.get(i).toString();
            }
            args.add("-t");
            args.add(s);
        }
        if (this.mDwarfCallGraph) {
            args.add("-g");
        } else if (this.mFpCallGraph) {
            args.add("--call-graph");
            args.add("fp");
        }
        if (this.mTraceOffCpu) {
            args.add("--trace-offcpu");
        }
        return args;
    }

    private String getDefaultOutputFilename() {
        LocalDateTime time = LocalDateTime.now(ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("'perf'-MM-dd-HH-mm-ss'.data'");
        return time.format(formatter);
    }
}

