/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.CpuCounterJni;
import androidx.benchmark.CpuEventCounterKt;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.PropOverride;
import androidx.benchmark.Shell;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u000f\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/CpuEventCounter;", "Ljava/io/Closeable;", "()V", "hasReset", "", "profilerPtr", "", "close", "", "read", "outValues", "Landroidx/benchmark/CpuEventCounter$Values;", "read-BCzuEqQ", "([J)V", "reset", "resetEvents", "eventFlags", "", "events", "", "Landroidx/benchmark/CpuEventCounter$Event;", "start", "stop", "Companion", "Event", "Values", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nCpuEventCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuEventCounter.kt\nandroidx/benchmark/CpuEventCounter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class CpuEventCounter
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long profilerPtr = CpuCounterJni.INSTANCE.newProfiler();
    private boolean hasReset;

    public final void resetEvents(@NotNull List<? extends Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        this.resetEvents(CpuEventCounterKt.getFlags(events));
    }

    public final void resetEvents(int eventFlags) {
        this.hasReset = true;
        CpuCounterJni.INSTANCE.resetEvents(this.profilerPtr, eventFlags);
    }

    @Override
    public void close() {
        CpuCounterJni.INSTANCE.freeProfiler(this.profilerPtr);
        this.profilerPtr = 0L;
    }

    public final void reset() {
        CpuCounterJni.INSTANCE.reset(this.profilerPtr);
    }

    public final void start() {
        CpuCounterJni.INSTANCE.start(this.profilerPtr);
    }

    public final void stop() {
        CpuCounterJni.INSTANCE.stop(this.profilerPtr);
    }

    public final void read-BCzuEqQ(@NotNull long[] outValues) {
        Intrinsics.checkNotNullParameter((Object)outValues, (String)"outValues");
        if (!(this.profilerPtr != 0L)) {
            boolean $i$a$-check-CpuEventCounter$read$32 = false;
            String $i$a$-check-CpuEventCounter$read$32 = "Error: attempted to read counters after close";
            throw new IllegalStateException($i$a$-check-CpuEventCounter$read$32.toString());
        }
        if (!this.hasReset) {
            boolean bl = false;
            String string = "Error: attempted to read counters without reset";
            throw new IllegalStateException(string.toString());
        }
        CpuCounterJni.INSTANCE.read(this.profilerPtr, outValues);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Landroidx/benchmark/CpuEventCounter$Companion;", "", "()V", "checkPerfEventSupport", "", "forceEnable", "reset", "", "Api29Enabler", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String checkPerfEventSupport() {
            return CpuCounterJni.INSTANCE.checkPerfEventSupport();
        }

        @Nullable
        public final String forceEnable() {
            String string;
            if (Build.VERSION.SDK_INT >= 29 && (string = Api29Enabler.INSTANCE.forceEnable()) != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
            return this.checkPerfEventSupport();
        }

        public final void reset() {
            if (Build.VERSION.SDK_INT >= 29) {
                Api29Enabler.INSTANCE.reset();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/CpuEventCounter$Companion$Api29Enabler;", "", "()V", "perfHardenProp", "Landroidx/benchmark/PropOverride;", "shouldResetEnforce1", "", "forceEnable", "", "reset", "", "benchmark-common_release"})
        @RequiresApi(value=29)
        public static final class Api29Enabler {
            @NotNull
            public static final Api29Enabler INSTANCE = new Api29Enabler();
            @NotNull
            private static final PropOverride perfHardenProp = new PropOverride("security.perf_harden", "0");
            private static boolean shouldResetEnforce1;

            private Api29Enabler() {
            }

            @Nullable
            public final String forceEnable() {
                if (Shell.INSTANCE.isSELinuxEnforced()) {
                    if (DeviceInfo.INSTANCE.isRooted()) {
                        Shell.executeScriptSilent$default(Shell.INSTANCE, "setenforce 0", null, 2, null);
                        shouldResetEnforce1 = true;
                    } else {
                        return "blocked by selinux, can't `setenforce 0` without rooted device";
                    }
                }
                perfHardenProp.forceValue();
                return null;
            }

            public final void reset() {
                perfHardenProp.resetIfOverridden();
                if (shouldResetEnforce1) {
                    Shell.executeScriptSilent$default(Shell.INSTANCE, "setenforce 1", null, 2, null);
                    shouldResetEnforce1 = false;
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Landroidx/benchmark/CpuEventCounter$Event;", "", "id", "", "(Ljava/lang/String;II)V", "flag", "getFlag", "()I", "getId", "Instructions", "CpuCycles", "L1DReferences", "L1DMisses", "BranchInstructions", "BranchMisses", "L1IReferences", "L1IMisses", "benchmark-common_release"})
    public static final class Event
    extends Enum<Event> {
        private final int id;
        public static final /* enum */ Event Instructions = new Event(0);
        public static final /* enum */ Event CpuCycles = new Event(1);
        public static final /* enum */ Event L1DReferences = new Event(2);
        public static final /* enum */ Event L1DMisses = new Event(3);
        public static final /* enum */ Event BranchInstructions = new Event(4);
        public static final /* enum */ Event BranchMisses = new Event(5);
        public static final /* enum */ Event L1IReferences = new Event(6);
        public static final /* enum */ Event L1IMisses = new Event(7);
        private static final /* synthetic */ Event[] $VALUES;

        private Event(int id) {
            this.id = id;
        }

        public final int getId() {
            return this.id;
        }

        public final int getFlag() {
            boolean $i$f$getFlag = false;
            return 1 << this.getId();
        }

        public static Event[] values() {
            return (Event[])$VALUES.clone();
        }

        public static Event valueOf(String value) {
            return Enum.valueOf(Event.class, value);
        }

        static {
            $VALUES = eventArray = new Event[]{Event.Instructions, Event.CpuCycles, Event.L1DReferences, Event.L1DMisses, Event.BranchInstructions, Event.BranchMisses, Event.L1IReferences, Event.L1IMisses};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087@\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\b\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\t8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\t8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u0088\u0001\u0002\u00a8\u0006\""}, d2={"Landroidx/benchmark/CpuEventCounter$Values;", "", "longArray", "", "constructor-impl", "([J)[J", "getLongArray", "()[J", "numberOfCounters", "", "getNumberOfCounters-impl", "([J)J", "timeEnabled", "getTimeEnabled-impl", "timeRunning", "getTimeRunning-impl", "equals", "", "other", "equals-impl", "([JLjava/lang/Object;)Z", "getValue", "spec", "Landroidx/benchmark/CpuEventCounter$Event;", "getValue-impl", "([JLandroidx/benchmark/CpuEventCounter$Event;)J", "hashCode", "", "hashCode-impl", "([J)I", "toString", "", "toString-impl", "([J)Ljava/lang/String;", "benchmark-common_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Values {
        @NotNull
        private final long[] longArray;

        @NotNull
        public final long[] getLongArray() {
            return this.longArray;
        }

        public static final long getNumberOfCounters-impl(long[] arg0) {
            boolean bl = false;
            return arg0[0];
        }

        public static final long getTimeEnabled-impl(long[] arg0) {
            boolean bl = false;
            return arg0[1];
        }

        public static final long getTimeRunning-impl(long[] arg0) {
            boolean bl = false;
            return arg0[2];
        }

        public static final long getValue-impl(long[] arg0, @NotNull Event spec) {
            Intrinsics.checkNotNullParameter((Object)((Object)spec), (String)"spec");
            boolean bl = false;
            return arg0[3 + 2 * spec.getId()];
        }

        public static String toString-impl(long[] arg0) {
            return "Values(longArray=" + Arrays.toString(arg0) + ')';
        }

        public String toString() {
            return Values.toString-impl(this.longArray);
        }

        public static int hashCode-impl(long[] arg0) {
            return Arrays.hashCode(arg0);
        }

        public int hashCode() {
            return Values.hashCode-impl(this.longArray);
        }

        public static boolean equals-impl(long[] arg0, Object other) {
            if (!(other instanceof Values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((Values)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return Values.equals-impl(this.longArray, other);
        }

        private /* synthetic */ Values(long[] longArray) {
            this.longArray = longArray;
        }

        @NotNull
        public static long[] constructor-impl(@NotNull long[] longArray) {
            Intrinsics.checkNotNullParameter((Object)longArray, (String)"longArray");
            long[] lArray = longArray;
            if (!(lArray.length == 19)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return lArray;
        }

        public static /* synthetic */ long[] constructor-impl$default(long[] lArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                lArray = new long[19];
            }
            return Values.constructor-impl(lArray);
        }

        public static final /* synthetic */ Values box-impl(long[] v) {
            return new Values(v);
        }

        public final /* synthetic */ long[] unbox-impl() {
            return this.longArray;
        }

        public static final boolean equals-impl0(long[] p1, long[] p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }
    }
}

